/*
 * Decompiled with CFR 0.152.
 */
package lykrast.meetyourfight.entity;

import java.util.EnumSet;
import java.util.Random;
import lykrast.meetyourfight.MeetYourFight;
import lykrast.meetyourfight.entity.BossEntity;
import lykrast.meetyourfight.entity.ProjectileLineEntity;
import lykrast.meetyourfight.entity.ai.VexMoveRandomGoal;
import lykrast.meetyourfight.entity.movement.VexMovementController;
import lykrast.meetyourfight.registry.ModEntities;
import lykrast.meetyourfight.registry.ModSounds;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.EvokerFangsEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class DameFortunaEntity
extends BossEntity {
    private static final DataParameter<Byte> ATTACK = EntityDataManager.func_187226_a(DameFortunaEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    public static final int NO_ATTACK = 0;
    public static final int PROJ_ATTACK = 1;
    public static final int CLAW_ATTACK = 2;
    public int attackCooldown;

    public DameFortunaEntity(EntityType<? extends DameFortunaEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new VexMovementController((MobEntity)this);
        this.field_70728_aV = 100;
    }

    public void func_213315_a(MoverType typeIn, Vector3d pos) {
        super.func_213315_a(typeIn, pos);
        this.func_145775_I();
    }

    public void func_70071_h_() {
        this.field_70145_X = true;
        super.func_70071_h_();
        this.field_70145_X = false;
        this.func_189654_d(true);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new RegularAttack(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new MoveAroundTarget((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new VexMoveRandomGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 300.0).func_233815_a_(Attributes.field_233826_i_, 5.0).func_233815_a_(Attributes.field_233819_b_, 64.0);
    }

    public static void spawn(PlayerEntity player, World world) {
        Random rand = player.func_70681_au();
        DameFortunaEntity dame = (DameFortunaEntity)ModEntities.DAME_FORTUNA.func_200721_a(world);
        dame.func_70012_b(player.func_226277_ct_() + (double)rand.nextInt(5) - 2.0, player.func_226278_cu_() + (double)rand.nextInt(3) + 3.0, player.func_226281_cx_() + (double)rand.nextInt(5) - 2.0, rand.nextFloat() * 360.0f - 180.0f, 0.0f);
        dame.attackCooldown = 100;
        if (!player.field_71075_bZ.field_75098_d) {
            dame.func_70624_b((LivingEntity)player);
        }
        dame.func_195064_c(new EffectInstance(Effects.field_76429_m, 100, 2));
        dame.func_213386_a((IServerWorld)((ServerWorld)world), world.func_175649_E(dame.func_233580_cy_()), SpawnReason.EVENT, null, null);
        world.func_217376_c((Entity)dame);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACK, (Object)0);
    }

    public int getAttack() {
        return ((Byte)this.field_70180_af.func_187225_a(ATTACK)).byteValue();
    }

    public void setAttack(int attack) {
        this.field_70180_af.func_187227_b(ATTACK, (Object)((byte)attack));
    }

    private int getRage() {
        float third;
        float health = this.func_110143_aJ();
        if (health <= (third = this.func_110138_aP() / 3.0f)) {
            return 2;
        }
        if (health >= third * 2.0f) {
            return 0;
        }
        return 1;
    }

    @Override
    public void func_70619_bc() {
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        super.func_70619_bc();
    }

    private ProjectileLineEntity readyLine() {
        ProjectileLineEntity proj = new ProjectileLineEntity(this.field_70170_p, (LivingEntity)this, 0.0, 0.0, 0.0);
        proj.func_212361_a((Entity)this);
        proj.func_70107_b(this.func_226277_ct_(), this.func_226280_cw_() + 1.0, this.func_226281_cx_());
        proj.setVariant(1);
        return proj;
    }

    private void spawnFangs(double posX, double posZ, double minY, double minZ, float rotationRad, int delay) {
        BlockPos blockpos = new BlockPos(posX, minZ, posZ);
        boolean success = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = this.field_70170_p.func_180495_p(blockpos1 = blockpos.func_177977_b())).func_224755_d((IBlockReader)this.field_70170_p, blockpos1, Direction.UP)) continue;
            if (!this.field_70170_p.func_175623_d(blockpos) && !(voxelshape = (blockstate1 = this.field_70170_p.func_180495_p(blockpos)).func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b()) {
                d0 = voxelshape.func_197758_c(Direction.Axis.Y);
            }
            success = true;
            break;
        } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)minY) - 1);
        if (success) {
            this.field_70170_p.func_217376_c((Entity)new EvokerFangsEntity(this.field_70170_p, posX, (double)blockpos.func_177956_o() + d0, posZ, rotationRad, delay, (LivingEntity)this));
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("AttackCooldown")) {
            this.attackCooldown = compound.func_74762_e("AttackCooldown");
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("AttackCooldown", this.attackCooldown);
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.dameFortunaIdle;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSounds.dameFortunaHurt;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.dameFortunaDeath;
    }

    @Override
    protected SoundEvent getMusic() {
        return ModSounds.musicDameFortuna;
    }

    protected ResourceLocation func_184647_J() {
        return MeetYourFight.rl("dame_fortuna");
    }

    private static class MoveAroundTarget
    extends Goal {
        private MobEntity mob;

        public MoveAroundTarget(MobEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
            this.mob = mob;
        }

        public boolean func_75250_a() {
            return this.mob.func_70638_az() != null && !this.mob.func_70605_aq().func_75640_a();
        }

        public void func_75249_e() {
            LivingEntity target = this.mob.func_70638_az();
            Random rand = this.mob.func_70681_au();
            float angle = (float)(rand.nextInt(5) + 2) * 10.0f * ((float)Math.PI / 180);
            if (rand.nextBoolean()) {
                angle *= -1.0f;
            }
            Vector3d offset = new Vector3d(this.mob.func_226277_ct_() - target.func_226277_ct_(), 0.0, this.mob.func_226281_cx_() - target.func_226281_cx_()).func_72432_b().func_178785_b(angle);
            double distance = rand.nextDouble() * 2.0 + 4.0;
            this.mob.func_70605_aq().func_75642_a(target.func_226277_ct_() + offset.field_72450_a * distance, target.func_226278_cu_() + 2.0 + rand.nextDouble() * 2.0, target.func_226281_cx_() + offset.field_72449_c * distance, 1.0);
        }

        public boolean func_75253_b() {
            return false;
        }
    }

    private static class RegularAttack
    extends Goal {
        private DameFortunaEntity dame;
        private LivingEntity target;
        private int attackRemaining;
        private int attackDelay;
        private int chosenAttack;

        public RegularAttack(DameFortunaEntity dame) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
            this.dame = dame;
        }

        public boolean func_75250_a() {
            return this.dame.attackCooldown <= 0 && this.dame.func_70638_az() != null && this.dame.func_70638_az().func_70089_S();
        }

        public void func_75249_e() {
            this.dame.attackCooldown = 2;
            this.target = this.dame.func_70638_az();
            this.chosenAttack = this.dame.field_70146_Z.nextInt(4);
            this.dame.setAttack(this.chosenAttack == 1 || this.chosenAttack == 2 ? 2 : 1);
            this.attackDelay = 30;
            this.attackRemaining = this.getAttackCount();
            this.dame.func_184185_a(ModSounds.dameFortunaAttack, this.dame.func_70599_aP(), this.dame.func_70647_i());
        }

        private int getAttackCount() {
            switch (this.chosenAttack) {
                case 0: {
                    return this.dame.getRage() >= 1 ? 24 : 16;
                }
                default: {
                    switch (this.dame.getRage()) {
                        case 1: {
                            return 4;
                        }
                        case 2: {
                            return 8;
                        }
                    }
                    return 3;
                }
                case 2: {
                    return 8 + this.dame.getRage();
                }
                case 3: 
            }
            return 4 + this.dame.getRage();
        }

        public void func_75246_d() {
            this.dame.attackCooldown = 2;
            --this.attackDelay;
            if (this.attackDelay <= 0) {
                --this.attackRemaining;
                this.performAttack();
                if (this.attackRemaining <= 0) {
                    this.func_75251_c();
                }
            }
        }

        private void performAttack() {
            double tx = this.target.func_226277_ct_();
            double ty = this.target.func_226278_cu_();
            double tz = this.target.func_226281_cx_();
            switch (this.chosenAttack) {
                default: {
                    this.attackDelay = 3;
                    float angle = MathHelper.func_76142_g((float)((float)this.attackRemaining * 45.0f)) * ((float)Math.PI / 180);
                    ProjectileLineEntity proj = this.dame.readyLine();
                    proj.setUpTowards(9, this.dame.func_226277_ct_() + (double)(MathHelper.func_76126_a((float)angle) * 4.0f), this.dame.func_226278_cu_() + 6.0, this.dame.func_226281_cx_() + (double)(MathHelper.func_76134_b((float)angle) * 4.0f), tx + (double)this.dame.field_70146_Z.nextInt(3) - 1.0, ty + 1.0, tz + (double)this.dame.field_70146_Z.nextInt(3) - 1.0, this.dame.getRage() >= 2 ? 3.0 : 2.0);
                    this.dame.field_70170_p.func_217376_c((Entity)proj);
                    this.dame.func_184185_a(ModSounds.dameFortunaShoot, 2.0f, (this.dame.field_70146_Z.nextFloat() - this.dame.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                    break;
                }
                case 1: {
                    this.attackDelay = this.dame.getRage() >= 2 ? 10 : 20;
                    double minY = Math.min(ty, this.dame.func_226278_cu_());
                    double maxY = Math.max(ty, this.dame.func_226278_cu_()) + 1.0;
                    float angle = (float)MathHelper.func_181159_b((double)(tz - this.dame.func_226281_cx_()), (double)(tx - this.dame.func_226277_ct_()));
                    for (int i = 0; i < 16; ++i) {
                        double dist = 1.25 * (double)(i + 1);
                        this.dame.spawnFangs(this.dame.func_226277_ct_() + (double)MathHelper.func_76134_b((float)angle) * dist, this.dame.func_226281_cx_() + (double)MathHelper.func_76126_a((float)angle) * dist, minY, maxY, angle, i);
                    }
                    break;
                }
                case 2: {
                    this.attackDelay = 10;
                    double minY = Math.min(ty, this.dame.func_226278_cu_());
                    double maxY = Math.max(ty, this.dame.func_226278_cu_()) + 1.0;
                    float angle = (float)MathHelper.func_181159_b((double)(tz - this.dame.func_226281_cx_()), (double)(tx - this.dame.func_226277_ct_()));
                    this.dame.spawnFangs(tx, tz, minY, maxY, angle, 0);
                    break;
                }
                case 3: {
                    this.attackDelay = 20;
                    for (int x = -3; x <= 3; ++x) {
                        for (int z = -3; z <= 3; ++z) {
                            if ((x + z + 6) % 2 != this.attackRemaining % 2) continue;
                            ProjectileLineEntity proj = this.dame.readyLine();
                            proj.setUp(15, 0.0, -1.0, 0.0, tx + (double)x * 1.5, ty + 7.0, tz + (double)z * 1.5);
                            this.dame.field_70170_p.func_217376_c((Entity)proj);
                        }
                    }
                    this.dame.func_184185_a(ModSounds.dameFortunaShoot, 2.0f, (this.dame.field_70146_Z.nextFloat() - this.dame.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                }
            }
        }

        public void func_75251_c() {
            this.dame.attackCooldown = 40 + this.dame.field_70146_Z.nextInt(21);
            this.dame.setAttack(0);
        }

        public boolean func_75253_b() {
            return this.attackRemaining > 0 && this.target.func_70089_S();
        }
    }
}

