/*
 * Decompiled with CFR 0.152.
 */
package lykrast.meetyourfight.entity;

import javax.annotation.Nonnull;
import lykrast.meetyourfight.registry.ModEntities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;

public class ProjectileLineEntity
extends DamagingProjectileEntity {
    private static final DataParameter<Integer> PROJECTILE_VARIANT = EntityDataManager.func_187226_a(ProjectileLineEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final int VAR_BELLRINGER = 0;
    public static final int VAR_DAME_FORTUNA = 1;
    private double dirX;
    private double dirY;
    private double dirZ;
    private double startX;
    private double startY;
    private double startZ;
    private int timer;
    private boolean fired;

    public ProjectileLineEntity(EntityType<? extends ProjectileLineEntity> type, World world) {
        super(type, world);
    }

    public ProjectileLineEntity(World worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super(ModEntities.PROJECTILE_LINE, shooter, accelX, accelY, accelZ, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PROJECTILE_VARIANT, (Object)0);
    }

    protected void func_213868_a(EntityRayTraceResult raytrace) {
        super.func_213868_a(raytrace);
        if (!this.field_70170_p.field_72995_K && this.fired) {
            Entity hit = raytrace.func_216348_a();
            Entity shooter = this.func_234616_v_();
            if (shooter instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)shooter;
                boolean wasHit = hit.func_70097_a(DamageSource.func_188403_a((Entity)this, (LivingEntity)livingentity).func_76349_b().func_82726_p(), 8.0f);
                if (wasHit && hit.func_70089_S()) {
                    this.func_174815_a(livingentity, hit);
                }
                this.func_70106_y();
            } else {
                boolean bl = hit.func_70097_a(DamageSource.field_76376_m, 5.0f);
            }
        }
    }

    public void setUp(int delay, double dirX, double dirY, double dirZ, double startX, double startY, double startZ) {
        this.fired = false;
        this.timer = delay;
        this.dirX = dirX;
        this.dirY = dirY;
        this.dirZ = dirZ;
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
    }

    public void setUpTowards(int delay, double startX, double startY, double startZ, double endX, double endY, double endZ, double speed) {
        Vector3d vec = new Vector3d(endX - startX, endY - startY, endZ - startZ).func_72432_b().func_186678_a(speed);
        this.setUp(delay, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, startX, startY, startZ);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            --this.timer;
            if (this.timer <= 0) {
                if (this.fired) {
                    this.func_70106_y();
                } else {
                    this.fired = true;
                    this.func_213317_d(new Vector3d(0.0, 0.0, 0.0));
                    this.timer = 30;
                }
            }
            Vector3d motion = this.func_213322_ci();
            double d0 = this.func_226277_ct_();
            double d1 = this.func_226278_cu_();
            double d2 = this.func_226281_cx_();
            if (this.fired) {
                if (motion.func_189985_c() <= 16.0) {
                    this.func_213317_d(motion.func_72441_c(this.dirX * 0.1, this.dirY * 0.1, this.dirZ * 0.1));
                }
            } else {
                this.func_213317_d(new Vector3d(this.startX - d0, this.startY - d1, this.startZ - d2).func_186678_a(1.0 / (double)this.timer));
            }
        }
        Entity shooter = this.func_234616_v_();
        if (this.field_70170_p.field_72995_K || (shooter == null || !shooter.field_70128_L) && this.field_70170_p.func_175667_e(this.func_233580_cy_())) {
            this.superTick();
            RayTraceResult raytraceresult = ProjectileHelper.func_234618_a_((Entity)this, arg_0 -> ((ProjectileLineEntity)this).func_230298_a_(arg_0));
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((DamagingProjectileEntity)this, (RayTraceResult)raytraceresult)) {
                this.func_70227_a(raytraceresult);
            }
            this.func_145775_I();
            Vector3d vector3d = this.func_213322_ci();
            double d0 = this.func_226277_ct_() + vector3d.field_72450_a;
            double d1 = this.func_226278_cu_() + vector3d.field_72448_b;
            double d2 = this.func_226281_cx_() + vector3d.field_72449_c;
            ProjectileHelper.func_188803_a((Entity)this, (float)0.2f);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197624_q, d0, d1 + 0.5, d2, 0.0, 0.0, 0.0);
            this.func_70107_b(d0, d1, d2);
        } else {
            this.func_70106_y();
        }
    }

    private void superTick() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_225510_bt_());
        }
        this.func_70030_z();
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(PROJECTILE_VARIANT, (Object)variant);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(PROJECTILE_VARIANT);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74780_a("DX", this.dirX);
        compound.func_74780_a("DY", this.dirY);
        compound.func_74780_a("DZ", this.dirZ);
        compound.func_74780_a("SX", this.startX);
        compound.func_74780_a("SY", this.startY);
        compound.func_74780_a("SZ", this.startZ);
        compound.func_74768_a("Timer", this.timer);
        compound.func_74757_a("Fired", this.fired);
        compound.func_74768_a("Variant", this.getVariant());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.dirX = compound.func_74769_h("DX");
        this.dirY = compound.func_74769_h("DY");
        this.dirZ = compound.func_74769_h("DZ");
        this.startX = compound.func_74769_h("SX");
        this.startY = compound.func_74769_h("SY");
        this.startZ = compound.func_74769_h("SZ");
        this.timer = compound.func_74762_e("Timer");
        this.fired = compound.func_74767_n("Fired");
        this.setVariant(compound.func_74762_e("Variant"));
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    protected boolean func_184564_k() {
        return false;
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

