/*
 * Decompiled with CFR 0.152.
 */
package lykrast.meetyourfight.entity;

import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import lykrast.meetyourfight.MeetYourFight;
import lykrast.meetyourfight.entity.BossFlyingEntity;
import lykrast.meetyourfight.entity.SwampMineEntity;
import lykrast.meetyourfight.entity.ai.PhantomAttackPlayer;
import lykrast.meetyourfight.registry.ModEntities;
import lykrast.meetyourfight.registry.ModSounds;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SwampjawEntity
extends BossFlyingEntity {
    private int behavior;
    private static final int CIRCLE = 0;
    private static final int BOMB = 1;
    private static final int SWOOP = 2;
    private Vector3d orbitOffset = Vector3d.field_186680_a;
    private BlockPos orbitPosition = BlockPos.field_177992_a;
    public float tailYaw;
    public float tailPitch;

    public SwampjawEntity(EntityType<? extends SwampjawEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 30;
        this.field_70765_h = new MoveHelperController(this);
        this.tailYaw = this.field_70177_z;
        this.tailPitch = this.field_70125_A;
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 100.0).func_233815_a_(Attributes.field_233823_f_, 7.0);
    }

    public static void spawn(PlayerEntity player, World world) {
        Random rand = player.func_70681_au();
        SwampjawEntity fish = (SwampjawEntity)ModEntities.SWAMPJAW.func_200721_a(world);
        fish.func_70012_b(player.func_226277_ct_() + (double)rand.nextInt(5) - 2.0, player.func_226278_cu_() + (double)rand.nextInt(10) + 5.0, player.func_226281_cx_() + (double)rand.nextInt(5) - 2.0, rand.nextFloat() * 360.0f - 180.0f, 0.0f);
        if (!player.field_71075_bZ.field_75098_d) {
            fish.func_70624_b((LivingEntity)player);
        }
        fish.func_195064_c(new EffectInstance(Effects.field_76429_m, 100, 2));
        fish.func_213386_a((IServerWorld)((ServerWorld)world), world.func_175649_E(fish.func_233580_cy_()), SpawnReason.EVENT, null, null);
        world.func_217376_c((Entity)fish);
    }

    public void func_70071_h_() {
        this.field_70145_X = true;
        super.func_70071_h_();
        this.field_70145_X = false;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new PickAttackGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SweepAttackGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new BombMovementGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new OrbitPointGoal(this));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 16.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new PhantomAttackPlayer((MobEntity)this));
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.orbitPosition = this.func_233580_cy_().func_177981_b(5);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean func_213358_a(EntityType<?> typeIn) {
        return true;
    }

    public float getTailYaw(float partialTick) {
        return MathHelper.func_203303_c((float)this.tailYaw, (float)this.field_70177_z, (float)(6.0f * partialTick));
    }

    public float getTailPitch(float partialTick) {
        return MathHelper.func_203303_c((float)this.tailPitch, (float)this.field_70125_A, (float)(2.0f * partialTick));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            this.tailYaw = MathHelper.func_203303_c((float)this.tailYaw, (float)this.field_70177_z, (float)6.0f);
            this.tailPitch = MathHelper.func_203303_c((float)this.tailPitch, (float)this.field_70125_A, (float)2.0f);
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("AX")) {
            this.orbitPosition = new BlockPos(compound.func_74762_e("AX"), compound.func_74762_e("AY"), compound.func_74762_e("AZ"));
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("AX", this.orbitPosition.func_177958_n());
        compound.func_74768_a("AY", this.orbitPosition.func_177956_o());
        compound.func_74768_a("AZ", this.orbitPosition.func_177952_p());
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.swampjawIdle;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSounds.swampjawHurt;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.swampjawDeath;
    }

    @Override
    protected SoundEvent getMusic() {
        return ModSounds.musicSwampjaw;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    protected ResourceLocation func_184647_J() {
        return MeetYourFight.rl("swampjaw");
    }

    private static class PickAttackGoal
    extends Goal {
        private int tickDelay;
        private int bombLeft;
        private SwampjawEntity swampjaw;

        public PickAttackGoal(SwampjawEntity swampjaw) {
            this.swampjaw = swampjaw;
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.swampjaw.func_70638_az();
            return livingentity != null ? this.swampjaw.func_213344_a(this.swampjaw.func_70638_az(), PhantomAttackPlayer.DEFAULT_BUT_THROUGH_WALLS) : false;
        }

        public void func_75249_e() {
            this.tickDelay = 100;
            this.bombLeft = 3;
            this.swampjaw.behavior = 0;
            this.updateOrbit();
        }

        public void func_75251_c() {
        }

        public void func_75246_d() {
            if (this.swampjaw.behavior == 0 || this.swampjaw.behavior == 1) {
                --this.tickDelay;
                if (this.tickDelay <= 0) {
                    if (this.bombLeft <= 0) {
                        this.bombLeft = 3;
                        this.swampjaw.behavior = 2;
                        this.updateOrbit();
                        this.tickDelay = (4 + this.swampjaw.field_70146_Z.nextInt(4)) * 20;
                        this.swampjaw.func_184185_a(ModSounds.swampjawCharge, 10.0f, 0.95f + this.swampjaw.field_70146_Z.nextFloat() * 0.1f);
                    } else if (this.swampjaw.behavior == 0) {
                        this.swampjaw.behavior = 1;
                        this.tickDelay = 20;
                    } else if (this.tickDelay <= -120 || this.isTargetClose()) {
                        --this.bombLeft;
                        this.tickDelay = this.bombLeft <= 0 ? 30 + this.swampjaw.field_70146_Z.nextInt(30) : 20;
                        this.updateOrbit();
                        this.swampjaw.func_184185_a(ModSounds.swampjawBomb, 10.0f, 0.95f + this.swampjaw.field_70146_Z.nextFloat() * 0.1f);
                        SwampMineEntity tntentity = new SwampMineEntity(this.swampjaw.field_70170_p, this.swampjaw.func_226277_ct_() + 0.5, this.swampjaw.func_226278_cu_(), this.swampjaw.func_226281_cx_() + 0.5, (LivingEntity)this.swampjaw);
                        Vector3d motion = this.swampjaw.func_213322_ci();
                        tntentity.func_213317_d(tntentity.func_213322_ci().func_72441_c(motion.field_72450_a * 0.5, 0.0, motion.field_72449_c * 0.5));
                        this.swampjaw.field_70170_p.func_217376_c((Entity)tntentity);
                    }
                }
            }
        }

        private boolean isTargetClose() {
            double dz;
            LivingEntity target = this.swampjaw.func_70638_az();
            if (target == null) {
                return false;
            }
            double dx = target.func_226277_ct_() - (this.swampjaw.func_226277_ct_() + this.swampjaw.func_213322_ci().field_72450_a);
            return dx * dx + (dz = target.func_226281_cx_() - (this.swampjaw.func_226281_cx_() + this.swampjaw.func_213322_ci().field_72449_c)) * dz < 12.0;
        }

        private void updateOrbit() {
            this.swampjaw.orbitPosition = this.swampjaw.func_70638_az().func_233580_cy_().func_177981_b(14 + this.swampjaw.field_70146_Z.nextInt(6));
        }
    }

    private static class SweepAttackGoal
    extends BaseMoveGoal {
        public SweepAttackGoal(SwampjawEntity swampjaw) {
            super(swampjaw);
        }

        public boolean func_75250_a() {
            return this.swampjaw.func_70638_az() != null && this.swampjaw.behavior == 2;
        }

        public boolean func_75253_b() {
            LivingEntity livingentity = this.swampjaw.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            if (!(livingentity instanceof PlayerEntity) || !((PlayerEntity)livingentity).func_175149_v() && !((PlayerEntity)livingentity).func_184812_l_()) {
                return this.func_75250_a();
            }
            return false;
        }

        public void func_75251_c() {
            this.swampjaw.behavior = 0;
        }

        public void func_75246_d() {
            LivingEntity livingentity = this.swampjaw.func_70638_az();
            this.swampjaw.orbitOffset = new Vector3d(livingentity.func_226277_ct_(), livingentity.func_226283_e_(0.5), livingentity.func_226281_cx_());
            if (this.swampjaw.func_174813_aQ().func_186662_g(0.2).func_72326_a(livingentity.func_174813_aQ())) {
                this.swampjaw.func_70652_k((Entity)livingentity);
                this.swampjaw.behavior = 0;
            } else if (this.swampjaw.field_70737_aN > 0) {
                this.swampjaw.behavior = 0;
            }
        }
    }

    private static class BombMovementGoal
    extends BaseMoveGoal {
        public BombMovementGoal(SwampjawEntity swampjaw) {
            super(swampjaw);
        }

        public boolean func_75250_a() {
            return this.swampjaw.func_70638_az() != null && this.swampjaw.behavior == 1;
        }

        public void func_75249_e() {
            this.updateOffset();
        }

        public void func_75246_d() {
            if (this.isCloseToOffset()) {
                this.updateOffset();
            }
        }

        private void updateOffset() {
            LivingEntity target;
            if (BlockPos.field_177992_a.equals((Object)this.swampjaw.orbitPosition)) {
                this.swampjaw.orbitPosition = this.swampjaw.func_233580_cy_();
            }
            if ((target = this.swampjaw.func_70638_az()) != null) {
                double difX = target.func_226277_ct_() - ((SwampjawEntity)this.swampjaw).orbitOffset.field_72450_a;
                double difZ = target.func_226281_cx_() - ((SwampjawEntity)this.swampjaw).orbitOffset.field_72449_c;
                Vector3d overshoot = new Vector3d(difX, 0.0, difZ).func_72432_b();
                Vector3d vec = target.func_213303_ch();
                this.swampjaw.orbitOffset = new Vector3d(vec.field_72450_a + overshoot.field_72450_a * 7.0, (double)(this.swampjaw.orbitPosition.func_177956_o() - 4), vec.field_72449_c + overshoot.field_72449_c * 7.0);
            }
        }
    }

    private static class OrbitPointGoal
    extends BaseMoveGoal {
        private float angle;
        private float radius;
        private float height;
        private float direction;

        public OrbitPointGoal(SwampjawEntity swampjaw) {
            super(swampjaw);
        }

        public boolean func_75250_a() {
            return this.swampjaw.func_70638_az() == null || this.swampjaw.behavior == 0;
        }

        public void func_75249_e() {
            this.radius = 6.0f + this.swampjaw.field_70146_Z.nextFloat() * 6.0f;
            this.height = -4.0f + this.swampjaw.field_70146_Z.nextFloat() * 6.0f;
            this.direction = this.swampjaw.field_70146_Z.nextBoolean() ? 1.0f : -1.0f;
            this.updateOffset();
        }

        public void func_75246_d() {
            if (this.swampjaw.field_70146_Z.nextInt(350) == 0) {
                this.height = -4.0f + this.swampjaw.field_70146_Z.nextFloat() * 6.0f;
            }
            if (this.swampjaw.field_70146_Z.nextInt(250) == 0) {
                this.radius -= 1.0f;
                if (this.radius < 6.0f) {
                    this.radius = 12.0f;
                    this.direction = -this.direction;
                }
            }
            if (this.swampjaw.field_70146_Z.nextInt(450) == 0) {
                this.angle = this.swampjaw.field_70146_Z.nextFloat() * 2.0f * (float)Math.PI;
                this.updateOffset();
            }
            if (this.isCloseToOffset()) {
                this.updateOffset();
            }
            if (((SwampjawEntity)this.swampjaw).orbitOffset.field_72448_b < this.swampjaw.func_226278_cu_() && !this.swampjaw.field_70170_p.func_175623_d(this.swampjaw.func_233580_cy_().func_177979_c(1))) {
                this.height = Math.max(1.0f, this.height);
                this.updateOffset();
            }
            if (((SwampjawEntity)this.swampjaw).orbitOffset.field_72448_b > this.swampjaw.func_226278_cu_() && !this.swampjaw.field_70170_p.func_175623_d(this.swampjaw.func_233580_cy_().func_177981_b(1))) {
                this.height = Math.min(-1.0f, this.height);
                this.updateOffset();
            }
        }

        private void updateOffset() {
            if (BlockPos.field_177992_a.equals((Object)this.swampjaw.orbitPosition)) {
                this.swampjaw.orbitPosition = this.swampjaw.func_233580_cy_();
            }
            this.angle += this.direction * 20.0f * ((float)Math.PI / 180);
            this.swampjaw.orbitOffset = Vector3d.func_237491_b_((Vector3i)this.swampjaw.orbitPosition).func_72441_c((double)(this.radius * MathHelper.func_76134_b((float)this.angle)), (double)(-4.0f + this.height), (double)(this.radius * MathHelper.func_76126_a((float)this.angle)));
        }
    }

    private static abstract class BaseMoveGoal
    extends Goal {
        protected SwampjawEntity swampjaw;

        public BaseMoveGoal(SwampjawEntity swampjaw) {
            this.swampjaw = swampjaw;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        protected boolean isCloseToOffset() {
            return this.swampjaw.orbitOffset.func_186679_c(this.swampjaw.func_226277_ct_(), this.swampjaw.func_226278_cu_(), this.swampjaw.func_226281_cx_()) < 4.0;
        }
    }

    private static class MoveHelperController
    extends MovementController {
        private float speedFactor = 0.1f;
        private SwampjawEntity swampjaw;

        public MoveHelperController(SwampjawEntity entityIn) {
            super((MobEntity)entityIn);
            this.swampjaw = entityIn;
        }

        public void func_75641_c() {
            float finalPitch;
            float targetX = (float)(((SwampjawEntity)this.swampjaw).orbitOffset.field_72450_a - this.swampjaw.func_226277_ct_());
            float targetY = (float)(((SwampjawEntity)this.swampjaw).orbitOffset.field_72448_b - this.swampjaw.func_226278_cu_());
            float targetZ = (float)(((SwampjawEntity)this.swampjaw).orbitOffset.field_72449_c - this.swampjaw.func_226281_cx_());
            double horizontalDist = MathHelper.func_76129_c((float)(targetX * targetX + targetZ * targetZ));
            double verticalAdjust = 1.0 - (double)MathHelper.func_76135_e((float)(targetY * 0.7f)) / horizontalDist;
            targetX = (float)((double)targetX * verticalAdjust);
            targetZ = (float)((double)targetZ * verticalAdjust);
            horizontalDist = MathHelper.func_76129_c((float)(targetX * targetX + targetZ * targetZ));
            double totalDist = MathHelper.func_76129_c((float)(targetX * targetX + targetZ * targetZ + targetY * targetY));
            float prevYaw = this.swampjaw.field_70177_z;
            float targetYaw = (float)MathHelper.func_181159_b((double)targetZ, (double)targetX);
            float startYaw = MathHelper.func_76142_g((float)(this.swampjaw.field_70177_z + 90.0f));
            targetYaw = MathHelper.func_76142_g((float)(targetYaw * 57.295776f));
            this.swampjaw.field_70761_aq = this.swampjaw.field_70177_z = MathHelper.func_203303_c((float)startYaw, (float)targetYaw, (float)10.0f) - 90.0f;
            if (MathHelper.func_203301_d((float)prevYaw, (float)this.swampjaw.field_70177_z) < 3.0f) {
                float maxSpeed = this.swampjaw.behavior != 0 ? 3.0f : 1.2f;
                float multiplier = this.speedFactor > maxSpeed ? 10.0f : maxSpeed / this.speedFactor;
                this.speedFactor = MathHelper.func_203300_b((float)this.speedFactor, (float)maxSpeed, (float)(0.005f * multiplier));
            } else {
                this.speedFactor = MathHelper.func_203300_b((float)this.speedFactor, (float)(this.swampjaw.behavior == 1 ? 0.7f : 0.4f), (float)0.05f);
            }
            this.swampjaw.field_70125_A = finalPitch = (float)(-(MathHelper.func_181159_b((double)(-targetY), (double)horizontalDist) * 57.2957763671875));
            float adjustedYaw = this.swampjaw.field_70177_z + 90.0f;
            double finalX = (double)(this.speedFactor * MathHelper.func_76134_b((float)(adjustedYaw * ((float)Math.PI / 180)))) * Math.abs((double)targetX / totalDist);
            double finalZ = (double)(this.speedFactor * MathHelper.func_76126_a((float)(adjustedYaw * ((float)Math.PI / 180)))) * Math.abs((double)targetZ / totalDist);
            double finalY = (double)(this.speedFactor * MathHelper.func_76126_a((float)(finalPitch * ((float)Math.PI / 180)))) * Math.abs((double)targetY / totalDist);
            Vector3d vector3d = this.swampjaw.func_213322_ci();
            this.swampjaw.func_213317_d(vector3d.func_178787_e(new Vector3d(finalX, finalY, finalZ).func_178788_d(vector3d).func_186678_a(0.2)));
        }
    }
}

