/*
 * Decompiled with CFR 0.152.
 */
package lykrast.meetyourfight.item.compat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import lykrast.gunswithoutroses.item.IBullet;
import lykrast.gunswithoutroses.item.ShotgunItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Triple;

public class CocktailShotgun
extends ShotgunItem {
    private static final List<Triple<Effect, Integer, Boolean>> EFFECTS = new ArrayList<Triple<Effect, Integer, Boolean>>();

    public static void initEffects() {
        EFFECTS.add((Triple<Effect, Integer, Boolean>)Triple.of((Object)Effects.field_76421_d, (Object)400, (Object)false));
        EFFECTS.add((Triple<Effect, Integer, Boolean>)Triple.of((Object)Effects.field_76437_t, (Object)400, (Object)false));
        EFFECTS.add((Triple<Effect, Integer, Boolean>)Triple.of((Object)Effects.field_76436_u, (Object)400, (Object)false));
        EFFECTS.add((Triple<Effect, Integer, Boolean>)Triple.of((Object)Effects.field_82731_v, (Object)400, (Object)false));
        EFFECTS.add((Triple<Effect, Integer, Boolean>)Triple.of((Object)Effects.field_188423_x, (Object)400, (Object)true));
        EFFECTS.add((Triple<Effect, Integer, Boolean>)Triple.of((Object)Effects.field_188424_y, (Object)100, (Object)false));
    }

    public CocktailShotgun(Item.Properties properties, int bonusDamage, double damageMultiplier, int fireDelay, double inaccuracy, int enchantability, int bulletCount) {
        super(properties, bonusDamage, damageMultiplier, fireDelay, inaccuracy, enchantability, bulletCount);
    }

    protected void shoot(World world, PlayerEntity player, ItemStack gun, ItemStack ammo, IBullet bulletItem, boolean bulletFree) {
        super.shoot(world, player, gun, ammo, bulletItem, bulletFree);
        float luck = player.func_184817_da();
        double chance = 0.3333333333333333;
        chance = luck >= 0.0f ? (2.0 + (double)luck) / (6.0 + (double)luck) : 1.0 / (3.0 - (double)luck);
        int effectLevel = -1;
        if (field_77697_d.nextDouble() <= chance) {
            effectLevel = 0;
            for (int i = 0; i < 2; ++i) {
                chance *= 0.5;
                if (!(field_77697_d.nextDouble() <= chance)) break;
                ++effectLevel;
            }
        }
        if (effectLevel >= 0) {
            Triple<Effect, Integer, Boolean> triple = EFFECTS.get(field_77697_d.nextInt(EFFECTS.size()));
            int duration = (Boolean)triple.getRight() != false ? (Integer)triple.getMiddle() * (1 + effectLevel) : (Integer)triple.getMiddle();
            int potency = (Boolean)triple.getRight() != false ? 0 : effectLevel;
            PotionEntity potionentity = new PotionEntity(world, (LivingEntity)player);
            potionentity.func_213884_b(PotionUtils.func_185184_a((ItemStack)new ItemStack((IItemProvider)Items.field_185155_bH), Collections.singleton(new EffectInstance((Effect)triple.getLeft(), duration, potency))));
            potionentity.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, -5.0f, (float)this.getProjectileSpeed(gun, player), 1.0f);
            world.func_217376_c((Entity)potionentity);
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187827_fP, SoundCategory.PLAYERS, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        }
    }

    protected void addExtraStatsTooltip(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip) {
        super.addExtraStatsTooltip(stack, world, tooltip);
        tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".desc").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.meetyourfight.desc.luck").func_240699_a_(TextFormatting.GRAY));
    }
}

