/*
 * Decompiled with CFR 0.152.
 */
package lykrast.meetyourfight.misc;

import lykrast.meetyourfight.registry.ModItems;
import lykrast.meetyourfight.registry.ModSounds;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber(modid="meetyourfight")
public class EventHandler {
    @SubscribeEvent
    public static void entityDamage(LivingHurtEvent event) {
        LivingEntity attacked = event.getEntityLiving();
        if (attacked instanceof PlayerEntity) {
            PlayerEntity pattacked = (PlayerEntity)attacked;
            if (!event.isCanceled() && CuriosApi.getCuriosHelper().findEquippedCurio(ModItems.aceOfIron, (LivingEntity)pattacked).isPresent()) {
                float luck = pattacked.func_184817_da();
                double chance = 0.16666666666666666;
                chance = luck >= 0.0f ? (1.0 + (double)luck) / (6.0 + (double)(2.0f * luck)) : 1.0 / (6.0 - (double)(3.0f * luck));
                if (pattacked.func_70681_au().nextDouble() <= chance) {
                    event.setCanceled(true);
                    pattacked.field_70170_p.func_184133_a(null, attacked.func_233580_cy_(), ModSounds.aceOfIronProc, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
        if (event.isCanceled()) {
            return;
        }
        Entity attacker = event.getSource().func_76346_g();
        if (attacker != null && attacker instanceof PlayerEntity) {
            PlayerEntity pattacker = (PlayerEntity)attacker;
            if (CuriosApi.getCuriosHelper().findEquippedCurio(ModItems.slicersDice, (LivingEntity)pattacker).isPresent()) {
                float luck = pattacker.func_184817_da();
                double chance = 0.2;
                chance = luck >= 0.0f ? (1.0 + (double)luck) / (5.0 + (double)luck) : 1.0 / (5.0 - (double)(3.0f * luck));
                if (pattacker.func_70681_au().nextDouble() <= chance) {
                    event.setAmount(event.getAmount() * 2.0f);
                    pattacker.field_70170_p.func_184133_a(null, attacked.func_233580_cy_(), ModSounds.slicersDiceProc, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    ((ServerWorld)pattacker.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197614_g, attacked.func_226277_ct_(), attacked.func_226280_cw_(), attacked.func_226281_cx_(), 15, 0.2, 0.2, 0.2, 0.0);
                }
            }
        }
        if (attacked instanceof PlayerEntity) {
            PlayerEntity pattacked = (PlayerEntity)attacked;
            if (!event.isCanceled() && CuriosApi.getCuriosHelper().findEquippedCurio(ModItems.cagedHeart, (LivingEntity)pattacked).isPresent()) {
                float treshold = pattacked.func_110138_aP() / 4.0f;
                if (event.getAmount() > treshold) {
                    event.setAmount((event.getAmount() - treshold) * 0.5f + treshold);
                    pattacked.field_70170_p.func_184133_a(null, attacked.func_233580_cy_(), ModSounds.cagedHeartProc, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        if (stack.func_77973_b() instanceof ICurio && stack.func_77973_b().getRegistryName().func_110624_b().equals("meetyourfight")) {
            event.addCapability(CuriosCapability.ID_ITEM, (ICapabilityProvider)new Provider((ICurio)stack.func_77973_b()));
        }
    }

    private static class Provider
    implements ICapabilityProvider {
        private LazyOptional<ICurio> curio = LazyOptional.of(() -> curio);

        public Provider(ICurio curio) {
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return CuriosCapability.ITEM.orEmpty(cap, this.curio);
        }
    }
}

