/*
 * Decompiled with CFR 0.152.
 */
package com.GenZVirus.MobPlusPlus.Client.Render;

import com.GenZVirus.MobPlusPlus.Client.File.XMLFileJava;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.fonts.EmptyGlyph;
import net.minecraft.client.gui.fonts.IGlyph;
import net.minecraft.client.gui.fonts.TexturedGlyph;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class OverlayRenderer {
    public static float RED;
    public static float GREEN;
    public static float BLUE;
    public static boolean BORDER;
    public static ResourceLocation Background;
    public static ResourceLocation Health;

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, LivingEntity entitylivingbaseIn) {
        XMLFileJava.checkFileAndMake();
        this.renderName(entitylivingbaseIn, entitylivingbaseIn.func_200200_C_().getString(), matrixStackIn, bufferIn, packedLightIn);
        this.renderHealthBar(matrixStackIn, bufferIn, packedLightIn, entitylivingbaseIn);
        String percentage = (int)(entitylivingbaseIn.func_110143_aJ() / entitylivingbaseIn.func_110138_aP() * 100.0f) + "%";
        this.renderPercentage(entitylivingbaseIn, percentage, matrixStackIn, bufferIn, packedLightIn);
    }

    protected void renderPercentage(LivingEntity entityIn, String displayNameIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        double d0 = renderManager.func_229099_b_((Entity)entityIn);
        if (!(d0 > 4096.0)) {
            boolean flag = !entityIn.func_226273_bm_();
            float f = entityIn.func_213302_cg() + 0.56f;
            boolean i = false;
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, (double)f, 0.0);
            matrixStackIn.func_227863_a_(renderManager.func_229098_b_());
            matrixStackIn.func_227862_a_(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
            FontRenderer fontrenderer = renderManager.func_78716_a();
            float f2 = -fontrenderer.func_78256_a(displayNameIn) / 2;
            if (flag) {
                OverlayRenderer.renderString(displayNameIn, f2, (float)i, -1, false, matrix4f, bufferIn, false, 0, packedLightIn);
            }
            matrixStackIn.func_227865_b_();
        }
    }

    protected void renderName(LivingEntity entityIn, String displayNameIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        double d0 = renderManager.func_229099_b_((Entity)entityIn);
        if (!(d0 > 4096.0)) {
            boolean flag = !entityIn.func_226273_bm_();
            float f = entityIn.func_213302_cg() + 1.0f;
            boolean i = false;
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, (double)f, 0.0);
            matrixStackIn.func_227863_a_(renderManager.func_229098_b_());
            matrixStackIn.func_227862_a_(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
            FontRenderer fontrenderer = renderManager.func_78716_a();
            float f2 = -fontrenderer.func_78256_a(displayNameIn) / 2;
            OverlayRenderer.renderString(displayNameIn, f2, (float)i, -1, false, matrix4f, bufferIn, flag, 0x20FFFFFF, packedLightIn);
            if (flag) {
                OverlayRenderer.renderString(displayNameIn, f2, (float)i, -1, false, matrix4f, bufferIn, false, 0, packedLightIn);
            }
            matrixStackIn.func_227865_b_();
        }
    }

    protected void renderHealthBar(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, LivingEntity entityIn) {
        matrixStackIn.func_227860_a_();
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        float f = entityIn.func_213302_cg() + 0.6f;
        matrixStackIn.func_227861_a_(0.0, (double)f, 0.0);
        matrixStackIn.func_227863_a_(renderManager.func_229098_b_());
        matrixStackIn.func_227863_a_(new Quaternion(0.0f, 0.0f, 180.0f, true));
        RenderState.TransparencyState TRANSLUCENT_TRANSPARENCY = new RenderState.TransparencyState("translucent_transparency", () -> RenderSystem.enableBlend(), () -> RenderSystem.disableBlend());
        RenderState.AlphaState DEFAULT_ALPHA = new RenderState.AlphaState(0.003921569f);
        Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
        IVertexBuilder bar = bufferIn.getBuffer((RenderType)RenderType.func_228632_a_((String)"mppbar", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)65536, (RenderType.State)RenderType.State.func_228694_a_().func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228724_a_(new RenderState.TextureState(new ResourceLocation("mobplusplus", "textures/bar.png"), false, true)).func_228713_a_(DEFAULT_ALPHA).func_228714_a_(new RenderState.CullState(false)).func_228719_a_(new RenderState.LightmapState(true)).func_228728_a_(true)));
        float length = 1.0f;
        OverlayRenderer.addVertexPairBackground(bar, matrix4f, packedLightIn, length);
        bar = bufferIn.getBuffer((RenderType)RenderType.func_228632_a_((String)"mpphealthbar", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)65536, (RenderType.State)RenderType.State.func_228694_a_().func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228724_a_(new RenderState.TextureState(new ResourceLocation("mobplusplus", "textures/health_bar_fill.png"), false, true)).func_228713_a_(DEFAULT_ALPHA).func_228714_a_(new RenderState.CullState(false)).func_228719_a_(new RenderState.LightmapState(true)).func_228728_a_(true)));
        length = entityIn.func_110143_aJ() / entityIn.func_110138_aP();
        OverlayRenderer.addVertexPairHealth(bar, matrix4f, packedLightIn, length);
        matrixStackIn.func_227865_b_();
    }

    public static void addVertexPairBackground(IVertexBuilder bufferIn, Matrix4f matrixIn, int packedLight, float length) {
        float x = 1.4f - 2.8f * (1.0f - length);
        float y = 0.2f;
        float z = 0.102f;
        bufferIn.func_227888_a_(matrixIn, -1.4f, 0.0f, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(0.0f, 0.0f).func_227886_a_(packedLight).func_181675_d();
        bufferIn.func_227888_a_(matrixIn, -1.4f, y, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(0.0f, 1.0f).func_227886_a_(packedLight).func_181675_d();
        bufferIn.func_227888_a_(matrixIn, x, y, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(1.0f, 1.0f).func_227886_a_(packedLight).func_181675_d();
        bufferIn.func_227888_a_(matrixIn, x, 0.0f, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(1.0f, 0.0f).func_227886_a_(packedLight).func_181675_d();
    }

    public static void addVertexPairHealth(IVertexBuilder bufferIn, Matrix4f matrixIn, int packedLight, float length) {
        float x = 1.4f - 2.8f * (1.0f - length);
        float y = 0.2f;
        float z = 0.101f;
        bufferIn.func_227888_a_(matrixIn, -1.4f, 0.0f, z).func_227885_a_(RED, GREEN, BLUE, 1.0f).func_225583_a_(0.0f, 0.0f).func_227886_a_(packedLight).func_181675_d();
        bufferIn.func_227888_a_(matrixIn, -1.4f, y, z).func_227885_a_(RED, GREEN, BLUE, 1.0f).func_225583_a_(0.0f, 1.0f).func_227886_a_(packedLight).func_181675_d();
        bufferIn.func_227888_a_(matrixIn, x, y, z).func_227885_a_(RED, GREEN, BLUE, 1.0f).func_225583_a_(1.0f, 1.0f).func_227886_a_(packedLight).func_181675_d();
        bufferIn.func_227888_a_(matrixIn, x, 0.0f, z).func_227885_a_(RED, GREEN, BLUE, 1.0f).func_225583_a_(1.0f, 0.0f).func_227886_a_(packedLight).func_181675_d();
    }

    public static int renderString(String text, float x, float y, int color, boolean dropShadow, Matrix4f matrix, IRenderTypeBuffer buffer, boolean transparentIn, int colorBackgroundIn, int packedLight) {
        return OverlayRenderer.renderStringAt(text, x, y, color, dropShadow, matrix, buffer, transparentIn, colorBackgroundIn, packedLight);
    }

    private static int renderStringAt(String text, float x, float y, int color, boolean dropShadow, Matrix4f matrix, IRenderTypeBuffer buffer, boolean transparentIn, int colorBackgroundIn, int packedLight) {
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        FontRenderer fontrenderer = renderManager.func_78716_a();
        boolean bidiFlag = fontrenderer.func_78260_a();
        if (bidiFlag) {
            text = fontrenderer.func_147647_b(text);
        }
        if ((color & 0xFC000000) == 0) {
            color |= 0xFF000000;
        }
        if (dropShadow) {
            OverlayRenderer.renderStringAtPos(text, x, y, color, true, matrix, buffer, transparentIn, colorBackgroundIn, packedLight);
        }
        Matrix4f matrix4f = matrix.func_226601_d_();
        matrix4f.func_226597_a_(new Vector3f(0.0f, 0.0f, 0.001f));
        x = OverlayRenderer.renderStringAtPos(text, x, y, color, false, matrix4f, buffer, transparentIn, colorBackgroundIn, packedLight);
        return (int)x + (dropShadow ? 1 : 0);
    }

    private static float renderStringAtPos(String text, float x, float y, int color, boolean isShadow, Matrix4f matrix, IRenderTypeBuffer buffer, boolean isTransparent, int colorBackgroundIn, int packedLight) {
        float f = isShadow ? 0.25f : 1.0f;
        float f1 = (float)(color >> 16 & 0xFF) / 255.0f * f;
        float f2 = (float)(color >> 8 & 0xFF) / 255.0f * f;
        float f3 = (float)(color & 0xFF) / 255.0f * f;
        float f4 = x;
        float redIn = f1;
        float greenIn = f2;
        float blueIn = f3;
        float alphaIn = (float)(color >> 24 & 0xFF) / 255.0f;
        boolean flag = false;
        boolean boldIn = false;
        boolean italicIn = false;
        boolean flag3 = false;
        boolean flag4 = false;
        ArrayList list = Lists.newArrayList();
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        FontRenderer fontrenderer = renderManager.func_78716_a();
        for (int i = 0; i < text.length(); ++i) {
            float f16;
            TexturedGlyph texturedglyph;
            char c0 = text.charAt(i);
            if (c0 == '\u00a7' && i + 1 < text.length()) {
                TextFormatting textformatting = TextFormatting.func_211165_a((char)text.charAt(i + 1));
                if (textformatting != null) {
                    if (!textformatting.func_96301_b()) {
                        flag = false;
                        boldIn = false;
                        flag4 = false;
                        flag3 = false;
                        italicIn = false;
                        redIn = f1;
                        greenIn = f2;
                        blueIn = f3;
                    }
                    if (textformatting.func_211163_e() != null) {
                        int j = textformatting.func_211163_e();
                        redIn = (float)(j >> 16 & 0xFF) / 255.0f * f;
                        greenIn = (float)(j >> 8 & 0xFF) / 255.0f * f;
                        blueIn = (float)(j & 0xFF) / 255.0f * f;
                    } else if (textformatting == TextFormatting.OBFUSCATED) {
                        flag = true;
                    } else if (textformatting == TextFormatting.BOLD) {
                        boldIn = true;
                    } else if (textformatting == TextFormatting.STRIKETHROUGH) {
                        flag4 = true;
                    } else if (textformatting == TextFormatting.UNDERLINE) {
                        flag3 = true;
                    } else if (textformatting == TextFormatting.ITALIC) {
                        italicIn = true;
                    }
                }
                ++i;
                continue;
            }
            IGlyph iglyph = fontrenderer.func_238419_a_(Style.field_240709_b_.func_240729_k_()).func_238557_a_((int)c0);
            TexturedGlyph texturedGlyph = texturedglyph = flag && c0 != ' ' ? fontrenderer.func_238419_a_(Style.field_240709_b_.func_240729_k_()).func_211188_a(iglyph) : fontrenderer.func_238419_a_(Style.field_240709_b_.func_240729_k_()).func_238559_b_((int)c0);
            if (!(texturedglyph instanceof EmptyGlyph)) {
                float f9 = boldIn ? iglyph.func_223275_b_() : 0.0f;
                float f10 = isShadow ? iglyph.func_223276_c_() : 0.0f;
                IVertexBuilder ivertexbuilder = buffer.getBuffer(texturedglyph.func_228163_a_(isTransparent));
                float xIn = f4 + f10;
                float yIn = y + f10;
                texturedglyph.func_225595_a_(italicIn, xIn, yIn, matrix, ivertexbuilder, redIn, greenIn, blueIn, alphaIn, packedLight);
                if (boldIn) {
                    texturedglyph.func_225595_a_(italicIn, xIn + f9, yIn, matrix, ivertexbuilder, redIn, greenIn, blueIn, alphaIn, packedLight);
                }
            }
            float f15 = iglyph.func_223274_a_(boldIn);
            float f5 = f16 = isShadow ? 1.0f : 0.0f;
            if (flag4) {
                list.add(new Effect(f4 + f16 - 1.0f, y + f16 + 4.5f, f4 + f16 + f15, y + f16 + 4.5f - 1.0f, -0.01f, redIn, greenIn, blueIn, alphaIn));
            }
            if (flag3) {
                list.add(new Effect(f4 + f16 - 1.0f, y + f16 + 9.0f, f4 + f16 + f15, y + f16 + 9.0f - 1.0f, -0.01f, redIn, greenIn, blueIn, alphaIn));
            }
            f4 += f15;
        }
        if (colorBackgroundIn != 0) {
            float f11 = (float)(colorBackgroundIn >> 24 & 0xFF) / 255.0f;
            float f12 = (float)(colorBackgroundIn >> 16 & 0xFF) / 255.0f;
            float f13 = (float)(colorBackgroundIn >> 8 & 0xFF) / 255.0f;
            float f14 = (float)(colorBackgroundIn & 0xFF) / 255.0f;
            list.add(new Effect(x - 1.0f, y + 9.0f, f4 + 1.0f, y - 1.0f, 0.01f, f12, f13, f14, f11));
            if (BORDER) {
                list.add(new Effect(x - 1.0f, y - 0.5f, f4 + 1.0f, y - 1.0f, 0.009f, RED, GREEN, BLUE, 1.0f));
                list.add(new Effect(x - 1.0f, y + 9.0f, f4 + 1.0f, y + 8.5f, 0.009f, RED, GREEN, BLUE, 1.0f));
                list.add(new Effect(x - 1.0f, y + 9.0f, x - 0.5f, y - 1.0f, 0.009f, RED, GREEN, BLUE, 1.0f));
                list.add(new Effect(f4 + 0.5f, y + 9.0f, f4 + 1.0f, y - 1.0f, 0.009f, RED, GREEN, BLUE, 1.0f));
            }
        }
        if (!list.isEmpty()) {
            TexturedGlyph texturedglyph1 = fontrenderer.func_238419_a_(Style.field_240709_b_.func_240729_k_()).func_228157_b_();
            IVertexBuilder ivertexbuilder1 = buffer.getBuffer(texturedglyph1.func_228163_a_(isTransparent));
            for (Effect texturedglyph$effect : list) {
                OverlayRenderer.renderEffect(texturedglyph1, texturedglyph$effect, matrix, ivertexbuilder1, packedLight);
            }
        }
        return f4;
    }

    public static void renderEffect(TexturedGlyph glyph, Effect effectIn, Matrix4f matrixIn, IVertexBuilder bufferIn, int packedLightIn) {
        bufferIn.func_227888_a_(matrixIn, effectIn.x0, effectIn.y0, effectIn.depth).func_227885_a_(effectIn.r, effectIn.g, effectIn.b, effectIn.a).func_225583_a_(glyph.field_211236_b, glyph.field_211238_d).func_227886_a_(packedLightIn).func_181675_d();
        bufferIn.func_227888_a_(matrixIn, effectIn.x1, effectIn.y0, effectIn.depth).func_227885_a_(effectIn.r, effectIn.g, effectIn.b, effectIn.a).func_225583_a_(glyph.field_211236_b, glyph.field_211239_e).func_227886_a_(packedLightIn).func_181675_d();
        bufferIn.func_227888_a_(matrixIn, effectIn.x1, effectIn.y1, effectIn.depth).func_227885_a_(effectIn.r, effectIn.g, effectIn.b, effectIn.a).func_225583_a_(glyph.field_211237_c, glyph.field_211239_e).func_227886_a_(packedLightIn).func_181675_d();
        bufferIn.func_227888_a_(matrixIn, effectIn.x0, effectIn.y1, effectIn.depth).func_227885_a_(effectIn.r, effectIn.g, effectIn.b, effectIn.a).func_225583_a_(glyph.field_211237_c, glyph.field_211238_d).func_227886_a_(packedLightIn).func_181675_d();
    }

    static {
        Background = new ResourceLocation("mobplusplus", "textures/bar.png");
        Health = new ResourceLocation("mobplusplus", "textures/health_bar_fill.png");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Effect {
        protected final float x0;
        protected final float y0;
        protected final float x1;
        protected final float y1;
        protected final float depth;
        protected final float r;
        protected final float g;
        protected final float b;
        protected final float a;

        public Effect(float p_i225923_1_, float p_i225923_2_, float p_i225923_3_, float p_i225923_4_, float p_i225923_5_, float p_i225923_6_, float p_i225923_7_, float p_i225923_8_, float p_i225923_9_) {
            this.x0 = p_i225923_1_;
            this.y0 = p_i225923_2_;
            this.x1 = p_i225923_3_;
            this.y1 = p_i225923_4_;
            this.depth = p_i225923_5_;
            this.r = p_i225923_6_;
            this.g = p_i225923_7_;
            this.b = p_i225923_8_;
            this.a = p_i225923_9_;
        }
    }
}

