/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.item;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.machinemuse.numina.item.IModeChangingItem;
import net.machinemuse.numina.item.IModularItem;
import net.machinemuse.numina.math.MuseMathUtils;
import net.machinemuse.numina.nbt.MuseNBTUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemHandlerHelper;

public class MuseItemUtils {
    public static NonNullList<ItemStack> getModularItemsEquipped(EntityPlayer player) {
        NonNullList modulars = NonNullList.func_191196_a();
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack itemStack = player.func_184582_a(slot);
            if (itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof IModularItem) || slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR && (slot.func_188453_a() != EntityEquipmentSlot.Type.HAND || !(itemStack.func_77973_b() instanceof IModeChangingItem))) continue;
            modulars.add((Object)itemStack);
        }
        return modulars;
    }

    public static NonNullList<ItemStack> getModularItemsInInventory(EntityPlayer player) {
        return MuseItemUtils.getModularItemsInInventory((IInventory)player.field_71071_by);
    }

    public static NonNullList<ItemStack> getModularItemsInInventory(IInventory inv) {
        NonNullList stacks = NonNullList.func_191196_a();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IModularItem)) continue;
            stacks.add((Object)stack);
        }
        return stacks;
    }

    public static List<Integer> getModularItemSlotsEquiped(EntityPlayer player) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        ItemStack stack = player.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IModularItem) {
            slots.add(player.field_71071_by.field_70461_c);
        }
        for (int i = 36; i < player.field_71071_by.func_70302_i_(); ++i) {
            stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IModularItem)) continue;
            slots.add(i);
        }
        return slots;
    }

    public static List<Integer> getModularItemSlotsInInventory(EntityPlayer player) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IModularItem)) continue;
            slots.add(i);
        }
        return slots;
    }

    public static boolean hasInInventory(List<ItemStack> workingUpgradeCost, InventoryPlayer inventory) {
        for (ItemStack stackInCost : workingUpgradeCost) {
            int found = 0;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stackInInventory = inventory.func_70301_a(i);
                if (!MuseItemUtils.isSameItem(stackInInventory, stackInCost)) continue;
                found += stackInInventory.func_190916_E();
            }
            if (found >= stackInCost.func_190916_E()) continue;
            return false;
        }
        return true;
    }

    public static boolean isSameItem(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        if (stack1.func_190926_b() || stack2.func_190926_b() || stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        return stack1.func_77984_f() || stack1.func_77952_i() == stack2.func_77952_i();
    }

    public static void transferStackWithChance(@Nonnull ItemStack itemsToGive, @Nonnull ItemStack destinationStack, double chanceOfSuccess) {
        int maxSize = destinationStack.func_77976_d();
        while (itemsToGive.func_190916_E() > 0 && destinationStack.func_190916_E() < maxSize) {
            itemsToGive.func_190920_e(itemsToGive.func_190916_E() - 1);
            if (!(MuseMathUtils.nextDouble() < chanceOfSuccess)) continue;
            destinationStack.func_190920_e(destinationStack.func_190916_E() + 1);
        }
    }

    public static List<Integer> deleteFromInventory(NonNullList<ItemStack> cost, InventoryPlayer inventory) {
        LinkedList<Integer> slots = new LinkedList<Integer>();
        for (ItemStack stackInCost : cost) {
            int remaining = stackInCost.func_190916_E();
            for (int i = 0; i < inventory.func_70302_i_() && remaining > 0; ++i) {
                ItemStack stackInInventory = inventory.func_70301_a(i);
                if (!MuseItemUtils.isSameItem(stackInInventory, stackInCost)) continue;
                int numToTake = Math.min(stackInInventory.func_190916_E(), remaining);
                stackInInventory.func_190920_e(stackInInventory.func_190916_E() - numToTake);
                remaining -= numToTake;
                if (stackInInventory.func_190916_E() == 0) {
                    inventory.func_70299_a(i, ItemStack.field_190927_a);
                }
                slots.add(i);
            }
        }
        return slots;
    }

    public static List<Integer> findInInventoryForCost(List<ItemStack> workingUpgradeCost, InventoryPlayer inventory) {
        LinkedList<Integer> slots = new LinkedList<Integer>();
        for (ItemStack stackInCost : workingUpgradeCost) {
            int found = 0;
            for (int i = 0; i < inventory.func_70302_i_() && found < stackInCost.func_190916_E(); ++i) {
                ItemStack stackInInventory = inventory.func_70301_a(i);
                if (!MuseItemUtils.isSameItem(stackInInventory, stackInCost)) continue;
                found += stackInInventory.func_190916_E();
                slots.add(i);
            }
        }
        return slots;
    }

    public static String getStringOrNull(@Nonnull ItemStack stack, String key) {
        return MuseItemUtils.getStringOrNull(MuseNBTUtils.getMuseItemTag(stack), key);
    }

    public static String getStringOrNull(@Nonnull NBTTagCompound itemProperties, String key) {
        String value = null;
        if (itemProperties != null && itemProperties.func_74764_b(key)) {
            value = itemProperties.func_74779_i(key);
        }
        return value;
    }

    public static void setStringOrNull(NBTTagCompound itemProperties, String key, String value) {
        if (itemProperties != null) {
            if (value.isEmpty()) {
                itemProperties.func_82580_o(key);
            } else {
                itemProperties.func_74778_a(key, value);
            }
        }
    }

    public static void setStringOrNull(@Nonnull ItemStack stack, String key, String value) {
        MuseItemUtils.setStringOrNull(MuseNBTUtils.getMuseItemTag(stack), key, value);
    }

    public static boolean canStackTogether(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        if (!MuseItemUtils.isSameItem(stack1, stack2)) {
            return false;
        }
        if (!stack1.func_77985_e()) {
            return false;
        }
        return stack1.func_190916_E() < stack1.func_77976_d();
    }

    public static void giveOrDropItemWithChance(EntityPlayer player, @Nonnull ItemStack itemsToGive, double chanceOfSuccess) {
        if (!player.field_70170_p.field_72995_K) {
            return;
        }
        if (MuseMathUtils.nextDouble() < chanceOfSuccess) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)itemsToGive);
        }
    }

    public static ItemStack copyAndResize(@Nonnull ItemStack stack, int number) {
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(number);
        return copy;
    }

    public static boolean canItemFitInInventory(EntityPlayer player, @Nonnull ItemStack itemstack) {
        int i;
        for (i = 0; i < player.field_71071_by.func_70302_i_() - 4; ++i) {
            if (!player.field_71071_by.func_70301_a(i).func_190926_b()) continue;
            return true;
        }
        if (!itemstack.func_77951_h()) {
            if (itemstack.func_77976_d() == 1) {
                return false;
            }
            for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack invstack = player.field_71071_by.func_70301_a(i);
                if (invstack.func_190926_b() || invstack.func_77973_b() != itemstack.func_77973_b() || !invstack.func_77985_e() || invstack.func_190916_E() >= invstack.func_77976_d() || invstack.func_190916_E() >= player.field_71071_by.func_70297_j_() || invstack.func_77981_g() && invstack.func_77952_i() != itemstack.func_77952_i()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && (!stack1.func_77981_g() || stack1.func_77960_j() == stack2.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static double getDoubleOrZero(NBTTagCompound itemProperties, String string) {
        double value = 0.0;
        if (itemProperties != null && itemProperties.func_74764_b(string)) {
            value = itemProperties.func_74769_h(string);
        }
        return value;
    }

    public static double getDoubleOrZero(ItemStack stack, String string) {
        return MuseItemUtils.getDoubleOrZero(MuseNBTUtils.getMuseItemTag(stack), string);
    }

    public static void setDoubleOrRemove(NBTTagCompound itemProperties, String string, double value) {
        if (itemProperties != null) {
            if (value == 0.0) {
                itemProperties.func_82580_o(string);
            } else {
                itemProperties.func_74780_a(string, value);
            }
        }
    }

    public static void setDoubleOrRemove(@Nonnull ItemStack stack, String string, double value) {
        MuseItemUtils.setDoubleOrRemove(MuseNBTUtils.getMuseItemTag(stack), string, value);
    }
}

