/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import net.machinemuse.numina.basemod.MuseLogger;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class MuseByteBufferUtils
extends ByteBufUtils {
    public static void writeCompressedNBT(ByteBuf buf, NBTTagCompound nbt) {
        ByteBufOutputStream bos = new ByteBufOutputStream(buf);
        DataOutputStream dos = new DataOutputStream((OutputStream)bos);
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)dos);
            dos.flush();
            dos.close();
        }
        catch (IOException exception) {
            MuseLogger.logException("PROBLEM WRITING DATA TO PACKET:", exception);
        }
    }

    public static NBTTagCompound readCompressedNBT(ByteBuf buf) {
        NBTTagCompound nbt;
        ByteBufInputStream bis = new ByteBufInputStream(buf);
        DataInputStream dis = new DataInputStream((InputStream)bis);
        try {
            nbt = CompressedStreamTools.func_74796_a((InputStream)dis);
        }
        catch (IOException exception) {
            MuseLogger.logException("PROBLEM READING DATA FROM PACKET:", exception);
            nbt = new NBTTagCompound();
        }
        return nbt;
    }

    public static void writeIntArray(ByteBuf buf, int[] intArray) {
        buf.writeInt(intArray.length);
        for (int i = 0; i < intArray.length; ++i) {
            buf.writeInt(intArray[i]);
        }
    }

    public static int[] readIntArray(ByteBuf buf) {
        int arraySize = buf.readInt();
        int[] intArray = new int[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            intArray[i] = buf.readInt();
        }
        return intArray;
    }

    public static void writeMap(ByteBuf buf, @Nonnull Map map, boolean compressOrNot) {
        byte[] bytes = MuseByteBufferUtils.writeMapToBytes(map);
        try {
            if (compressOrNot) {
                bytes = MuseByteBufferUtils.compressBytesGZip(bytes);
            }
            buf.writeBoolean(compressOrNot);
            buf.writeInt(bytes.length);
            buf.writeBytes(bytes);
        }
        catch (Exception exception) {
            MuseLogger.logException("PROBLEM WRITING DATA TO PACKET:", exception);
        }
    }

    public static byte[] writeMapToBytes(@Nonnull Map map) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeInt(map.size());
            for (Object key : map.keySet()) {
                MuseByteBufferUtils.writeObjectToStream(dos, key);
                MuseByteBufferUtils.writeObjectToStream(dos, map.get(key));
            }
            dos.flush();
            dos.close();
        }
        catch (IOException exception) {
            MuseLogger.logException("PROBLEM WRITING DATA TO PACKET:", exception);
        }
        return baos.toByteArray();
    }

    public static HashMap readMap(ByteBuf dataIn, Class keyClass, Class valueClass) {
        HashMap hashMap = new HashMap();
        try {
            boolean compressOrNot = dataIn.readBoolean();
            int dataLength = dataIn.readInt();
            byte[] bytes = new byte[dataLength];
            dataIn.readBytes(bytes);
            if (compressOrNot) {
                bytes = MuseByteBufferUtils.decompressGZipBytes(bytes);
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            DataInputStream dataInputStream = new DataInputStream(bais);
            hashMap = MuseByteBufferUtils.readMap(dataInputStream, keyClass, valueClass);
            dataInputStream.close();
            bais.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hashMap;
    }

    private static HashMap readMap(DataInputStream dataIn, Class keyClass, Class valueClass) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        try {
            int mapLength = dataIn.readInt();
            for (int i = 0; i < mapLength; ++i) {
                hashMap.put(MuseByteBufferUtils.readObject(dataIn, keyClass), MuseByteBufferUtils.readObject(dataIn, valueClass));
            }
            return hashMap;
        }
        catch (Exception exception) {
            MuseLogger.logException("PROBLEM WRITING DATA TO PACKET:", exception);
            return hashMap;
        }
    }

    private static void writeObjectToStream(DataOutputStream dataOut, @Nonnull Object o) throws IOException {
        int i;
        Class<?> objectType = o.getClass();
        if (objectType == Boolean.class) {
            dataOut.writeBoolean((Boolean)o);
        } else if (objectType == Byte.class) {
            dataOut.writeByte(((Byte)o).byteValue());
        } else if (objectType == Integer.class) {
            dataOut.writeInt((Integer)o);
        } else if (objectType == Long.class) {
            dataOut.writeLong((Long)o);
        } else if (objectType == Double.class) {
            dataOut.writeDouble((Double)o);
        } else if (objectType == Float.class) {
            dataOut.writeFloat(((Float)o).floatValue());
        } else if (objectType == String.class) {
            dataOut.writeUTF((String)o);
        } else if (o instanceof float[]) {
            float[] array = (float[])o;
            dataOut.writeInt(array.length);
            for (i = 0; i < array.length; ++i) {
                dataOut.writeFloat(array[i]);
            }
        } else if (o instanceof NBTTagCompound) {
            CompressedStreamTools.func_74800_a((NBTTagCompound)((NBTTagCompound)o), (DataOutput)dataOut);
        } else if (o instanceof int[]) {
            int[] array2 = (int[])o;
            dataOut.writeInt(array2.length);
            while (i < array2.length) {
                dataOut.writeInt(array2[i]);
                ++i;
            }
        } else {
            throw new TypeNotPresentException(o.getClass().getName(), new Throwable("map key or getValue type handler not found!!"));
        }
    }

    private static Object readObject(DataInputStream dataIn, Class clazz) throws IOException {
        int i;
        if (clazz == Boolean.class) {
            return dataIn.readBoolean();
        }
        if (clazz == Integer.class) {
            return dataIn.readInt();
        }
        if (clazz == Long.class) {
            return dataIn.readLong();
        }
        if (clazz == Double.class) {
            return dataIn.readDouble();
        }
        if (clazz == Float.class) {
            return Float.valueOf(dataIn.readFloat());
        }
        if (clazz == String.class) {
            return dataIn.readUTF();
        }
        if (clazz == NBTTagCompound.class) {
            return CompressedStreamTools.func_74794_a((DataInputStream)dataIn);
        }
        if (clazz == int[].class) {
            int int1 = dataIn.readInt();
            int[] array = new int[int1];
            for (i = 0; i < int1; ++i) {
                array[i] = dataIn.readInt();
            }
            return array;
        }
        if (clazz != float[].class) {
            return null;
        }
        int int2 = dataIn.readInt();
        float[] array2 = new float[int2];
        while (i < int2) {
            array2[i] = dataIn.readFloat();
            ++i;
        }
        return array2;
    }

    public static byte[] compressBytesGZip(byte[] data) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] bytes = new byte[]{};
        try {
            GZIPOutputStream compressedStream = new GZIPOutputStream(outStream);
            compressedStream.write(data);
            compressedStream.flush();
            compressedStream.close();
            return outStream.toByteArray();
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }

    public static byte[] decompressGZipBytes(byte[] compressed) {
        byte[] decomp = new byte[compressed.length * 4];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int buffRead;
            GZIPInputStream zippy = new GZIPInputStream(new ByteArrayInputStream(compressed));
            while ((buffRead = zippy.read(decomp)) != -1) {
                bos.write(decomp, 0, buffRead);
            }
            zippy.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }
}

