/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.capabilities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.machinemuse.numina.capabilities.heat.CapabilityHeat;
import net.machinemuse.powersuits.capabilities.ForgeEnergyItemWrapper;
import net.machinemuse.powersuits.capabilities.ItemHandlerPowerFist;
import net.machinemuse.powersuits.capabilities.MPSChestPlateFluidHandler;
import net.machinemuse.powersuits.capabilities.MuseHeatItemWrapper;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.common.config.MPSConfig;
import net.machinemuse.powersuits.item.armor.ItemPowerArmorChestplate;
import net.machinemuse.powersuits.item.tool.ItemPowerFist;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public final class MPSCapProvider
implements ICapabilityProvider {
    private final ItemStack container;
    MuseHeatItemWrapper heatWrapper;
    ForgeEnergyItemWrapper energyContainerWrapper;
    ItemHandlerPowerFist powerFistItemHandler;
    MPSChestPlateFluidHandler chestPlateFluidHandler;

    public MPSCapProvider(@Nonnull ItemStack containerIn) {
        this.container = containerIn;
        this.energyContainerWrapper = new ForgeEnergyItemWrapper(containerIn, ModuleManager.INSTANCE);
        this.heatWrapper = new MuseHeatItemWrapper(containerIn, MPSConfig.INSTANCE.getBaseMaxHeat(containerIn), ModuleManager.INSTANCE);
        if (this.container.func_77973_b() instanceof ItemPowerFist) {
            this.powerFistItemHandler = new ItemHandlerPowerFist(this.container);
        }
        if (this.container.func_77973_b() instanceof ItemPowerArmorChestplate) {
            this.chestPlateFluidHandler = new MPSChestPlateFluidHandler(this.container, ModuleManager.INSTANCE);
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.powerFistItemHandler != null) {
            return true;
        }
        if (capability == CapabilityHeat.HEAT && this.heatWrapper != null) {
            return true;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
            return this.chestPlateFluidHandler != null;
        }
        return false;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.powerFistItemHandler != null) {
                this.powerFistItemHandler.updateFromNBT();
                return (T)((Object)this.powerFistItemHandler);
            }
            return null;
        }
        if (capability == CapabilityEnergy.ENERGY && this.energyContainerWrapper != null) {
            this.energyContainerWrapper.updateFromNBT();
            return (T)((Object)this.energyContainerWrapper);
        }
        if (capability == CapabilityHeat.HEAT && this.heatWrapper != null) {
            this.heatWrapper.updateFromNBT();
            return (T)((Object)this.heatWrapper);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY && this.chestPlateFluidHandler != null) {
            this.chestPlateFluidHandler.updateFromNBT();
            return (T)this.chestPlateFluidHandler;
        }
        return null;
    }
}

