/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.machinemuse.numina.item.IModularItem;
import net.machinemuse.numina.module.IModuleManager;
import net.machinemuse.numina.module.IPowerModule;
import net.machinemuse.powersuits.common.config.MPSConfig;
import net.machinemuse.powersuits.item.armor.ItemPowerArmor;
import net.machinemuse.powersuits.item.armor.ItemPowerArmorBoots;
import net.machinemuse.powersuits.item.armor.ItemPowerArmorChestplate;
import net.machinemuse.powersuits.item.armor.ItemPowerArmorHelmet;
import net.machinemuse.powersuits.item.armor.ItemPowerArmorLeggings;
import net.machinemuse.powersuits.item.tool.ItemPowerFist;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public enum ModuleManager implements IModuleManager
{
    INSTANCE;

    protected static final Map<String, NonNullList<ItemStack>> installCosts;
    protected static final Map<String, NonNullList<ItemStack>> customInstallCosts;
    protected static final Map<String, IPowerModule> moduleMap;

    public void addModule(IPowerModule module) {
        moduleMap.put(module.getDataName(), module);
    }

    public NonNullList<IPowerModule> getAllModules() {
        NonNullList retList = NonNullList.func_191196_a();
        for (IPowerModule module : moduleMap.values()) {
            retList.add((Object)module);
        }
        return retList;
    }

    public boolean isValidForItem(@Nonnull ItemStack stack, IPowerModule module) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IModularItem)) {
            return false;
        }
        if (module == null || !MPSConfig.INSTANCE.getModuleAllowedorDefault(module.getDataName(), true)) {
            return false;
        }
        Item item = stack.func_77973_b();
        switch (module.getTarget()) {
            case ALLITEMS: {
                return true;
            }
            case TOOLONLY: {
                return item instanceof ItemPowerFist;
            }
            case ARMORONLY: {
                return item instanceof ItemPowerArmor;
            }
            case HEADONLY: {
                return item instanceof ItemPowerArmorHelmet;
            }
            case TORSOONLY: {
                return item instanceof ItemPowerArmorChestplate;
            }
            case LEGSONLY: {
                return item instanceof ItemPowerArmorLeggings;
            }
            case FEETONLY: {
                return item instanceof ItemPowerArmorBoots;
            }
        }
        return false;
    }

    public boolean isValidForItem(@Nonnull ItemStack stack, String moduleDataName) {
        IPowerModule module = this.getModule(moduleDataName);
        return this.isValidForItem(stack, module);
    }

    public Map<String, IPowerModule> getModuleMap() {
        return moduleMap;
    }

    @Nullable
    public IPowerModule getModule(String key) {
        return moduleMap.get(key);
    }

    public NonNullList<ItemStack> getInstallCost(String dataName) {
        return installCosts.getOrDefault(dataName, (NonNullList<ItemStack>)NonNullList.func_191196_a());
    }

    public void addInstallCost(String dataName, @Nonnull ItemStack installCost) {
        NonNullList<ItemStack> costForModule = this.getInstallCost(dataName);
        costForModule.add((Object)installCost);
        installCosts.put(dataName, costForModule);
    }

    public void addInstallCost(String dataName, NonNullList<ItemStack> installCost) {
        NonNullList<ItemStack> costForModule = this.getInstallCost(dataName);
        costForModule.addAll(installCost);
        installCosts.put(dataName, costForModule);
    }

    public boolean hasCustomInstallCost(String dataName) {
        return customInstallCosts.containsKey(dataName);
    }

    public NonNullList<ItemStack> getCustomInstallCost(String dataName) {
        return customInstallCosts.getOrDefault(dataName, (NonNullList<ItemStack>)NonNullList.func_191196_a());
    }

    public void addCustomInstallCost(String dataName, @Nonnull ItemStack installCost) {
        NonNullList<ItemStack> costForModule = this.getCustomInstallCost(dataName);
        costForModule.add((Object)installCost);
        customInstallCosts.put(dataName, costForModule);
    }

    static {
        installCosts = new HashMap<String, NonNullList<ItemStack>>();
        customInstallCosts = new HashMap<String, NonNullList<ItemStack>>();
        moduleMap = new LinkedHashMap<String, IPowerModule>();
    }
}

