/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.event;

import net.machinemuse.numina.client.sound.Musique;
import net.machinemuse.numina.config.NuminaConfig;
import net.machinemuse.numina.heat.MuseHeatUtils;
import net.machinemuse.numina.item.MuseItemUtils;
import net.machinemuse.numina.math.MuseMathUtils;
import net.machinemuse.numina.module.IPlayerTickModule;
import net.machinemuse.numina.module.IPowerModule;
import net.machinemuse.powersuits.client.sound.SoundDictionary;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.event.MovementManager;
import net.machinemuse.powersuits.item.armor.ItemPowerArmorBoots;
import net.machinemuse.powersuits.item.armor.ItemPowerArmorChestplate;
import net.machinemuse.powersuits.item.armor.ItemPowerArmorLeggings;
import net.machinemuse.powersuits.utils.MusePlayerUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PlayerUpdateHandler {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent e) {
        if (e.getEntity() instanceof EntityPlayer) {
            double currHeat;
            NonNullList modularItemsInInventory;
            EntityPlayer player = (EntityPlayer)e.getEntity();
            NonNullList modularItemsEquipped = MuseItemUtils.getModularItemsEquipped((EntityPlayer)player);
            for (ItemStack itemStack : modularItemsEquipped) {
                for (IPowerModule module : ModuleManager.INSTANCE.getModulesOfType(IPlayerTickModule.class)) {
                    if (!ModuleManager.INSTANCE.isValidForItem(itemStack, module) || !ModuleManager.INSTANCE.itemHasModule(itemStack, module.getDataName())) continue;
                    if (ModuleManager.INSTANCE.isModuleOnline(itemStack, module.getDataName())) {
                        ((IPlayerTickModule)module).onPlayerTickActive(player, itemStack);
                        continue;
                    }
                    ((IPlayerTickModule)module).onPlayerTickInactive(player, itemStack);
                }
            }
            player.field_70143_R = (float)MovementManager.computeFallHeightFromVelocity(MuseMathUtils.clampDouble((double)player.field_70181_x, (double)-1000.0, (double)0.0));
            if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
                if (modularItemsEquipped.size() > 0) {
                    double velsq2 = MuseMathUtils.sumsq((double)player.field_70159_w, (double)player.field_70181_x, (double)player.field_70179_y) - 0.5;
                    if (player.field_70160_al && velsq2 > 0.0) {
                        Musique.playerSound((EntityPlayer)player, (SoundEvent)SoundDictionary.SOUND_EVENT_GLIDER, (SoundCategory)SoundCategory.PLAYERS, (float)((float)(velsq2 / 3.0)), (Float)Float.valueOf(1.0f), (Boolean)true);
                    } else {
                        Musique.stopPlayerSound((EntityPlayer)player, (SoundEvent)SoundDictionary.SOUND_EVENT_GLIDER);
                    }
                } else {
                    Musique.stopPlayerSound((EntityPlayer)player, (SoundEvent)SoundDictionary.SOUND_EVENT_GLIDER);
                }
                if (!(player.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() instanceof ItemPowerArmorBoots)) {
                    Musique.stopPlayerSound((EntityPlayer)player, (SoundEvent)SoundDictionary.SOUND_EVENT_JETBOOTS);
                }
                if (!(player.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemPowerArmorChestplate)) {
                    Musique.stopPlayerSound((EntityPlayer)player, (SoundEvent)SoundDictionary.SOUND_EVENT_JETPACK);
                }
                if (!(player.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() instanceof ItemPowerArmorLeggings)) {
                    Musique.stopPlayerSound((EntityPlayer)player, (SoundEvent)SoundDictionary.SOUND_EVENT_SWIM_ASSIST);
                }
            }
            if ((modularItemsInInventory = MuseItemUtils.getModularItemsInInventory((EntityPlayer)player)).size() > 0 && (currHeat = MuseHeatUtils.getPlayerHeat((EntityPlayer)player)) >= 0.0 && !player.field_70170_p.field_72995_K) {
                double maxHeat;
                double coolPlayerAmount = MusePlayerUtils.getPlayerCoolingBasedOnMaterial(player) * 0.55;
                if (coolPlayerAmount > 0.0) {
                    MuseHeatUtils.coolPlayer((EntityPlayer)player, (double)coolPlayerAmount);
                }
                if (currHeat > (maxHeat = MuseHeatUtils.getPlayerMaxHeat((EntityPlayer)player))) {
                    player.func_70097_a(MuseHeatUtils.overheatDamage, (float)(Math.sqrt(currHeat - maxHeat) / 4.0));
                    player.func_70015_d(1);
                } else {
                    player.func_70066_B();
                }
            }
        }
    }
}

