/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.config;

import com.github.lehjr.numina.config.ClientConfig;
import com.github.lehjr.numina.config.ModuleConfig;
import com.github.lehjr.numina.config.ServerConfig;
import com.github.lehjr.numina.util.capabilities.module.powermodule.IConfig;
import java.util.Optional;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class NuminaSettings {
    public static final ClientConfig CLIENT_CONFIG;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ServerConfig SERVER_CONFIG;
    public static final ForgeConfigSpec SERVER_SPEC;
    private static volatile ModuleConfig moduleConfig;

    public static boolean useFovFix() {
        return CLIENT_CONFIG != null ? (Boolean)NuminaSettings.CLIENT_CONFIG.USE_FOV_FIX.get() : true;
    }

    public static boolean useFovNormalize() {
        return CLIENT_CONFIG != null ? (Boolean)NuminaSettings.CLIENT_CONFIG.USE_FOV_NORMALIZE.get() : true;
    }

    public static boolean fovFixDefaultState() {
        return CLIENT_CONFIG != null ? (Boolean)NuminaSettings.CLIENT_CONFIG.FOV_FIX_DEAULT_STATE.get() : true;
    }

    public static boolean useSounds() {
        return CLIENT_CONFIG != null ? (Boolean)NuminaSettings.CLIENT_CONFIG.USE_SOUNDS.get() : true;
    }

    public static boolean enableDebugging() {
        return CLIENT_CONFIG != null ? (Boolean)NuminaSettings.CLIENT_CONFIG.DEBUGGING_INFO.get() : false;
    }

    public static int chargingBaseMaxPower() {
        return NuminaSettings.getActiveConfig().map(config -> (Integer)config.ARMOR_STAND_MAX_POWER.get()).orElse(10000);
    }

    static Optional<ServerConfig> getActiveConfig() {
        return Optional.ofNullable(SERVER_SPEC.isLoaded() ? SERVER_CONFIG : null);
    }

    public static boolean useVanillaRecipes() {
        return SERVER_CONFIG != null ? (Boolean)NuminaSettings.SERVER_CONFIG.RECIPES_USE_VANILLA.get() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IConfig getModuleConfig() {
        if (moduleConfig != null) return moduleConfig;
        Class<ModuleConfig> clazz = ModuleConfig.class;
        synchronized (ModuleConfig.class) {
            if (moduleConfig != null) return moduleConfig;
            moduleConfig = new ModuleConfig("numina");
            // ** MonitorExit[var0] (shouldn't be in output)
            return moduleConfig;
        }
    }

    static {
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT_CONFIG = (ClientConfig)clientSpecPair.getLeft();
        Pair serverSpecPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)serverSpecPair.getRight();
        SERVER_CONFIG = (ServerConfig)serverSpecPair.getLeft();
    }
}

