/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.network.packets;

import com.github.lehjr.numina.util.capabilities.render.ModelSpecNBTCapability;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class CosmeticInfoPacket {
    protected static int itemSlot;
    protected String tagName;
    protected CompoundNBT tagData;

    public CosmeticInfoPacket() {
    }

    public CosmeticInfoPacket(int itemSlot, String tagName, CompoundNBT tagData) {
        CosmeticInfoPacket.itemSlot = itemSlot;
        this.tagName = tagName;
        this.tagData = tagData;
    }

    public static void encode(CosmeticInfoPacket msg, PacketBuffer packetBuffer) {
        packetBuffer.writeInt(itemSlot);
        packetBuffer.func_180714_a(msg.tagName);
        packetBuffer.func_150786_a(msg.tagData);
    }

    public static CosmeticInfoPacket decode(PacketBuffer packetBuffer) {
        return new CosmeticInfoPacket(packetBuffer.readInt(), packetBuffer.func_150789_c(500), packetBuffer.func_150793_b());
    }

    public static void handle(CosmeticInfoPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            int itemSlot = itemSlot;
            String tagName = message.tagName;
            CompoundNBT tagData = message.tagData;
            player.field_71071_by.func_70301_a(itemSlot).getCapability(ModelSpecNBTCapability.RENDER).ifPresent(render -> render.setRenderTag(tagData, tagName));
        });
        ctx.get().setPacketHandled(true);
    }
}

