/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.network.packets;

import com.github.lehjr.numina.util.capabilities.player.CapabilityPlayerKeyStates;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PlayerUpdatePacket {
    boolean downKeyState;
    boolean jumpKeyState;

    public PlayerUpdatePacket(boolean downKeyState, boolean jumpkeyState) {
        this.downKeyState = downKeyState;
        this.jumpKeyState = jumpkeyState;
    }

    public static void encode(PlayerUpdatePacket msg, PacketBuffer packetBuffer) {
        packetBuffer.writeBoolean(msg.downKeyState);
        packetBuffer.writeBoolean(msg.jumpKeyState);
    }

    public static PlayerUpdatePacket decode(PacketBuffer packetBuffer) {
        return new PlayerUpdatePacket(packetBuffer.readBoolean(), packetBuffer.readBoolean());
    }

    public static void handle(PlayerUpdatePacket message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        ctx.get().enqueueWork(() -> player.getCapability(CapabilityPlayerKeyStates.PLAYER_KEYSTATES).ifPresent(playerCap -> {
            playerCap.setDownKeyState(message.downKeyState);
            playerCap.setJumpKeyState(message.jumpKeyState);
        }));
        ctx.get().setPacketHandled(true);
    }
}

