/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.network.packets;

import com.github.lehjr.numina.util.capabilities.inventory.modularitem.IModularItem;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.CapabilityItemHandler;

public class TweakRequestDoublePacket {
    protected int itemSlot;
    protected ResourceLocation moduleName;
    protected String tweakName;
    protected double tweakValue;

    public TweakRequestDoublePacket() {
    }

    public TweakRequestDoublePacket(int itemSlot, ResourceLocation moduleRegName, String tweakName, double tweakValue) {
        this.itemSlot = itemSlot;
        this.moduleName = moduleRegName;
        this.tweakName = tweakName;
        this.tweakValue = tweakValue;
    }

    public static void encode(TweakRequestDoublePacket msg, PacketBuffer packetBuffer) {
        packetBuffer.writeInt(msg.itemSlot);
        packetBuffer.func_192572_a(msg.moduleName);
        packetBuffer.func_180714_a(msg.tweakName);
        packetBuffer.writeDouble(msg.tweakValue);
    }

    public static TweakRequestDoublePacket decode(PacketBuffer packetBuffer) {
        return new TweakRequestDoublePacket(packetBuffer.readInt(), packetBuffer.func_192575_l(), packetBuffer.func_150789_c(500), packetBuffer.readDouble());
    }

    public static void handle(TweakRequestDoublePacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            int itemSlot = message.itemSlot;
            ResourceLocation moduleName = message.moduleName;
            String tweakName = message.tweakName;
            double tweakValue = message.tweakValue;
            if (moduleName != null && tweakName != null) {
                ItemStack stack = player.field_71071_by.func_70301_a(itemSlot);
                stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(iItemHandler -> {
                    if (iItemHandler instanceof IModularItem) {
                        ((IModularItem)iItemHandler).setModuleTweakDouble(moduleName, tweakName, tweakValue);
                    }
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

