/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.capabilities.inventory.modechanging;

import com.github.lehjr.numina.network.NuminaPackets;
import com.github.lehjr.numina.network.packets.ModeChangeRequestPacket;
import com.github.lehjr.numina.util.capabilities.inventory.modechanging.IModeChangingItem;
import com.github.lehjr.numina.util.capabilities.inventory.modularitem.ModularItem;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.capabilities.module.rightclick.IRightClickModule;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModeChangingModularItem
extends ModularItem
implements IModeChangingItem {
    public static final String TAG_MODE = "mode";
    protected static int activeMode;

    public ModeChangingModularItem(@Nonnull ItemStack modularItem, int size) {
        this(modularItem, (NonNullList<ItemStack>)NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a));
    }

    public ModeChangingModularItem(@Nonnull ItemStack modularItem, NonNullList<ItemStack> stacks) {
        super(modularItem, stacks);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public IBakedModel getInventoryModel() {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(this.getActiveModule());
    }

    @Override
    public List<Integer> getValidModes() {
        this.updateFromNBT();
        ArrayList<Integer> moduleIndexes = new ArrayList<Integer>();
        for (int i = 1; i < this.getSlots(); ++i) {
            ItemStack module = this.getStackInSlot(i);
            if (!this.isValidMode(module)) continue;
            moduleIndexes.add(i);
        }
        return moduleIndexes;
    }

    boolean isValidMode(@Nonnull ItemStack module) {
        return module.getCapability(PowerModuleCapability.POWER_MODULE).map(m -> m.isAllowed() && m instanceof IRightClickModule).orElse(false);
    }

    @Override
    public boolean isValidMode(ResourceLocation mode) {
        for (int i = 1; i < this.getSlots(); ++i) {
            ItemStack module = this.getStackInSlot(i);
            if (module.func_190926_b() || !module.func_77973_b().getRegistryName().equals((Object)mode) || !this.isValidMode(module)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getActiveModule() {
        int activeModeIndex = this.getActiveMode();
        ItemStack module = activeModeIndex != -1 ? this.getStackInSlot(activeModeIndex) : ItemStack.field_190927_a;
        return module.getCapability(PowerModuleCapability.POWER_MODULE).map(m -> m.isAllowed() && m instanceof IRightClickModule).orElse(false) != false ? module : ItemStack.field_190927_a;
    }

    @Override
    public boolean hasActiveModule(ResourceLocation regName) {
        ItemStack module = this.getActiveModule();
        if (!module.func_190926_b()) {
            return module.func_77973_b().getRegistryName().equals((Object)regName);
        }
        return false;
    }

    @Override
    public int getActiveMode() {
        List<Integer> validModes;
        if (activeMode == -1 && !(validModes = this.getValidModes()).isEmpty()) {
            activeMode = validModes.get(0);
        }
        return activeMode;
    }

    @Override
    public void setActiveMode(ResourceLocation moduleName) {
        for (int i = 1; i < this.getSlots(); ++i) {
            ItemStack module = this.getStackInSlot(i);
            if (module.func_190926_b() || !module.func_77973_b().getRegistryName().equals((Object)moduleName) || !module.getCapability(PowerModuleCapability.POWER_MODULE).map(m -> m instanceof IRightClickModule).orElse(false).booleanValue()) continue;
            this.setActiveMode(i);
            return;
        }
    }

    @Override
    public void setActiveMode(int newMode) {
        activeMode = newMode;
        this.onContentsChanged(newMode);
    }

    @Override
    public void cycleMode(PlayerEntity player, int dMode) {
        List<Integer> modes = this.getValidModes();
        if (modes.size() > 0) {
            int newindex = ModeChangingModularItem.clampMode(modes.indexOf(this.getActiveMode()) + dMode, modes.size());
            int newmode = modes.get(newindex);
            this.setActiveMode(newmode);
            NuminaPackets.CHANNEL_INSTANCE.sendToServer((Object)new ModeChangeRequestPacket(newmode, player.field_71071_by.field_70461_c));
        }
    }

    @Override
    public int nextMode() {
        List<Integer> modes = this.getValidModes();
        if (modes.size() > 0) {
            int newindex = ModeChangingModularItem.clampMode(modes.indexOf(this.getActiveMode()) + 1, modes.size());
            return modes.get(newindex);
        }
        return -1;
    }

    @Override
    public int prevMode() {
        List<Integer> modes = this.getValidModes();
        if (modes.size() > 0) {
            int newindex = ModeChangingModularItem.clampMode(modes.indexOf(this.getActiveMode()) - 1, modes.size());
            return modes.get(newindex);
        }
        return -1;
    }

    private static int clampMode(int selection, int modesSize) {
        return selection > 0 ? selection % modesSize : (selection + modesSize * -selection) % modesSize;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        nbt.func_74768_a(TAG_MODE, activeMode);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        activeMode = nbt.func_74764_b(TAG_MODE) ? nbt.func_74762_e(TAG_MODE) : -1;
        super.deserializeNBT(nbt);
    }
}

