/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.capabilities.render;

import com.github.lehjr.numina.basemod.MuseLogger;
import com.github.lehjr.numina.util.capabilities.render.IModelSpecNBT;
import com.github.lehjr.numina.util.capabilities.render.modelspec.EnumSpecType;
import com.github.lehjr.numina.util.nbt.MuseNBTUtils;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.util.INBTSerializable;

public class ModelSpecNBT
implements IModelSpecNBT,
INBTSerializable<CompoundNBT> {
    ItemStack itemStack;
    static final String TAG_RENDER = "render";

    public ModelSpecNBT(@Nonnull ItemStack itemStackIn) {
        this.itemStack = itemStackIn;
    }

    @Override
    @Nonnull
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Override
    public CompoundNBT setRenderTag(CompoundNBT renderDataIn, String tagName) {
        CompoundNBT itemTag = MuseNBTUtils.getMuseItemTag(this.itemStack);
        if (tagName != null) {
            if (Objects.equals(tagName, TAG_RENDER)) {
                itemTag.func_82580_o(TAG_RENDER);
                if (!renderDataIn.isEmpty()) {
                    itemTag.func_218657_a(TAG_RENDER, (INBT)renderDataIn);
                }
            } else {
                CompoundNBT renderTag;
                if (!itemTag.func_74764_b(TAG_RENDER)) {
                    renderTag = new CompoundNBT();
                    itemTag.func_218657_a(TAG_RENDER, (INBT)renderTag);
                } else {
                    renderTag = itemTag.func_74775_l(TAG_RENDER);
                }
                if (renderDataIn.isEmpty()) {
                    MuseLogger.logger.debug("Removing tag " + tagName);
                    renderTag.func_82580_o(tagName);
                } else {
                    MuseLogger.logger.debug("Adding tag " + tagName + " : " + renderDataIn);
                    renderTag.func_218657_a(tagName, (INBT)renderDataIn);
                }
            }
        }
        return this.getRenderTag();
    }

    @Override
    public EnumSpecType getSpecType() {
        if (this.itemStack.getEquipmentSlot() == null) {
            return EnumSpecType.HANDHELD;
        }
        return EnumSpecType.NONE;
    }

    @Override
    @Nullable
    public CompoundNBT getRenderTag() {
        CompoundNBT itemTag = MuseNBTUtils.getMuseItemTag(this.itemStack);
        return itemTag.func_74775_l(TAG_RENDER);
    }

    @Override
    public CompoundNBT getDefaultRenderTag() {
        return new CompoundNBT();
    }

    @Override
    public List<Integer> addNewColourstoList(List<Integer> colours, List<Integer> coloursToAdd) {
        for (Integer i : coloursToAdd) {
            if (colours.contains(i)) continue;
            colours.add(i);
        }
        return colours;
    }

    @Override
    public int[] getColorArray() {
        return this.getRenderTag().func_74759_k("colours");
    }

    @Override
    public int getNewColourIndex(List<Integer> colours, List<Integer> oldColours, Integer index) {
        return colours.indexOf(oldColours.get(index != null ? index : 0));
    }

    @Override
    public CompoundNBT setColorArray(int[] colors) {
        this.getRenderTag().func_74783_a("colours", colors);
        return this.getRenderTag();
    }

    public CompoundNBT serializeNBT() {
        return this.getRenderTag();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.setRenderTag(nbt, TAG_RENDER);
    }
}

