/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.capabilities.render.modelspec;

import com.github.lehjr.numina.util.capabilities.render.modelspec.ModelSpec;
import com.github.lehjr.numina.util.capabilities.render.modelspec.PartSpecBase;
import com.github.lehjr.numina.util.capabilities.render.modelspec.SpecBinding;
import com.github.lehjr.numina.util.client.model.obj.OBJBakedPart;
import java.util.Objects;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelPartSpec
extends PartSpecBase {
    private final boolean defaultglow;

    public ModelPartSpec(ModelSpec modelSpec, SpecBinding binding, String partName, Integer defaultcolourindex, Boolean defaultglow) {
        super(modelSpec, binding, partName, defaultcolourindex);
        this.defaultglow = defaultglow != null ? defaultglow : false;
    }

    @Override
    public ITextComponent getDisaplayName() {
        return new TranslationTextComponent("model." + this.spec.getOwnName() + "." + this.partName + ".partName");
    }

    public boolean getGlow() {
        return this.defaultglow;
    }

    public boolean getGlow(CompoundNBT nbt) {
        return nbt.func_74764_b("glow") ? nbt.func_74767_n("glow") : this.defaultglow;
    }

    public void setGlow(CompoundNBT nbt, boolean g) {
        if (g == this.defaultglow) {
            nbt.func_82580_o("glow");
        } else {
            nbt.func_74757_a("glow", g);
        }
    }

    public OBJBakedPart getPart() {
        return ((ModelSpec)this.spec).getModel().getPart(this.partName);
    }

    public CompoundNBT multiSet(CompoundNBT nbt, Integer colourIndex, Boolean glow) {
        super.multiSet(nbt, colourIndex);
        this.setGlow(nbt, glow != null ? glow : false);
        return nbt;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelPartSpec that = (ModelPartSpec)o;
        return this.defaultglow == that.defaultglow;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.defaultglow);
    }
}

