/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui;

import com.github.lehjr.numina.util.client.gui.frame.IGuiFrame;
import com.github.lehjr.numina.util.client.gui.gemoetry.DrawableMuseRect;
import com.github.lehjr.numina.util.math.Colour;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.text.ITextComponent;

public class ExtendedContainerScreen<T extends Container>
extends ContainerScreen<T> {
    protected long creationTime;
    protected DrawableMuseRect tooltipRect;
    private List<IGuiFrame> frames = new ArrayList<IGuiFrame>();

    public ExtendedContainerScreen(T screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super(screenContainer, inv, titleIn);
        this.tooltipRect = new DrawableMuseRect(0.0, 0.0, 0.0, 0.0, false, Colour.BLACK.withAlpha(0.9f), Colour.PURPLE);
    }

    public void func_231158_b_(Minecraft minecraft, int width, int height) {
        super.func_231158_b_(minecraft, width, height);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.creationTime = System.currentTimeMillis();
    }

    public void addFrame(IGuiFrame frame) {
        this.frames.add(frame);
    }

    public void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        this.update(x, y);
        this.renderFrames(matrixStack, x, y, partialTicks);
    }

    public void update(double x, double y) {
        for (IGuiFrame frame : this.frames) {
            frame.update(x, y);
        }
    }

    public void renderFrames(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        for (IGuiFrame frame : this.frames) {
            frame.render(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double dWheel) {
        for (IGuiFrame frame : this.frames) {
            if (!frame.mouseScrolled(mouseX, mouseY, dWheel)) continue;
            return true;
        }
        return super.func_231043_a_(mouseX, mouseY, dWheel);
    }

    public boolean func_231044_a_(double x, double y, int button) {
        for (IGuiFrame frame : this.frames) {
            if (!frame.mouseClicked(x, y, button)) continue;
            return true;
        }
        return super.func_231044_a_(x, y, button);
    }

    public boolean func_231048_c_(double x, double y, int which) {
        for (IGuiFrame frame : this.frames) {
            frame.mouseReleased(x, y, which);
        }
        return super.func_231048_c_(x, y, which);
    }

    public void drawToolTip(MatrixStack matrixStack, int mouseX, int mouseY) {
        List<ITextComponent> tooltip = this.getToolTip(mouseX, mouseY);
        if (tooltip != null) {
            this.func_243308_b(matrixStack, tooltip, mouseX, mouseY);
        }
    }

    public List<ITextComponent> getToolTip(int x, int y) {
        for (IGuiFrame frame : this.frames) {
            List<ITextComponent> hitTip = frame.getToolTip(x, y);
            if (hitTip == null) continue;
            return hitTip;
        }
        return null;
    }

    public void setXSize(int xSize) {
        this.field_146999_f = xSize;
        this.field_147003_i = (this.field_230708_k_ - this.getXSize()) / 2;
    }

    public void setYSize(int ySize) {
        this.field_147000_g = ySize;
        this.field_147009_r = (this.field_230709_l_ - this.getYSize()) / 2;
    }

    public int absX(double relx) {
        int absx = (int)((relx + 1.0) * (double)this.getXSize() / 2.0);
        int xpadding = (this.field_230708_k_ - this.getXSize()) / 2;
        return absx + xpadding;
    }

    public int relX(double absx) {
        int padding = (this.field_230708_k_ - this.getXSize()) / 2;
        return (int)((absx - (double)padding) * 2.0 / (double)this.getXSize() - 1.0);
    }

    public int absY(double rely) {
        int absy = (int)((rely + 1.0) * (double)this.getYSize() / 2.0);
        int ypadding = (this.field_230709_l_ - this.getYSize()) / 2;
        return absy + ypadding;
    }

    public int relY(float absy) {
        int padding = (this.field_230709_l_ - this.getYSize()) / 2;
        return (int)((absy - (float)padding) * 2.0f / (float)this.getYSize() - 1.0f);
    }
}

