/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui;

import com.github.lehjr.numina.constants.NuminaConstants;
import com.github.lehjr.numina.util.client.NuminaSpriteUploader;
import com.github.lehjr.numina.util.client.render.BillboardHelper;
import com.github.lehjr.numina.util.client.render.NuminaRenderState;
import com.github.lehjr.numina.util.math.Colour;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;

public class GuiIcon {
    private static final String iconPrefix = "gui";
    private final NuminaSpriteUploader spriteUploader;
    public final DrawableGuiIcon checkmark;
    public final DrawableGuiIcon transparentArmor;
    public final DrawableGuiIcon normalArmor;
    public final DrawableGuiIcon glowArmor;
    public final DrawableGuiIcon selectedArmorOverlay;
    public final DrawableGuiIcon armorColourPatch;
    public final DrawableGuiIcon minusSign;
    public final DrawableGuiIcon plusSign;
    public final DrawableGuiIcon glassTexture;
    public final DrawableGuiIcon lightning;

    public GuiIcon(NuminaSpriteUploader spriteUploader) {
        this.spriteUploader = spriteUploader;
        this.checkmark = this.registerIcon("checkmark", 16, 16);
        this.transparentArmor = this.registerIcon("transparentarmor", 8, 8);
        this.normalArmor = this.registerIcon("normalarmor", 8, 8);
        this.glowArmor = this.registerIcon("glowarmor", 8, 8);
        this.selectedArmorOverlay = this.registerIcon("armordisplayselect", 8, 8);
        this.armorColourPatch = this.registerIcon("colourclicker", 8, 8);
        this.minusSign = this.registerIcon("minussign", 8, 8);
        this.plusSign = this.registerIcon("plussign", 8, 8);
        this.glassTexture = this.registerIcon("glass", 1, 8);
        this.lightning = this.registerIcon("lightning", 800, 62);
    }

    private DrawableGuiIcon registerIcon(String name, int width, int height) {
        ResourceLocation location = new ResourceLocation("numina", name);
        this.spriteUploader.registerIcon(location);
        return new DrawableGuiIcon(location, width, height, iconPrefix);
    }

    public static void renderIcon8(ResourceLocation location, MatrixStack matrixStack, double left, double top, double right, double bottom, float zLevel) {
        GuiIcon.renderIcon8(location, matrixStack, left, top, right, bottom, zLevel, Colour.WHITE);
    }

    public static void renderIcon8(ResourceLocation location, MatrixStack matrixStack, double left, double top, double right, double bottom, float zLevel, Colour colour) {
        GuiIcon.renderTextureWithColour(location, matrixStack, left, right, top, bottom, zLevel, 8.0, 8.0, 0.0, 0.0, 8.0, 8.0, colour);
    }

    public static void renderIcon16(ResourceLocation location, MatrixStack matrixStack, double left, double top, double right, double bottom, float zLevel) {
        GuiIcon.renderIcon16(location, matrixStack, left, top, right, bottom, zLevel, Colour.WHITE);
    }

    public static void renderIcon16(ResourceLocation location, MatrixStack matrixStack, double left, double top, double right, double bottom, float zLevel, Colour colour) {
        GuiIcon.renderTextureWithColour(location, matrixStack, left, right, top, bottom, zLevel, 16.0, 16.0, 0.0, 0.0, 16.0, 16.0, colour);
    }

    public static void renderTextureWithColour(ResourceLocation location, MatrixStack matrixStack, double left, double right, double top, double bottom, float zLevel, double iconWidth, double iconHeight, double texStartX, double texStartY, double textureWidth, double textureHeight, Colour colour) {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_110434_K().func_110577_a(location);
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        GuiIcon.innerBlit(matrixStack, left, right, top, bottom, zLevel, iconWidth, iconHeight, texStartX, texStartY, textureWidth, textureHeight, colour);
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
    }

    private static void innerBlit(MatrixStack matrixStack, double left, double right, double top, double bottom, float zLevel, double iconWidth, double iconHeight, double texStartX, double texStartY, double textureWidth, double textureHeight, Colour colour) {
        GuiIcon.innerBlit(matrixStack.func_227866_c_().func_227870_a_(), left, right, top, bottom, zLevel, (float)((texStartX + 0.0) / textureWidth), (float)((texStartX + iconWidth) / textureWidth), (float)((texStartY + 0.0) / textureHeight), (float)((texStartY + iconHeight) / textureHeight), colour);
    }

    private static void innerBlit(Matrix4f matrix4f, double left, double right, double top, double bottom, float zLevel, float minU, float maxU, float minV, float maxV, Colour colour) {
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        colour.doGL();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f, (float)left, (float)bottom, zLevel).func_225583_a_(minU, maxV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f, (float)right, (float)bottom, zLevel).func_225583_a_(maxU, maxV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f, (float)right, (float)top, zLevel).func_225583_a_(maxU, minV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f, (float)left, (float)top, zLevel).func_225583_a_(minU, minV).func_181675_d();
        bufferbuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }

    public void drawLightningTextured(IVertexBuilder bufferIn, Matrix4f matrix4f, float x1, float y1, float z1, float x2, float y2, float z2, Colour colour, TextureAtlasSprite icon, float textureWidth, float textureHeight) {
        float minV = icon.func_94206_g();
        float maxV = icon.func_94210_h();
        float uSize = icon.func_94212_f() - icon.func_94209_e();
        float tx = x2 - x1;
        float ty = y2 - y1;
        float tz = z2 - z1;
        float cx = 0.0f;
        float cy = 0.0f;
        float cz = 0.0f;
        float jagfactor = 0.3f;
        while (Math.abs(cx) < Math.abs(tx) && Math.abs(cy) < Math.abs(ty) && Math.abs(cz) < Math.abs(tz)) {
            float ax = x1 + cx;
            float ay = y1 + cy;
            float az = z1 + cz;
            cx = (float)((double)cx + (Math.random() * (double)tx * (double)jagfactor - 0.1 * (double)tx));
            cy = (float)((double)cy + (Math.random() * (double)ty * (double)jagfactor - 0.1 * (double)ty));
            cz = (float)((double)cz + (Math.random() * (double)tz * (double)jagfactor - 0.1 * (double)tz));
            float bx = x1 + cx;
            float by = y1 + cy;
            float bz = z1 + cz;
            int index = this.getRandomNumber(0, 50);
            float minU = icon.func_94209_e() + uSize * ((float)index * 0.2f);
            float maxU = minU + uSize * 0.2f;
            this.drawLightningBetweenPointsFast(bufferIn, matrix4f, ax, ay, az, bx, by, bz, colour, minU, maxU, minV, maxV);
        }
    }

    void drawLightningBetweenPointsFast(IVertexBuilder bufferIn, Matrix4f matrix4f, float x1, float y1, float z1, float x2, float y2, float z2, Colour colour, float minU, float maxU, float minV, float maxV) {
        float px = (y1 - y2) * 0.125f;
        float py = (x2 - x1) * 0.125f;
        bufferIn.func_227888_a_(matrix4f, x1 - px, y1 - py, z1).func_227885_a_(colour.r, colour.g, colour.b, colour.a).func_225583_a_(minU, minV).func_227886_a_(0xF000F0).func_181675_d();
        bufferIn.func_227888_a_(matrix4f, x1 + px, y1 + py, z1).func_227885_a_(colour.r, colour.g, colour.b, colour.a).func_225583_a_(maxU, minV).func_227886_a_(0xF000F0).func_181675_d();
        bufferIn.func_227888_a_(matrix4f, x2 - px, y2 - py, z2).func_227885_a_(colour.r, colour.g, colour.b, colour.a).func_225583_a_(minU, maxV).func_227886_a_(0xF000F0).func_181675_d();
        bufferIn.func_227888_a_(matrix4f, x2 + px, y2 + py, z2).func_227885_a_(colour.r, colour.g, colour.b, colour.a).func_225583_a_(maxU, maxV).func_227886_a_(0xF000F0).func_181675_d();
    }

    Minecraft getMinecraft() {
        return Minecraft.func_71410_x();
    }

    void bindTexture() {
        TextureManager textureManager = this.getMinecraft().func_110434_K();
        textureManager.func_110577_a(NuminaConstants.LOCATION_NUMINA_GUI_TEXTURE_ATLAS);
    }

    int getRandomNumber(int min, int max) {
        return (int)(Math.random() * (double)(max - min) + (double)min);
    }

    public void unRotate() {
        BillboardHelper.unRotate();
    }

    public class DrawableGuiIcon {
        final ResourceLocation location;
        private final int width;
        private final int height;
        String prefix;

        protected DrawableGuiIcon(ResourceLocation locationIn, int width, int height, String prefix) {
            this.location = locationIn;
            this.width = width;
            this.height = height;
            this.prefix = prefix;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public void draw(MatrixStack matrixStack, double x, double y, Colour colour) {
            this.draw(matrixStack, x, y, 0.0, 0.0, 0.0, 0.0, colour);
        }

        public void draw(MatrixStack matrixStack, double xOffset, double yOffset, double maskTop, double maskBottom, double maskLeft, double maskRight, Colour colour) {
            double textureWidth = this.width;
            double textureHeight = this.height;
            GuiIcon.this.bindTexture();
            TextureAtlasSprite icon = GuiIcon.this.spriteUploader.func_215282_a(this.location);
            float zLevel = GuiIcon.this.getMinecraft().field_71462_r.func_230927_p_();
            double posLeft = xOffset + maskLeft;
            double posTop = yOffset + maskTop;
            double width = textureWidth - maskRight - maskLeft;
            double height = textureHeight - maskBottom - maskTop;
            double posRight = posLeft + width;
            double posBottom = posTop + height;
            double uSize = icon.func_94212_f() - icon.func_94209_e();
            double vSize = icon.func_94210_h() - icon.func_94206_g();
            float minU = (float)((double)icon.func_94209_e() + uSize * (maskLeft / textureWidth));
            float minV = (float)((double)icon.func_94206_g() + vSize * (maskTop / textureHeight));
            float maxU = (float)((double)icon.func_94212_f() - uSize * (maskRight / textureWidth));
            float maxV = (float)((double)icon.func_94210_h() - vSize * (maskBottom / textureHeight));
            RenderSystem.enableBlend();
            RenderSystem.disableAlphaTest();
            RenderSystem.defaultBlendFunc();
            GuiIcon.innerBlit(matrixStack.func_227866_c_().func_227870_a_(), posLeft, posRight, posTop, posBottom, zLevel, minU, maxU, minV, maxV, colour);
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
        }

        public TextureAtlasSprite getSprite() {
            return GuiIcon.this.spriteUploader.func_215282_a(this.location);
        }

        public String toString() {
            Minecraft minecraft = Minecraft.func_71410_x();
            TextureManager textureManager = minecraft.func_110434_K();
            textureManager.func_110577_a(NuminaConstants.LOCATION_NUMINA_GUI_TEXTURE_ATLAS);
            TextureAtlasSprite icon = this.getSprite();
            if (icon != null) {
                return "icon: " + icon.toString();
            }
            return "icon is null for location: " + this.location.toString();
        }

        public void drawLightning(IRenderTypeBuffer bufferIn, MatrixStack matrixStack, float x1, float y1, float z1, float x2, float y2, float z2, Colour colour) {
            TextureAtlasSprite icon = this.getSprite();
            GuiIcon.this.drawLightningTextured(bufferIn.getBuffer(NuminaRenderState.LIGHTNING_TEST()), matrixStack.func_227866_c_().func_227870_a_(), x1, y1, z1, x2, y2, z2, colour, icon, this.width, this.height);
        }
    }
}

