/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.clickable;

import com.github.lehjr.numina.util.client.gui.clickable.IClickable;
import com.github.lehjr.numina.util.client.gui.gemoetry.DrawableMuseRect;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.gui.gemoetry.MuseRect;
import com.github.lehjr.numina.util.math.Colour;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.util.text.ITextComponent;

public class Button
extends DrawableMuseRect
implements IClickable {
    protected IClickable.IPressable onPressed;
    protected IClickable.IReleasable onReleased;
    protected boolean isEnabled = true;
    protected boolean isVisible = true;
    Colour backgroundColourEnabled;
    Colour backgroundColourDisabled;
    Colour borderColourEnabled;
    Colour borderColourDisabled;
    int highlight = 5;

    public Button(double left, double top, double right, double bottom, boolean growFromMiddle, Colour backgroundColourEnabled, Colour backgroundColourDisabled, Colour borderColourEnabled, Colour borderColourDisabled) {
        super(left, top, right, bottom, growFromMiddle, backgroundColourEnabled, borderColourEnabled);
        this.backgroundColourEnabled = backgroundColourEnabled;
        this.backgroundColourDisabled = backgroundColourDisabled;
        this.borderColourEnabled = borderColourEnabled;
        this.borderColourDisabled = borderColourDisabled;
    }

    public Button(double left, double top, double right, double bottom, Colour backgroundColourEnabled, Colour backgroundColourDisabled, Colour borderColourEnabled, Colour borderColourDisabled) {
        super(left, top, right, bottom, backgroundColourEnabled, borderColourEnabled);
        this.backgroundColourEnabled = backgroundColourEnabled;
        this.backgroundColourDisabled = backgroundColourDisabled;
        this.borderColourEnabled = borderColourEnabled;
        this.borderColourDisabled = borderColourDisabled;
    }

    public Button(MusePoint2D ul, MusePoint2D br, Colour backgroundColourEnabled, Colour backgroundColourDisabled, Colour borderColourEnabled, Colour borderColourDisabled) {
        super(ul, br, backgroundColourEnabled, borderColourEnabled);
        this.backgroundColourEnabled = backgroundColourEnabled;
        this.backgroundColourDisabled = backgroundColourDisabled;
        this.borderColourEnabled = borderColourEnabled;
        this.borderColourDisabled = borderColourDisabled;
    }

    public Button(MuseRect ref, Colour backgroundColourEnabled, Colour backgroundColourDisabled, Colour borderColourEnabled, Colour borderColourDisabled) {
        super(ref, backgroundColourEnabled, borderColourEnabled);
        this.backgroundColourEnabled = backgroundColourEnabled;
        this.backgroundColourDisabled = backgroundColourDisabled;
        this.borderColourEnabled = borderColourEnabled;
        this.borderColourDisabled = borderColourDisabled;
    }

    @Override
    public void setOnPressed(IClickable.IPressable onPressed) {
        this.onPressed = onPressed;
    }

    @Override
    public void setOnReleased(IClickable.IReleasable onReleased) {
        this.onReleased = onReleased;
    }

    @Override
    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks, float zLevel) {
        if (this.isVisible) {
            if (this.isEnabled()) {
                if (this.hitBox(mouseX, mouseY)) {
                    super.setBackgroundColour(new Colour((byte)(this.backgroundColourEnabled.r + (float)this.highlight < 255.0f ? this.backgroundColourEnabled.r + (float)this.highlight : 255.0f), (byte)(this.backgroundColourEnabled.g + (float)this.highlight < 255.0f ? this.backgroundColourEnabled.g + (float)this.highlight : 255.0f), (byte)(this.backgroundColourEnabled.b + (float)this.highlight < 255.0f ? this.backgroundColourEnabled.b + (float)this.highlight : 255.0f), 1.0f));
                } else {
                    super.setBackgroundColour(this.backgroundColourEnabled);
                }
                super.setBorderColour(this.borderColourEnabled);
            } else {
                super.setBackgroundColour(this.backgroundColourDisabled);
                super.setBorderColour(this.borderColourDisabled);
            }
            super.draw(matrixStack, zLevel);
        }
    }

    @Override
    public void move(double x, double y) {
        this.setLeft(x - this.width() / 2.0);
        this.setRight(y - this.height() / 2.0);
    }

    @Override
    public MusePoint2D getPosition() {
        return new MusePoint2D(this.centerx(), this.centery());
    }

    @Override
    public boolean hitBox(double x, double y) {
        if (this.isVisible() && this.isEnabled()) {
            return x >= this.left() && x <= this.right() && y >= this.top() && y <= this.bottom();
        }
        return false;
    }

    @Override
    public List<ITextComponent> getToolTip() {
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void onReleased() {
        if (this.isVisible && this.isEnabled && this.onReleased != null) {
            this.onReleased.onReleased(this);
        }
    }

    @Override
    public void onPressed() {
        if (this.isVisible && this.isEnabled && this.onPressed != null) {
            this.onPressed.onPressed(this);
        }
    }
}

