/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.clickable;

import com.github.lehjr.numina.util.client.gui.clickable.Clickable;
import com.github.lehjr.numina.util.client.gui.gemoetry.DrawableTile;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.render.MuseRenderer;
import com.github.lehjr.numina.util.math.Colour;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;

public class CheckBox
extends Clickable {
    protected boolean isChecked;
    protected DrawableTile tile;
    String label;

    public CheckBox(MusePoint2D position, String displayString, boolean isChecked) {
        MusePoint2D ul = position.plus(4.0, 4.0);
        this.tile = new DrawableTile(ul, ul.plus(8.0, 8.0)).setBackgroundColour(Colour.BLACK).setTopBorderColour(Colour.DARK_GREY).setBottomBorderColour(Colour.DARK_GREY);
        this.label = displayString;
        this.isChecked = isChecked;
        this.enableAndShow();
    }

    @Override
    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks, float zLevel) {
        if (this.isVisible) {
            this.tile.draw(matrixStack, zLevel);
            if (this.isChecked) {
                MuseRenderer.drawString(matrixStack, "x", this.tile.centerx() - 2.0, this.tile.centery() - 5.0, Colour.WHITE);
            }
            MuseRenderer.drawString(matrixStack, this.label, this.tile.centerx() + 8.0, this.tile.centery() - 4.0, Colour.WHITE);
        }
    }

    @Override
    public boolean hitBox(double x, double y) {
        if (this.isVisible() && this.isEnabled()) {
            return this.tile.containsPoint(x, y);
        }
        return false;
    }

    @Override
    public void setPosition(MusePoint2D position) {
        super.setPosition(position);
        this.tile.setPosition(position);
    }

    @Override
    public List<ITextComponent> getToolTip() {
        return null;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean checked) {
        this.isChecked = checked;
    }

    @Override
    public void onPressed() {
        if (this.isVisible() && this.isEnabled()) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            this.isChecked = !this.isChecked;
        }
        super.onPressed();
    }
}

