/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.clickable;

import com.github.lehjr.numina.util.client.gui.clickable.IClickable;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import java.util.List;
import net.minecraft.util.text.ITextComponent;

public abstract class Clickable
implements IClickable {
    protected MusePoint2D position;
    IClickable.IPressable onPressed;
    IClickable.IReleasable onReleased;
    boolean isEnabled = true;
    boolean isVisible = true;

    public Clickable() {
        this.position = new MusePoint2D(0.0, 0.0);
    }

    public Clickable(MusePoint2D point) {
        this.position = point;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    public void enable() {
        this.isEnabled = true;
    }

    @Override
    public void disable() {
        this.isEnabled = false;
    }

    @Override
    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void hide() {
        this.isVisible = false;
    }

    @Override
    public void show() {
        this.isVisible = true;
    }

    @Override
    public void enableAndShow() {
        this.enable();
        this.show();
    }

    @Override
    public void disableAndHide() {
        this.disable();
        this.hide();
    }

    @Override
    public MusePoint2D getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(MusePoint2D position) {
        this.position = position;
    }

    @Override
    public void move(double x, double y) {
        this.move(new MusePoint2D(x, y));
    }

    @Override
    public void move(MusePoint2D positionIn) {
        this.setPosition(this.position.plus(positionIn));
    }

    @Override
    public void setOnPressed(IClickable.IPressable onPressed) {
        this.onPressed = onPressed;
    }

    @Override
    public void setOnReleased(IClickable.IReleasable onReleased) {
        this.onReleased = onReleased;
    }

    @Override
    public void onPressed() {
        if (this.isVisible() && this.isEnabled() && this.onPressed != null) {
            this.onPressed.onPressed(this);
        }
    }

    @Override
    public void onReleased() {
        if (this.isVisible() && this.isEnabled() && this.onReleased != null) {
            this.onReleased.onReleased(this);
        }
    }

    @Override
    public List<ITextComponent> getToolTip() {
        return null;
    }
}

