/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.clickable;

import com.github.lehjr.numina.util.client.gui.clickable.IClickable;
import com.github.lehjr.numina.util.client.gui.gemoetry.DrawableArrow;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.gui.gemoetry.MuseRelativeRect;
import com.github.lehjr.numina.util.math.Colour;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.util.text.ITextComponent;

public class ClickableArrow
extends DrawableArrow
implements IClickable {
    protected IClickable.IPressable onPressed;
    protected IClickable.IReleasable onReleased;
    protected final Colour backgroundColourNotHighlighted;
    protected final Colour backgroundColourHighlighted;
    protected boolean isEnabled = true;
    protected boolean isVisible = true;

    public ClickableArrow(float left, float top, float right, float bottom, boolean growFromMiddle, Colour backgroundColour, Colour backgroundColourHighlighted, Colour borderColour) {
        super(left, top, right, bottom, growFromMiddle, backgroundColour, borderColour);
        this.backgroundColourNotHighlighted = backgroundColour;
        this.backgroundColourHighlighted = backgroundColourHighlighted;
    }

    public ClickableArrow(float left, float top, float right, float bottom, Colour backgroundColour, Colour backgroundColourHighlighted, Colour borderColour) {
        super(left, top, right, bottom, backgroundColour, borderColour);
        this.backgroundColourNotHighlighted = backgroundColour;
        this.backgroundColourHighlighted = backgroundColourHighlighted;
    }

    public ClickableArrow(MusePoint2D ul, MusePoint2D br, Colour backgroundColour, Colour backgroundColourHighlighted, Colour borderColour) {
        super(ul, br, backgroundColour, borderColour);
        this.backgroundColourNotHighlighted = backgroundColour;
        this.backgroundColourHighlighted = backgroundColourHighlighted;
    }

    public ClickableArrow(MuseRelativeRect ref, Colour backgroundColour, Colour backgroundColourHighlighted, Colour borderColour) {
        super(ref, backgroundColour, borderColour);
        this.backgroundColourNotHighlighted = backgroundColour;
        this.backgroundColourHighlighted = backgroundColourHighlighted;
    }

    @Override
    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks, float zLevel) {
        if (this.isVisible) {
            super.setBackgroundColour(this.hitBox(mouseX, mouseY) ? this.backgroundColourHighlighted : this.backgroundColourNotHighlighted);
            this.draw(matrixStack, zLevel);
        }
    }

    @Override
    public MusePoint2D getPosition() {
        return new MusePoint2D(this.centerx(), this.centery());
    }

    @Override
    public boolean hitBox(double x, double y) {
        if (this.isVisible() && this.isEnabled()) {
            return x >= this.left() && x <= this.right() && y >= this.top() && y <= this.bottom();
        }
        return false;
    }

    @Override
    public List<ITextComponent> getToolTip() {
        return null;
    }

    @Override
    public void setOnPressed(IClickable.IPressable onPressed) {
        this.onPressed = onPressed;
    }

    @Override
    public void setOnReleased(IClickable.IReleasable onReleased) {
        this.onReleased = onReleased;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void onReleased() {
        if (this.isVisible && this.isEnabled && this.onReleased != null) {
            this.onReleased.onReleased(this);
        }
    }

    @Override
    public void onPressed() {
        if (this.isVisible && this.isEnabled && this.onPressed != null) {
            this.onPressed.onPressed(this);
        }
    }
}

