/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.clickable;

import com.github.lehjr.numina.util.client.gui.clickable.Clickable;
import com.github.lehjr.numina.util.client.gui.gemoetry.DrawableMuseRect;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.render.MuseRenderer;
import com.github.lehjr.numina.util.math.Colour;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.util.text.ITextComponent;

public class ClickableButton
extends Clickable {
    protected ITextComponent label;
    protected MusePoint2D radius;
    protected DrawableMuseRect rect;
    private final Colour enabledBorder = new Colour(0.3f, 0.3f, 0.3f, 1.0f);
    private final Colour enabledBackground = new Colour(0.5f, 0.6f, 0.8f, 1.0f);
    private final Colour disabledBorder = new Colour(0.8f, 0.6f, 0.6f, 1.0f);
    private final Colour disabledBackground = new Colour(0.8f, 0.3f, 0.3f, 1.0f);

    public ClickableButton(ITextComponent label, MusePoint2D position, boolean enabled) {
        this.label = label;
        this.position = position;
        if (label.getString().contains("\n")) {
            String[] x = label.getString().split("\n");
            int longestIndex = 0;
            for (int i = 0; i < x.length; ++i) {
                if (x[i].length() <= x[longestIndex].length()) continue;
                longestIndex = i;
            }
            this.radius = new MusePoint2D((float)(MuseRenderer.getStringWidth(x[longestIndex]) / 2.0 + 2.0), 6 * x.length);
        } else {
            this.radius = new MusePoint2D((float)(MuseRenderer.getStringWidth(label.getString()) / 2.0 + 2.0), 6.0);
        }
        this.rect = new DrawableMuseRect(position.getX() - this.radius.getX(), position.getY() - this.radius.getY(), position.getX() + this.radius.getX(), position.getY() + this.radius.getY(), this.enabledBorder, this.enabledBackground);
        this.setEnabled(enabled);
    }

    @Override
    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks, float zLevel) {
        this.renderButton(matrixStack, mouseX, mouseY, partialTicks, zLevel);
        this.renderText(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void renderButton(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks, float zLevel) {
        if (this.isVisible) {
            this.rect.setLeft(this.position.getX() - this.radius.getX());
            this.rect.setTop(this.position.getY() - this.radius.getY());
            this.rect.setRight(this.position.getX() + this.radius.getX());
            this.rect.setBottom(this.position.getY() + this.radius.getY());
            this.rect.setBorderColour(this.isEnabled() ? this.enabledBorder : this.disabledBorder);
            this.rect.setBackgroundColour(this.isEnabled() ? this.enabledBackground : this.disabledBackground);
            this.rect.draw(matrixStack, zLevel);
        }
    }

    public void renderText(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible) {
            if (this.label.getString().contains("\n")) {
                String[] s = this.label.getString().split("\n");
                for (int i = 0; i < s.length; ++i) {
                    MuseRenderer.drawCenteredString(matrixStack, s[i], this.position.getX(), this.position.getY() - (double)(4 * s.length) + (double)(i * 8));
                }
            } else {
                MuseRenderer.drawCenteredString(matrixStack, this.label.getString(), this.position.getX(), this.position.getY() - 4.0);
            }
        }
    }

    public MusePoint2D getRadius() {
        return this.radius.copy();
    }

    @Override
    public boolean hitBox(double x, double y) {
        boolean hitx = Math.abs(this.position.getX() - x) < this.radius.getX();
        boolean hity = Math.abs(this.position.getY() - y) < this.radius.getY();
        return hitx && hity;
    }

    @Override
    public List<ITextComponent> getToolTip() {
        return null;
    }

    public void buttonOn() {
        this.setEnabled(true);
        this.setVisible(true);
    }

    public void buttonOff() {
        this.setEnabled(false);
        this.setVisible(false);
    }

    public ClickableButton setLable(ITextComponent label) {
        this.label = label;
        return this;
    }

    public ITextComponent getLabel() {
        return this.label;
    }
}

