/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.clickable;

import com.github.lehjr.numina.util.client.gui.clickable.IClickable;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.render.MuseRenderer;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.util.text.ITextComponent;

public class ClickableLabel
implements IClickable {
    protected IClickable.IPressable onPressed;
    protected IClickable.IReleasable onReleased;
    protected String label;
    protected MusePoint2D position;
    protected JustifyMode mode;
    boolean isEnabled = true;
    boolean isVisible = true;

    public ClickableLabel(String label, MusePoint2D position) {
        this.label = label;
        this.position = position;
        this.mode = JustifyMode.CENTERED;
    }

    public ClickableLabel(String label, MusePoint2D position, JustifyMode mode) {
        this.label = label;
        this.position = position;
        this.mode = mode;
    }

    public ClickableLabel setMode(JustifyMode mode) {
        this.mode = mode;
        return this;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks, float zLevel) {
        switch (this.mode) {
            case LEFT: {
                MuseRenderer.drawLeftAlignedStringString(matrixStack, this.label, this.position.getX(), this.position.getY() - 4.0);
                break;
            }
            case CENTERED: {
                MuseRenderer.drawCenteredString(matrixStack, this.label, this.position.getX(), this.position.getY() - 4.0);
                break;
            }
            case RIGHT: {
                MuseRenderer.drawRightAlignedString(matrixStack, this.label, this.position.getX(), this.position.getY() - 4.0);
            }
        }
    }

    @Override
    public boolean hitBox(double x, double y) {
        if (this.label == null || this.label.isEmpty()) {
            return false;
        }
        MusePoint2D radius = new MusePoint2D(MuseRenderer.getStringWidth(this.label) / 2.0 + 2.0, 6.0);
        boolean hitx = Math.abs(this.position.getX() - x) < radius.getX();
        boolean hity = Math.abs(this.position.getY() - y) < radius.getY();
        return hitx && hity;
    }

    @Override
    public List<ITextComponent> getToolTip() {
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void setOnPressed(IClickable.IPressable onPressed) {
        this.onPressed = onPressed;
    }

    @Override
    public void setOnReleased(IClickable.IReleasable onReleased) {
        this.onReleased = onReleased;
    }

    @Override
    public void onReleased() {
        if (this.isVisible && this.isEnabled && this.onReleased != null) {
            this.onReleased.onReleased(this);
        }
    }

    @Override
    public void onPressed() {
        if (this.isVisible && this.isEnabled && this.onPressed != null) {
            this.onPressed.onPressed(this);
        }
    }

    @Override
    public MusePoint2D getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(MusePoint2D position) {
        this.position.setX(position.getX());
        this.position.setY(position.getY());
    }

    public static enum JustifyMode {
        LEFT,
        CENTERED,
        RIGHT;

    }
}

