/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.clickable;

import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.client.gui.clickable.Clickable;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.render.MuseIconUtils;
import com.github.lehjr.numina.util.client.render.MuseRenderer;
import com.github.lehjr.numina.util.client.render.NuminaRenderState;
import com.github.lehjr.numina.util.math.Colour;
import com.github.lehjr.numina.util.string.MuseStringUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ClickableModule
extends Clickable {
    final Colour checkmarkcolour = new Colour(0.0f, 0.667f, 0.0f, 1.0f);
    boolean allowed = true;
    boolean installed = false;
    boolean isEnabled = true;
    boolean isVisible = true;
    ItemStack module;
    int inventorySlot;
    public final EnumModuleCategory category;
    public static final int offsetx = 8;
    public static final int offsety = 8;

    public ClickableModule(@Nonnull ItemStack module, MusePoint2D position, int inventorySlot, EnumModuleCategory category) {
        super(position);
        this.module = module;
        this.inventorySlot = inventorySlot;
        this.category = category;
        this.allowed = module.getCapability(PowerModuleCapability.POWER_MODULE).map(pm -> pm.isAllowed()).orElse(false);
    }

    public int getInventorySlot() {
        return this.inventorySlot;
    }

    @Override
    public List<ITextComponent> getToolTip() {
        ArrayList<ITextComponent> toolTipText = new ArrayList<ITextComponent>();
        toolTipText.add(this.getLocalizedName());
        toolTipText.addAll(MuseStringUtils.wrapITextComponentToLength(this.getLocalizedDescription(), 30));
        return toolTipText;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    public ITextComponent getLocalizedName() {
        if (this.getModule().func_190926_b()) {
            return null;
        }
        return this.getModule().func_200301_q();
    }

    public ITextComponent getLocalizedDescription() {
        if (this.getModule().func_190926_b()) {
            return null;
        }
        return new TranslationTextComponent(this.getModule().func_77977_a().concat(".desc"));
    }

    @Override
    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks, float zLevel) {
        if (!this.getModule().func_190926_b()) {
            MuseRenderer.drawModuleAt(matrixStack, this.getPosition().getX() - 8.0, this.getPosition().getY() - 8.0, this.getModule(), true);
            if (!this.allowed) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(0.0, 0.0, 250.0);
                NuminaRenderState.glowOn();
                String string = MuseStringUtils.wrapMultipleFormatTags("X", new Object[]{MuseStringUtils.FormatCodes.Bold, MuseStringUtils.FormatCodes.DarkRed});
                MuseRenderer.drawString(matrixStack, string, this.getPosition().getX() + 3.0, this.getPosition().getY() + 1.0);
                NuminaRenderState.glowOff();
                matrixStack.func_227865_b_();
            } else if (this.installed) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(0.0, 0.0, 250.0);
                NuminaRenderState.glowOn();
                MuseIconUtils.getIcon().checkmark.draw(matrixStack, this.getPosition().getX() - 8.0 + 1.0, this.getPosition().getY() - 8.0 + 1.0, this.checkmarkcolour.withAlpha(0.6f));
                NuminaRenderState.glowOff();
                matrixStack.func_227865_b_();
            }
        }
    }

    @Override
    public boolean hitBox(double x, double y) {
        boolean hitx = Math.abs(x - this.getPosition().getX()) < 8.0;
        boolean hity = Math.abs(y - this.getPosition().getY()) < 8.0;
        return hitx && hity;
    }

    @Nonnull
    public ItemStack getModule() {
        return this.module;
    }

    public boolean equals(ClickableModule other) {
        return this.module == other.getModule();
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public boolean isInstalled() {
        return this.installed;
    }
}

