/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.clickable;

import com.github.lehjr.numina.util.client.gui.clickable.Clickable;
import com.github.lehjr.numina.util.client.gui.gemoetry.DrawableMuseRect;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.render.MuseRenderer;
import com.github.lehjr.numina.util.math.Colour;
import com.github.lehjr.numina.util.math.MuseMathUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.util.text.ITextComponent;

public class ClickableSlider
extends Clickable {
    final int cornersize = 3;
    private double valueInternal = 0.0;
    MusePoint2D pos;
    double width;
    private String id;
    private ITextComponent label;
    DrawableMuseRect insideRect;
    DrawableMuseRect outsideRect;
    boolean isEnabled = true;
    boolean isVisible = true;

    public ClickableSlider(MusePoint2D pos, double width, String id, ITextComponent label) {
        this.pos = pos;
        this.width = width;
        this.id = id;
        this.position = pos;
        this.insideRect = new DrawableMuseRect(this.position.getX() - width / 2.0 - 3.0, this.position.getY() + 8.0, 0.0, this.position.getY() + 16.0, Colour.ORANGE, Colour.LIGHT_BLUE);
        this.outsideRect = new DrawableMuseRect(this.position.getX() - width / 2.0 - 3.0, this.position.getY() + 8.0, this.position.getX() + width / 2.0 + 3.0, this.position.getY() + 16.0, Colour.DARKBLUE, Colour.LIGHT_BLUE);
        this.label = label;
    }

    public String id() {
        return this.id;
    }

    public void setLabel(ITextComponent label) {
        this.label = label;
    }

    @Override
    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks, float zLevel) {
        MuseRenderer.drawCenteredText(matrixStack, this.label, (float)this.position.getX(), (float)this.position.getY(), Colour.WHITE);
        this.insideRect.setRight(this.position.getX() + this.width * (double)((float)this.getValue() - 0.5f) + 3.0);
        this.outsideRect.draw(matrixStack, zLevel);
        this.insideRect.draw(matrixStack, zLevel);
    }

    @Override
    public boolean hitBox(double x, double y) {
        return Math.abs(this.position.getX() - x) < this.width / 2.0 && Math.abs(this.position.getY() + 12.0 - y) < 4.0;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void onPressed() {
    }

    public double getValue() {
        return this.valueInternal;
    }

    public void setValue(double v) {
        this.valueInternal = v;
    }

    public void setValueByX(double x) {
        this.valueInternal = MuseMathUtils.clampDouble((x - this.pos.getX()) / this.width + 0.5, 0.0, 1.0);
    }
}

