/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.clickable;

import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IClickable {
    public void render(MatrixStack var1, int var2, int var3, float var4, float var5);

    default public void move(double x, double y) {
        this.move(new MusePoint2D(x, y));
    }

    default public void move(MusePoint2D position) {
        this.setPosition(this.getPosition().plus(position));
    }

    public MusePoint2D getPosition();

    public void setPosition(MusePoint2D var1);

    public boolean hitBox(double var1, double var3);

    public List<ITextComponent> getToolTip();

    public void setEnabled(boolean var1);

    public boolean isEnabled();

    public void setVisible(boolean var1);

    public boolean isVisible();

    default public void hide() {
        this.setVisible(false);
    }

    default public void show() {
        this.setVisible(true);
    }

    default public void enable() {
        this.setEnabled(true);
    }

    default public void disable() {
        this.setEnabled(false);
    }

    default public void enableAndShow() {
        this.enable();
        this.show();
    }

    default public void disableAndHide() {
        this.disable();
        this.hide();
    }

    default public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.hitBox(mouseX, mouseY) && this.isEnabled() && this.isVisible()) {
            InputMappings.Input mouseKey = InputMappings.Type.MOUSE.func_197944_a(button);
            boolean flag = Minecraft.func_71410_x().field_71474_y.field_74322_I.isActiveAndMatches(mouseKey);
            if (button == 0 || button == 1 || flag) {
                this.onPressed();
            }
            return true;
        }
        return false;
    }

    default public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return false;
    }

    public void setOnPressed(IPressable var1);

    public void setOnReleased(IReleasable var1);

    public void onPressed();

    public void onReleased();

    @OnlyIn(value=Dist.CLIENT)
    public static interface IReleasable {
        public void onReleased(IClickable var1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface IPressable {
        public void onPressed(IClickable var1);
    }
}

