/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.clickable;

import com.github.lehjr.numina.util.client.gui.clickable.Clickable;
import com.github.lehjr.numina.util.client.gui.gemoetry.DrawableMuseRect;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.render.MuseRenderer;
import com.github.lehjr.numina.util.math.Colour;
import com.github.lehjr.numina.util.math.MuseMathUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;

public class RangedSlider
extends Clickable {
    final int cornersize = 3;
    private final double height = 16.0;
    protected double width;
    private String label;
    DrawableMuseRect insideRect;
    DrawableMuseRect outsideRect;
    public boolean dragging = false;
    public double sliderValue = 1.0;
    public double minValue = 0.0;
    public double maxValue = 5.0;
    @Nullable
    public ISlider parent = null;

    public RangedSlider(MusePoint2D position, double width, String label, double minVal, double maxVal, double currentVal) {
        this(position, width, label, minVal, maxVal, currentVal, null);
    }

    public RangedSlider(MusePoint2D position, String label, double minVal, double maxVal, double currentVal, ISlider par) {
        this(position, 150.0, label, minVal, maxVal, currentVal, par);
    }

    public RangedSlider(MusePoint2D position, double width, String label, double minVal, double maxVal, double currentVal, @Nullable ISlider iSlider) {
        this.width = width;
        this.position = position;
        this.label = label;
        this.createNewRects();
        this.minValue = minVal;
        this.maxValue = maxVal;
        this.sliderValue = (currentVal - this.minValue) / (this.maxValue - this.minValue);
        this.parent = iSlider;
    }

    void createNewRects() {
        this.insideRect = new DrawableMuseRect(this.position.getX() - this.width / 2.0 - 3.0, this.position.getY() + 8.0, 0.0, this.position.getY() + 16.0, Colour.ORANGE, Colour.LIGHT_BLUE);
        this.outsideRect = new DrawableMuseRect(this.position.getX() - this.width / 2.0 - 3.0, this.position.getY() + 8.0, this.position.getX() + this.width / 2.0 + 3.0, this.position.getY() + 16.0, Colour.DARKBLUE, Colour.LIGHT_BLUE);
        this.insideRect.setWidth(6.0);
    }

    @Override
    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks, float zLevel) {
        if (this.isVisible) {
            if (this.label != null) {
                MuseRenderer.drawCenteredString(matrixStack, I18n.func_135052_a((String)this.label, (Object[])new Object[0]), this.position.getX(), this.position.getY());
            }
            this.outsideRect.draw(matrixStack, zLevel);
            this.insideRect.setPosition(new MusePoint2D(this.position.getX() + this.width * (this.sliderValue - 0.5), this.outsideRect.centery()));
            this.insideRect.draw(matrixStack, zLevel);
        }
    }

    public void update(double mouseX, double mouseY) {
        double siderStart = this.sliderValue;
        this.sliderValue = this.dragging && this.isEnabled() && this.isVisible() && this.hitBox(mouseX, mouseY) ? MuseMathUtils.clampDouble((mouseX - this.position.getX()) / (this.width - 3.0) + 0.5, 0.0, 1.0) : MuseMathUtils.clampDouble(this.sliderValue, 0.0, 1.0);
        if (siderStart != this.sliderValue && this.parent != null) {
            this.parent.onChangeSliderValue(this);
        }
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void setPosition(MusePoint2D position) {
        super.setPosition(position);
        this.createNewRects();
    }

    public void setWidth(double widthIn) {
        this.width = widthIn;
        this.createNewRects();
    }

    public int getValueInt() {
        return (int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
    }

    public double getValue() {
        return this.sliderValue * (this.maxValue - this.minValue) + this.minValue;
    }

    public void setValue(double d) {
        this.sliderValue = (d - this.minValue) / (this.maxValue - this.minValue);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.update(mouseX, mouseY);
        this.dragging = false;
        return false;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isEnabled() && this.isVisible() && this.hitBox(mouseX, mouseY)) {
            this.update(mouseX, mouseY);
            this.dragging = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean hitBox(double x, double y) {
        return Math.abs(this.position.getX() - x) < this.width / 2.0 && Math.abs(this.position.getY() + 12.0 - y) < 4.0;
    }

    public static interface ISlider {
        public void onChangeSliderValue(RangedSlider var1);
    }
}

