/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.clickable;

import com.github.lehjr.numina.util.client.gui.GuiIcon;
import com.github.lehjr.numina.util.client.gui.clickable.Button;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.gui.gemoetry.MuseRect;
import com.github.lehjr.numina.util.math.Colour;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.util.ResourceLocation;

public class TexturedButton
extends Button {
    ResourceLocation textureLocation;
    double texStartX;
    double texStartY;
    double textureWidth;
    double textureHeight;
    double iconWidth;
    double iconHeight;

    public TexturedButton(double left, double top, double right, double bottom, boolean growFromMiddle, Colour backgroundColourEnabled, Colour backgroundColourDisabled, Colour borderColourEnabled, Colour borderColourDisabled, double textureWidth, double textureHeight, ResourceLocation textureLocation) {
        super(left, top, right, bottom, growFromMiddle, backgroundColourEnabled, backgroundColourDisabled, borderColourEnabled, borderColourDisabled);
        this.textureWidth = this.iconWidth = textureWidth;
        this.textureHeight = this.iconHeight = textureHeight;
        this.textureLocation = textureLocation;
        this.texStartX = 0.0;
        this.texStartY = 0.0;
    }

    public TexturedButton(double left, double top, double right, double bottom, Colour backgroundColourEnabled, Colour backgroundColourDisabled, Colour borderColourEnabled, Colour borderColourDisabled, double textureWidth, double textureHeight, ResourceLocation textureLocation) {
        super(left, top, right, bottom, backgroundColourEnabled, backgroundColourDisabled, borderColourEnabled, borderColourDisabled);
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.textureLocation = textureLocation;
        this.texStartX = 0.0;
        this.texStartY = 0.0;
    }

    public TexturedButton(MusePoint2D ul, MusePoint2D br, Colour backgroundColourEnabled, Colour backgroundColourDisabled, Colour borderColourEnabled, Colour borderColourDisabled, double textureWidth, double textureHeight, ResourceLocation textureLocation) {
        super(ul, br, backgroundColourEnabled, backgroundColourDisabled, borderColourEnabled, borderColourDisabled);
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.textureLocation = textureLocation;
        this.texStartX = 0.0;
        this.texStartY = 0.0;
    }

    public TexturedButton(MuseRect ref, Colour backgroundColourEnabled, Colour backgroundColourDisabled, Colour borderColourEnabled, Colour borderColourDisabled, double textureWidth, double textureHeight, ResourceLocation textureLocation) {
        super(ref, backgroundColourEnabled, backgroundColourDisabled, borderColourEnabled, borderColourDisabled);
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.textureLocation = textureLocation;
        this.texStartX = 0.0;
        this.texStartY = 0.0;
    }

    public TexturedButton setTextureStartX(double xOffset) {
        this.texStartX = xOffset;
        return this;
    }

    public TexturedButton setTextureStartY(double yOffset) {
        this.texStartY = yOffset;
        return this;
    }

    public TexturedButton setIconWidth(double iconWidth) {
        this.iconWidth = iconWidth;
        return this;
    }

    public TexturedButton setIconHeight(double iconHeight) {
        this.iconHeight = iconHeight;
        return this;
    }

    @Override
    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks, float zLevel) {
        super.render(matrixStack, mouseX, mouseY, partialTicks, zLevel);
        Colour color = this.isVisible && this.isEnabled ? (this.hitBox(mouseX, mouseY) ? Colour.LIGHT_BLUE.withAlpha(0.6f) : Colour.WHITE) : Colour.RED.withAlpha(0.6f);
        GuiIcon.renderTextureWithColour(this.textureLocation, matrixStack, this.left(), this.right(), this.top(), this.bottom(), zLevel, this.iconWidth, this.iconHeight, this.texStartX, this.texStartY, this.textureWidth, this.textureHeight, color);
    }
}

