/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.frame;

import com.github.lehjr.numina.util.client.gui.frame.ScrollableFrame;
import com.github.lehjr.numina.util.client.gui.gemoetry.DrawableTile;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.gui.slot.IHideableSlot;
import com.github.lehjr.numina.util.client.gui.slot.UniversalSlot;
import com.github.lehjr.numina.util.math.Colour;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.text.ITextComponent;
import org.lwjgl.BufferUtils;

public class InventoryFrame
extends ScrollableFrame {
    Container container;
    Colour backgroundColour;
    Colour gridColour;
    public final int gridWidth;
    public final int gridHeight;
    List<Integer> slotIndexes;
    List<DrawableTile> tiles;
    MusePoint2D slot_ulShift = new MusePoint2D(0.0, 0.0);
    boolean drawBackground = false;
    boolean drawBorder = false;

    public InventoryFrame(Container containerIn, MusePoint2D topleft, MusePoint2D bottomright, float zLevel, Colour backgroundColour, Colour borderColour, Colour gridColourIn, int gridWidth, int gridHeight, List<Integer> slotIndexesIn) {
        super(topleft, bottomright, zLevel, backgroundColour, borderColour);
        this.container = containerIn;
        this.backgroundColour = backgroundColour;
        this.gridColour = gridColourIn;
        this.gridWidth = gridWidth;
        this.gridHeight = gridHeight;
        this.slotIndexes = slotIndexesIn;
        this.tiles = new ArrayList<DrawableTile>();
    }

    public void setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
    }

    public void setDrawBorder(boolean drawBorder) {
        this.drawBorder = drawBorder;
    }

    public void loadSlots() {
        MusePoint2D wh = new MusePoint2D(18.0, 18.0);
        MusePoint2D ul = new MusePoint2D(this.border.left(), this.border.top());
        this.tiles = new ArrayList<DrawableTile>();
        int i = 0;
        block0: for (int row = 0; row < this.gridHeight; ++row) {
            for (int col = 0; col < this.gridWidth; ++col) {
                if (i == this.slotIndexes.size()) break block0;
                this.tiles.add(new DrawableTile(ul, ul.plus(wh)).setBorderShrinkValue(0.5f));
                if (i > 0) {
                    if (col > 0) {
                        this.tiles.get(i).setMeRightOf(this.tiles.get(i - 1));
                    }
                    if (row > 0) {
                        this.tiles.get(i).setMeBelow(this.tiles.get(i - this.gridWidth));
                    }
                }
                MusePoint2D position = this.tiles.get(i).center().copy().minus(this.slot_ulShift);
                Slot slot = this.container.func_75139_a(this.slotIndexes.get(i).intValue());
                if (slot instanceof UniversalSlot) {
                    ((UniversalSlot)slot).setPosition(position);
                } else if (slot instanceof IHideableSlot) {
                    ((IHideableSlot)slot).setPosition(position);
                } else {
                    slot.field_75223_e = (int)position.getX();
                    slot.field_75221_f = (int)position.getY();
                }
                ++i;
            }
        }
    }

    @Override
    public boolean mouseClicked(double v, double v1, int i) {
        return false;
    }

    @Override
    public boolean mouseReleased(double v, double v1, int i) {
        return false;
    }

    @Override
    public boolean mouseScrolled(double v, double v1, double v2) {
        return false;
    }

    public MusePoint2D getUlShift() {
        return this.slot_ulShift;
    }

    public void setUlShift(MusePoint2D ulShift) {
        this.slot_ulShift = ulShift;
    }

    @Override
    public void init(double left, double top, double right, double bottom) {
        super.init(left, top, right, bottom);
        this.loadSlots();
    }

    @Override
    public void update(double mouseX, double mouseY) {
        this.loadSlots();
    }

    @Override
    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)0);
        if (this.drawBorder || this.drawBackground) {
            buffer = this.border.preDraw(3.0);
            this.border.setzLevel(this.zLevel);
        }
        if (this.drawBackground) {
            this.border.drawBackground(matrixStack, buffer);
        }
        if (this.tiles != null && !this.tiles.isEmpty()) {
            for (DrawableTile tile : this.tiles) {
                tile.draw(matrixStack, this.zLevel);
            }
        }
        if (this.drawBorder) {
            this.border.drawBorder(matrixStack, buffer);
        }
    }

    @Override
    public List<ITextComponent> getToolTip(int i, int i1) {
        return null;
    }
}

