/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.frame;

import com.github.lehjr.numina.util.client.gui.frame.IGuiFrame;
import com.github.lehjr.numina.util.client.gui.gemoetry.DrawableMuseRect;
import com.github.lehjr.numina.util.client.gui.gemoetry.IRect;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.render.NuminaRenderState;
import com.github.lehjr.numina.util.math.Colour;
import com.github.lehjr.numina.util.math.MuseMathUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;

public class ScrollableFrame
implements IGuiFrame {
    protected final int buttonsize = 5;
    protected int totalsize;
    protected int currentscrollpixels;
    protected boolean visible = true;
    protected boolean enabled = true;
    protected float zLevel;
    protected DrawableMuseRect border;

    public ScrollableFrame(MusePoint2D topleft, MusePoint2D bottomright, float zlevel, Colour backgroundColour, Colour borderColour) {
        this.border = new DrawableMuseRect(topleft, bottomright, backgroundColour, borderColour);
        this.zLevel = zlevel;
    }

    public float getzLevel() {
        return this.zLevel;
    }

    public void setzLevel(float zLevelIn) {
        this.zLevel = zLevelIn;
    }

    @Override
    public IRect getBorder() {
        return this.border;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible()) {
            this.preRender(matrixStack, mouseX, mouseY, partialTicks);
            this.postRender(mouseX, mouseY, partialTicks);
        }
    }

    public void preRender(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible()) {
            this.border.draw(matrixStack, this.zLevel);
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.disableAlphaTest();
            RenderSystem.defaultBlendFunc();
            RenderSystem.shadeModel((int)7425);
            NuminaRenderState.glowOn();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(4, DefaultVertexFormats.field_227850_m_);
            Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
            if ((double)this.currentscrollpixels + this.border.height() < (double)this.totalsize) {
                buffer.func_227888_a_(matrix4f, (float)(this.border.left() + this.border.width() / 2.0), (float)this.border.bottom(), this.zLevel).func_227885_a_(Colour.LIGHT_BLUE.r, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.a).func_227886_a_(0xF000F0).func_181675_d();
                buffer.func_227888_a_(matrix4f, (float)(this.border.left() + this.border.width() / 2.0 + 2.0), (float)this.border.bottom() - 4.0f, this.zLevel).func_227885_a_(Colour.LIGHT_BLUE.r, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.a).func_227886_a_(0xF000F0).func_181675_d();
                buffer.func_227888_a_(matrix4f, (float)(this.border.left() + this.border.width() / 2.0 - 2.0), (float)this.border.bottom() - 4.0f, this.zLevel).func_227885_a_(Colour.LIGHT_BLUE.r, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.a).func_227886_a_(0xF000F0).func_181675_d();
            }
            if (this.currentscrollpixels > 0) {
                buffer.func_227888_a_(matrix4f, (float)(this.border.left() + this.border.width() / 2.0), (float)this.border.top(), this.zLevel).func_227885_a_(Colour.LIGHT_BLUE.r, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.a).func_227886_a_(0xF000F0).func_181675_d();
                buffer.func_227888_a_(matrix4f, (float)(this.border.left() + this.border.width() / 2.0 - 2.0), (float)this.border.top() + 4.0f, this.zLevel).func_227885_a_(Colour.LIGHT_BLUE.r, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.a).func_227886_a_(0xF000F0).func_181675_d();
                buffer.func_227888_a_(matrix4f, (float)(this.border.left() + this.border.width() / 2.0 + 2.0), (float)this.border.top() + 4.0f, this.zLevel).func_227885_a_(Colour.LIGHT_BLUE.r, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.a).func_227886_a_(0xF000F0).func_181675_d();
            }
            tessellator.func_78381_a();
            RenderSystem.shadeModel((int)7424);
            RenderSystem.disableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableTexture();
            NuminaRenderState.scissorsOn(this.border.left(), this.border.top() + 4.0, this.border.width(), this.border.height() - 8.0);
        }
    }

    public void postRender(int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible()) {
            NuminaRenderState.scissorsOff();
            NuminaRenderState.glowOff();
        }
    }

    public int getMaxScrollPixels() {
        return (int)Math.max((double)this.totalsize - this.border.height(), 0.0);
    }

    protected double getScrollAmount() {
        return 8.0;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double dWheel) {
        if (this.border.containsPoint(mouseX, mouseY)) {
            this.currentscrollpixels = (int)((double)this.currentscrollpixels - dWheel * this.getScrollAmount());
            this.currentscrollpixels = (int)MuseMathUtils.clampDouble(this.currentscrollpixels, 0.0, this.getMaxScrollPixels());
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        if (this.isVisible() && this.getBorder().containsPoint(x, y) && button == 0) {
            int dscroll = 0;
            if (y - this.border.top() < 5.0 && this.currentscrollpixels > 0) {
                dscroll = (int)((double)dscroll - this.getScrollAmount());
            } else if (this.border.bottom() - y < 5.0) {
                dscroll = (int)((double)dscroll + this.getScrollAmount());
            }
            if (dscroll != 0) {
                this.currentscrollpixels = (int)MuseMathUtils.clampDouble(this.currentscrollpixels + dscroll, 0.0, this.getMaxScrollPixels());
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double x, double y, int button) {
        return false;
    }

    @Override
    public void update(double mouseX, double mouseY) {
    }

    @Override
    public List<ITextComponent> getToolTip(int x, int y) {
        return null;
    }
}

