/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.gemoetry;

import com.github.lehjr.numina.util.client.gui.gemoetry.GradientAndArcCalculator;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.gui.gemoetry.MuseRelativeRect;
import com.github.lehjr.numina.util.math.Colour;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.FloatBuffer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;
import org.lwjgl.BufferUtils;

public class DrawableArrow
extends MuseRelativeRect {
    Colour backgroundColour;
    Colour borderColour;
    boolean drawShaft = true;
    ArrowDirection facing = ArrowDirection.RIGHT;
    boolean shrinkBorder = true;
    float zLevel;

    public DrawableArrow(float left, float top, float right, float bottom, boolean growFromMiddle, Colour backgroundColour, Colour borderColour) {
        super(left, top, right, bottom, growFromMiddle);
        this.backgroundColour = backgroundColour;
        this.borderColour = borderColour;
    }

    public DrawableArrow(float left, float top, float right, float bottom, Colour backgroundColour, Colour borderColour) {
        super(left, top, right, bottom, false);
        this.backgroundColour = backgroundColour;
        this.borderColour = borderColour;
    }

    public DrawableArrow(MusePoint2D ul, MusePoint2D br, Colour backgroundColour, Colour borderColour) {
        super(ul, br);
        this.backgroundColour = backgroundColour;
        this.borderColour = borderColour;
    }

    public DrawableArrow(MuseRelativeRect ref, Colour backgroundColour, Colour borderColour) {
        super(ref.left(), ref.top(), ref.right(), ref.bottom(), ref.growFromMiddle());
        this.backgroundColour = backgroundColour;
        this.borderColour = borderColour;
    }

    public void setShrinkBorder(boolean shrinkBorder) {
        this.shrinkBorder = shrinkBorder;
    }

    public void setBackgroundColour(Colour colour) {
        this.backgroundColour = colour;
    }

    public void setDirection(ArrowDirection facing) {
        this.facing = facing;
    }

    public void setDrawShaft(boolean drawShaft) {
        this.drawShaft = drawShaft;
    }

    FloatBuffer arrowHeadVertices(float shrinkBy) {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)6);
        switch (this.facing) {
            case RIGHT: {
                buffer.put((float)((this.drawShaft ? this.centerx() + this.width() * (double)0.15f : this.left()) + (double)shrinkBy));
                buffer.put((float)(this.centery() - this.height() * (double)0.4f + (double)shrinkBy));
                buffer.put((float)(this.right() - (double)shrinkBy));
                buffer.put((float)this.centery());
                buffer.put((float)((this.drawShaft ? this.centerx() + this.width() * (double)0.15f : this.left()) + (double)shrinkBy));
                buffer.put((float)(this.centery() + this.height() * (double)0.4f - (double)shrinkBy));
                break;
            }
            case DOWN: {
                buffer.put((float)(this.centerx() + this.width() * (double)0.4f - (double)shrinkBy));
                buffer.put((float)((this.drawShaft ? this.centery() + this.height() * (double)0.15f : this.top()) + (double)shrinkBy));
                buffer.put((float)this.centerx());
                buffer.put((float)(this.bottom() - (double)shrinkBy));
                buffer.put((float)(this.centerx() - this.width() * (double)0.4f + (double)shrinkBy));
                buffer.put((float)((this.drawShaft ? this.centery() + this.height() * (double)0.15f : this.top()) + (double)shrinkBy));
                break;
            }
            case LEFT: {
                buffer.put((float)((this.drawShaft ? (double)((float)(this.centerx() - this.width() * 0.15)) : this.right()) + (double)shrinkBy));
                buffer.put((float)(this.centery() + this.height() * (double)0.4f - (double)shrinkBy));
                buffer.put((float)(this.left() - (double)shrinkBy));
                buffer.put((float)this.centery());
                buffer.put((float)((this.drawShaft ? (double)((float)(this.centerx() - this.width() * 0.15)) : this.right()) + (double)shrinkBy));
                buffer.put((float)(this.centery() - this.height() * (double)0.4f + (double)shrinkBy));
                break;
            }
            case UP: {
                buffer.put((float)(this.centerx() - this.width() * (double)0.4f + (double)shrinkBy));
                buffer.put((float)((this.drawShaft ? this.centery() - this.height() * (double)0.15f : this.bottom()) - (double)shrinkBy));
                buffer.put((float)this.centerx());
                buffer.put((float)(this.top() + (double)shrinkBy));
                buffer.put((float)(this.centerx() + this.width() * (double)0.4f - (double)shrinkBy));
                buffer.put((float)((this.drawShaft ? this.centery() - this.height() * (double)0.15f : this.bottom()) - (double)shrinkBy));
            }
        }
        buffer.flip();
        return buffer;
    }

    FloatBuffer arrowShaftVerticesPt1(float shrinkBy) {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)4);
        switch (this.facing) {
            case RIGHT: {
                buffer.put((float)(this.left() + (double)shrinkBy));
                buffer.put((float)(this.centery() - this.height() * (double)0.15f + (double)shrinkBy));
                buffer.put((float)(this.centerx() + this.width() * (double)0.15f + (double)shrinkBy));
                buffer.put((float)(this.centery() - this.height() * (double)0.15f + (double)shrinkBy));
                break;
            }
            case DOWN: {
                buffer.put((float)(this.centerx() + this.width() * (double)0.15f - (double)shrinkBy));
                buffer.put((float)(this.top() + (double)shrinkBy));
                buffer.put((float)(this.centerx() + this.width() * (double)0.15f - (double)shrinkBy));
                buffer.put((float)(this.centery() + this.height() * (double)0.15f + (double)shrinkBy));
                break;
            }
            case LEFT: {
                buffer.put((float)(this.right() - (double)shrinkBy));
                buffer.put((float)(this.centery() + this.height() * (double)0.15f - (double)shrinkBy));
                buffer.put((float)(this.centerx() - this.width() * (double)0.15f + (double)shrinkBy));
                buffer.put((float)(this.centery() + this.height() * (double)0.15f - (double)shrinkBy));
                break;
            }
            case UP: {
                buffer.put((float)(this.centerx() - this.width() * (double)0.15f + (double)shrinkBy));
                buffer.put((float)(this.bottom() - (double)shrinkBy));
                buffer.put((float)(this.centerx() - this.width() * (double)0.15f + (double)shrinkBy));
                buffer.put((float)(this.centery() - this.height() * (double)0.15f - (double)shrinkBy));
            }
        }
        buffer.flip();
        return buffer;
    }

    FloatBuffer arrowShaftVerticesPt2(float shrinkBy) {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)4);
        switch (this.facing) {
            case RIGHT: {
                buffer.put((float)(this.centerx() + this.width() * (double)0.15f + (double)shrinkBy));
                buffer.put((float)(this.centery() + this.height() * (double)0.15f - (double)shrinkBy));
                buffer.put((float)(this.left() + (double)shrinkBy));
                buffer.put((float)(this.centery() + this.height() * (double)0.15f - (double)shrinkBy));
                break;
            }
            case DOWN: {
                buffer.put((float)(this.centerx() - this.width() * (double)0.15f + (double)shrinkBy));
                buffer.put((float)(this.centery() + this.height() * (double)0.15f + (double)shrinkBy));
                buffer.put((float)(this.centerx() - this.width() * (double)0.15f + (double)shrinkBy));
                buffer.put((float)(this.top() + (double)shrinkBy));
                break;
            }
            case LEFT: {
                buffer.put((float)(this.centerx() - this.width() * (double)0.15f + (double)shrinkBy));
                buffer.put((float)(this.centery() - this.height() * (double)0.15f + (double)shrinkBy));
                buffer.put((float)(this.right() - (double)shrinkBy));
                buffer.put((float)(this.centery() - this.height() * (double)0.15f + (double)shrinkBy));
                break;
            }
            case UP: {
                buffer.put((float)(this.centerx() + this.width() * (double)0.15f - (double)shrinkBy));
                buffer.put((float)(this.centery() - this.height() * (double)0.15f - (double)shrinkBy));
                buffer.put((float)(this.centerx() + this.width() * (double)0.15f - (double)shrinkBy));
                buffer.put((float)(this.bottom() - (double)shrinkBy));
            }
        }
        buffer.flip();
        return buffer;
    }

    void drawBackground(MatrixStack matrixStack) {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(9, DefaultVertexFormats.field_181706_f);
        FloatBuffer vertices = this.arrowHeadVertices(0.0f);
        while (vertices.hasRemaining()) {
            buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), vertices.get(), vertices.get(), this.zLevel).func_227885_a_(this.backgroundColour.r, this.backgroundColour.g, this.backgroundColour.b, this.backgroundColour.a).func_181675_d();
        }
        tessellator.func_78381_a();
        if (this.drawShaft) {
            buffer.func_181668_a(9, DefaultVertexFormats.field_181706_f);
            vertices = this.arrowShaftVerticesPt1(0.0f);
            while (vertices.hasRemaining()) {
                buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), vertices.get(), vertices.get(), this.zLevel).func_227885_a_(this.backgroundColour.r, this.backgroundColour.g, this.backgroundColour.b, this.backgroundColour.a).func_181675_d();
            }
            vertices = this.arrowShaftVerticesPt2(0.0f);
            while (vertices.hasRemaining()) {
                buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), vertices.get(), vertices.get(), this.zLevel).func_227885_a_(this.backgroundColour.r, this.backgroundColour.g, this.backgroundColour.b, this.backgroundColour.a).func_181675_d();
            }
            tessellator.func_78381_a();
        }
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    void drawBorder(MatrixStack matrixStack) {
        FloatBuffer vertices = BufferUtils.createFloatBuffer((int)(6 + (this.drawShaft ? 8 : 0)));
        if (this.drawShaft) {
            vertices.put(this.arrowShaftVerticesPt1(this.shrinkBorder ? 1.0f : 0.0f));
        }
        vertices.put(this.arrowHeadVertices(this.shrinkBorder ? 1.0f : 0.0f));
        if (this.drawShaft) {
            vertices.put(this.arrowShaftVerticesPt2(this.shrinkBorder ? 1.0f : 0.0f));
        }
        vertices.rewind();
        FloatBuffer borderColours = GradientAndArcCalculator.getColourGradient(this.borderColour, this.borderColour.withAlpha(1.0f), vertices.limit());
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        while (vertices.hasRemaining() && borderColours.hasRemaining()) {
            buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), vertices.get(), vertices.get(), this.zLevel).func_227885_a_(borderColours.get(), borderColours.get(), borderColours.get(), borderColours.get()).func_181675_d();
        }
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public void draw(MatrixStack matrixStack, float zLevel) {
        this.zLevel = zLevel;
        this.drawBackground(matrixStack);
        this.drawBorder(matrixStack);
    }

    public ArrowDirection getFacing(Matrix4f matrix4f) {
        return this.facing;
    }

    public static enum ArrowDirection {
        UP(270),
        DOWN(90),
        LEFT(180),
        RIGHT(0);

        int rotation;

        private ArrowDirection(int rotation) {
            this.rotation = rotation;
        }

        public int getRotation() {
            return this.rotation;
        }
    }
}

