/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.gemoetry;

import com.github.lehjr.numina.util.client.gui.gemoetry.GradientAndArcCalculator;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.gui.gemoetry.MuseRect;
import com.github.lehjr.numina.util.math.Colour;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.FloatBuffer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.BufferUtils;

public class DrawableMuseRect
extends MuseRect {
    Colour backgroundColour;
    Colour borderColour;
    Colour backgroundColour2 = null;
    double cornerradius = 3.0;
    float zLevel = 1.0f;
    boolean shrinkBorder = true;

    public DrawableMuseRect(double left, double top, double right, double bottom, boolean growFromMiddle, Colour backgroundColour, Colour borderColour) {
        super(left, top, right, bottom, growFromMiddle);
        this.backgroundColour = backgroundColour;
        this.borderColour = borderColour;
    }

    public DrawableMuseRect(double left, double top, double right, double bottom, Colour backgroundColour, Colour borderColour) {
        super(left, top, right, bottom, false);
        this.backgroundColour = backgroundColour;
        this.borderColour = borderColour;
    }

    public DrawableMuseRect(MusePoint2D ul, MusePoint2D br, Colour backgroundColour, Colour borderColour) {
        super(ul, br);
        this.backgroundColour = backgroundColour;
        this.borderColour = borderColour;
    }

    public DrawableMuseRect(MuseRect ref, Colour backgroundColour, Colour borderColour) {
        super(ref.left(), ref.top(), ref.right(), ref.bottom(), ref.growFromMiddle());
        this.backgroundColour = backgroundColour;
        this.borderColour = borderColour;
    }

    public DrawableMuseRect setSecondBackgroundColour(Colour backgroundColour2In) {
        this.backgroundColour2 = backgroundColour2In;
        return this;
    }

    public void setShrinkBorder(boolean shrinkBorder) {
        this.shrinkBorder = shrinkBorder;
    }

    @Override
    public DrawableMuseRect copyOf() {
        return new DrawableMuseRect(super.left(), super.top(), super.right(), super.bottom(), this.ul != this.ulFinal || this.wh != this.whFinal, this.backgroundColour, this.borderColour).setBackgroundColour(this.backgroundColour2);
    }

    @Override
    public DrawableMuseRect setLeft(double value) {
        super.setLeft(value);
        return this;
    }

    @Override
    public DrawableMuseRect setRight(double value) {
        super.setRight(value);
        return this;
    }

    @Override
    public DrawableMuseRect setTop(double value) {
        super.setTop(value);
        return this;
    }

    @Override
    public DrawableMuseRect setBottom(double value) {
        super.setBottom(value);
        return this;
    }

    @Override
    public DrawableMuseRect setWidth(double value) {
        super.setWidth(value);
        return this;
    }

    @Override
    public DrawableMuseRect setHeight(double value) {
        super.setHeight(value);
        return this;
    }

    public DrawableMuseRect setBackgroundColour(Colour backgroundColour) {
        this.backgroundColour = backgroundColour;
        return this;
    }

    public DrawableMuseRect setBorderColour(Colour borderColour) {
        this.borderColour = borderColour;
        return this;
    }

    public double getCornerradius() {
        return this.cornerradius;
    }

    public FloatBuffer preDraw(double shrinkBy) {
        return this.preDraw(this.left() + shrinkBy, this.top() + shrinkBy, this.right() - shrinkBy, this.bottom() - shrinkBy);
    }

    public FloatBuffer preDraw(double left, double top, double right, double bottom) {
        FloatBuffer corner = GradientAndArcCalculator.getArcPoints((float)Math.PI, 4.712389f, (float)this.getCornerradius(), (float)(left + this.getCornerradius()), (float)(top + this.getCornerradius()));
        FloatBuffer vertices = BufferUtils.createFloatBuffer((int)(corner.limit() * 4));
        vertices.put(corner);
        corner = GradientAndArcCalculator.getArcPoints(4.712389f, (float)Math.PI * 2, (float)this.getCornerradius(), (float)(left + this.getCornerradius()), (float)(bottom - this.getCornerradius()));
        vertices.put(corner);
        corner = GradientAndArcCalculator.getArcPoints(0.0f, 1.5707964f, (float)this.getCornerradius(), (float)(right - this.getCornerradius()), (float)(bottom - this.getCornerradius()));
        vertices.put(corner);
        corner = GradientAndArcCalculator.getArcPoints(1.5707964f, (float)Math.PI, (float)this.getCornerradius(), (float)(right - this.getCornerradius()), (float)(top + this.getCornerradius()));
        vertices.put(corner);
        vertices.flip();
        return vertices;
    }

    public void drawBackground(MatrixStack matrixStack, FloatBuffer vertices) {
        this.drawBuffer(matrixStack, vertices, this.backgroundColour, 6);
    }

    public void drawBackground(MatrixStack matrixStack, FloatBuffer vertices, FloatBuffer colours) {
        this.drawBuffer(matrixStack, vertices, colours, 6);
    }

    public void drawBorder(MatrixStack matrixStack, FloatBuffer vertices) {
        this.drawBuffer(matrixStack, vertices, this.borderColour, 2);
    }

    public void setzLevel(float zLevel) {
        this.zLevel = zLevel;
    }

    void drawBuffer(MatrixStack matrixStack, FloatBuffer vertices, Colour colour, int glMode) {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(glMode, DefaultVertexFormats.field_181706_f);
        while (vertices.hasRemaining()) {
            buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), vertices.get(), vertices.get(), this.zLevel).func_227885_a_(colour.r, colour.g, colour.b, colour.a).func_181675_d();
        }
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    void drawBuffer(MatrixStack matrixStack, FloatBuffer vertices, FloatBuffer colours, int glMode) {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(glMode, DefaultVertexFormats.field_181706_f);
        while (vertices.hasRemaining() && colours.hasRemaining()) {
            buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), vertices.get(), vertices.get(), this.zLevel).func_227885_a_(colours.get(), colours.get(), colours.get(), colours.get()).func_181675_d();
        }
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public void draw(MatrixStack matrixStack, float zLevel) {
        this.zLevel = zLevel;
        FloatBuffer vertices = this.preDraw(0.0);
        if (this.backgroundColour2 != null) {
            FloatBuffer colours = GradientAndArcCalculator.getColourGradient(this.backgroundColour, this.backgroundColour2, vertices.limit() * 4);
            this.drawBackground(matrixStack, vertices, colours);
        } else {
            this.drawBackground(matrixStack, vertices);
        }
        if (this.shrinkBorder) {
            vertices = this.preDraw(1.0);
        } else {
            vertices.rewind();
        }
        this.drawBorder(matrixStack, vertices);
    }

    @Override
    public String toString() {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append(this.getClass()).append(":\n");
        stringbuilder.append("Center: ").append(this.center()).append("\n");
        stringbuilder.append("Left: ").append(this.left()).append("\n");
        stringbuilder.append("FinalLeft: ").append(this.finalLeft()).append("\n");
        stringbuilder.append("Right: ").append(this.right()).append("\n");
        stringbuilder.append("FinalRight: ").append(this.finalRight()).append("\n");
        stringbuilder.append("Bottom: ").append(this.bottom()).append("\n");
        stringbuilder.append("FinalBottom: ").append(this.finalBottom()).append("\n");
        stringbuilder.append("Top: ").append(this.top()).append("\n");
        stringbuilder.append("FinalTop: ").append(this.finalTop()).append("\n");
        stringbuilder.append("Width: ").append(this.left()).append("\n");
        stringbuilder.append("FinalWidthLeft: ").append(this.left()).append("\n");
        stringbuilder.append("Height: ").append(this.height()).append("\n");
        stringbuilder.append("FinalHeight: ").append(this.finalHeight()).append("\n");
        return stringbuilder.toString();
    }
}

