/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.gemoetry;

import com.github.lehjr.numina.util.client.gui.gemoetry.GradientAndArcCalculator;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.gui.gemoetry.MuseRelativeRect;
import com.github.lehjr.numina.util.math.Colour;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.FloatBuffer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.BufferUtils;

public class DrawableRelativeRect
extends MuseRelativeRect {
    Colour backgroundColour;
    Colour borderColour;
    Colour backgroundColour2 = null;
    float cornerradius = 3.0f;
    float zLevel = 1.0f;
    boolean shrinkBorder = true;

    public DrawableRelativeRect(double left, double top, double right, double bottom, boolean growFromMiddle, Colour backgroundColour, Colour borderColour) {
        super(left, top, right, bottom, growFromMiddle);
        this.backgroundColour = backgroundColour;
        this.borderColour = borderColour;
    }

    public DrawableRelativeRect(double left, double top, double right, double bottom, Colour backgroundColour, Colour borderColour) {
        super(left, top, right, bottom, false);
        this.backgroundColour = backgroundColour;
        this.borderColour = borderColour;
    }

    public DrawableRelativeRect(MusePoint2D ul, MusePoint2D br, Colour backgroundColour, Colour borderColour) {
        super(ul, br);
        this.backgroundColour = backgroundColour;
        this.borderColour = borderColour;
    }

    @Override
    public DrawableRelativeRect copyOf() {
        return new DrawableRelativeRect(super.left(), super.top(), super.right(), super.bottom(), this.ul != this.ulFinal || this.wh != this.whFinal, this.backgroundColour, this.borderColour);
    }

    @Override
    public DrawableRelativeRect setLeft(double value) {
        super.setLeft(value);
        return this;
    }

    @Override
    public DrawableRelativeRect setRight(double value) {
        super.setRight(value);
        return this;
    }

    @Override
    public DrawableRelativeRect setTop(double value) {
        super.setTop(value);
        return this;
    }

    @Override
    public DrawableRelativeRect setBottom(double value) {
        super.setBottom(value);
        return this;
    }

    @Override
    public DrawableRelativeRect setWidth(double value) {
        super.setWidth(value);
        return this;
    }

    @Override
    public DrawableRelativeRect setHeight(double value) {
        super.setHeight(value);
        return this;
    }

    public double getCornerradius() {
        return this.cornerradius;
    }

    public DrawableRelativeRect setBackgroundColour(Colour backgroundColour) {
        this.backgroundColour = backgroundColour;
        return this;
    }

    public DrawableRelativeRect setSecondBackgroundColour(Colour backgroundColour2In) {
        this.backgroundColour2 = backgroundColour2In;
        return this;
    }

    public DrawableRelativeRect setBorderColour(Colour borderColour) {
        this.borderColour = borderColour;
        return this;
    }

    public FloatBuffer preDraw(double shrinkBy) {
        return this.preDraw(this.left() + shrinkBy, this.top() + shrinkBy, this.right() - shrinkBy, this.bottom() - shrinkBy);
    }

    public FloatBuffer preDraw(double left, double top, double right, double bottom) {
        FloatBuffer corner = GradientAndArcCalculator.getArcPoints((float)Math.PI, 4.712389f, (float)this.getCornerradius(), (float)(left + this.getCornerradius()), (float)(top + this.getCornerradius()));
        FloatBuffer vertices = BufferUtils.createFloatBuffer((int)(corner.limit() * 4));
        vertices.put(corner);
        corner = GradientAndArcCalculator.getArcPoints(4.712389f, (float)Math.PI * 2, (float)this.getCornerradius(), (float)(left + this.getCornerradius()), (float)(bottom - this.getCornerradius()));
        vertices.put(corner);
        corner = GradientAndArcCalculator.getArcPoints(0.0f, 1.5707964f, (float)this.getCornerradius(), (float)(right - this.getCornerradius()), (float)(bottom - this.getCornerradius()));
        vertices.put(corner);
        corner = GradientAndArcCalculator.getArcPoints(1.5707964f, (float)Math.PI, (float)this.getCornerradius(), (float)(right - this.getCornerradius()), (float)(top + this.getCornerradius()));
        vertices.put(corner);
        vertices.flip();
        return vertices;
    }

    public void drawBackground(MatrixStack matrixStack, FloatBuffer vertices) {
        this.drawBuffer(matrixStack, vertices, this.backgroundColour, 6);
    }

    public void drawBackground(MatrixStack matrixStack, FloatBuffer vertices, FloatBuffer colours) {
        this.drawBuffer(matrixStack, vertices, colours, 6);
    }

    public void drawBorder(MatrixStack matrixStack, FloatBuffer vertices) {
        this.drawBuffer(matrixStack, vertices, this.borderColour, 2);
    }

    void drawBuffer(MatrixStack matrixStack, FloatBuffer vertices, Colour colour, int glMode) {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(glMode, DefaultVertexFormats.field_181706_f);
        while (vertices.hasRemaining()) {
            buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), vertices.get(), vertices.get(), this.zLevel).func_227885_a_(colour.r, colour.g, colour.b, colour.a).func_181675_d();
        }
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    void drawBuffer(MatrixStack matrix4f, FloatBuffer vertices, FloatBuffer colours, int glMode) {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(glMode, DefaultVertexFormats.field_181706_f);
        while (vertices.hasRemaining() && colours.hasRemaining()) {
            buffer.func_227888_a_(matrix4f.func_227866_c_().func_227870_a_(), vertices.get(), vertices.get(), this.zLevel).func_227885_a_(colours.get(), colours.get(), colours.get(), colours.get()).func_181675_d();
        }
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public void draw(MatrixStack matrixStack, float zLevel) {
        this.zLevel = zLevel;
        FloatBuffer vertices = this.preDraw(0.0);
        if (this.backgroundColour2 != null) {
            FloatBuffer colours = GradientAndArcCalculator.getColourGradient(this.backgroundColour, this.backgroundColour2, vertices.limit() * 4);
            this.drawBackground(matrixStack, vertices, colours);
        } else {
            this.drawBackground(matrixStack, vertices);
        }
        if (this.shrinkBorder) {
            vertices = this.preDraw(1.0);
        } else {
            vertices.rewind();
        }
        this.drawBorder(matrixStack, vertices);
    }
}

