/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.gemoetry;

import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.gui.gemoetry.MuseRelativeRect;
import com.github.lehjr.numina.util.math.Colour;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class DrawableTile
extends MuseRelativeRect {
    Colour topBorderColour = new Colour(0.216f, 0.216f, 0.216f, 1.0f);
    Colour bottomBorderColour = Colour.WHITE;
    Colour backgroundColour = new Colour(0.545f, 0.545f, 0.545f, 1.0f);
    float zLevel = 0.0f;
    float shrinkBoarderBy = 0.0f;

    public DrawableTile(double left, double top, double right, double bottom, boolean growFromMiddle) {
        super(left, top, right, bottom, growFromMiddle);
    }

    public DrawableTile(double left, double top, double right, double bottom) {
        super(left, top, right, bottom, false);
    }

    public DrawableTile(MusePoint2D ul, MusePoint2D br) {
        super(ul, br);
    }

    public DrawableTile setTopBorderColour(Colour topBorderColour) {
        this.topBorderColour = topBorderColour;
        return this;
    }

    public DrawableTile setBottomBorderColour(Colour bottomBorderColour) {
        this.bottomBorderColour = bottomBorderColour;
        return this;
    }

    public DrawableTile setBackgroundColour(Colour insideColour) {
        this.backgroundColour = insideColour;
        return this;
    }

    public DrawableTile setBorderShrinkValue(float shrinkBy) {
        this.shrinkBoarderBy = shrinkBy;
        return this;
    }

    @Override
    public DrawableTile copyOf() {
        return new DrawableTile(super.left(), super.top(), super.right(), super.bottom(), this.ul != this.ulFinal || this.wh != this.whFinal).setBackgroundColour(this.backgroundColour).setTopBorderColour(this.topBorderColour).setBottomBorderColour(this.bottomBorderColour);
    }

    void draw(MatrixStack matrix4f, Colour colour, int glMode, double shrinkBy) {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(glMode, DefaultVertexFormats.field_181706_f);
        buffer.func_227888_a_(matrix4f.func_227866_c_().func_227870_a_(), (float)(this.right() - shrinkBy), (float)(this.top() + shrinkBy), this.zLevel).func_227885_a_(colour.r, colour.g, colour.b, colour.a).func_181675_d();
        buffer.func_227888_a_(matrix4f.func_227866_c_().func_227870_a_(), (float)(this.left() + shrinkBy), (float)(this.top() + shrinkBy), this.zLevel).func_227885_a_(colour.r, colour.g, colour.b, colour.a).func_181675_d();
        buffer.func_227888_a_(matrix4f.func_227866_c_().func_227870_a_(), (float)(this.left() + shrinkBy), (float)(this.bottom() - shrinkBy), this.zLevel).func_227885_a_(colour.r, colour.g, colour.b, colour.a).func_181675_d();
        buffer.func_227888_a_(matrix4f.func_227866_c_().func_227870_a_(), (float)(this.right() - shrinkBy), (float)(this.bottom() - shrinkBy), this.zLevel).func_227885_a_(colour.r, colour.g, colour.b, colour.a).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public void drawBackground(MatrixStack matrixStack) {
        this.draw(matrixStack, this.backgroundColour, 7, 0.0);
    }

    public void drawBorder(MatrixStack matrixStack, double shrinkBy) {
        this.draw(matrixStack, this.topBorderColour, 2, shrinkBy);
    }

    public void drawDualColourBorder(MatrixStack matrixStack, float shrinkBy) {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        RenderSystem.lineWidth((float)2.0f);
        buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), (float)(this.right() - (double)shrinkBy), (float)(this.top() + (double)shrinkBy), this.zLevel).func_227885_a_(this.topBorderColour.r, this.topBorderColour.g, this.topBorderColour.b, this.topBorderColour.a).func_181675_d();
        buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), (float)(this.left() + (double)shrinkBy), (float)(this.top() + (double)shrinkBy), this.zLevel).func_227885_a_(this.topBorderColour.r, this.topBorderColour.g, this.topBorderColour.b, this.topBorderColour.a).func_181675_d();
        buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), (float)(this.left() + (double)shrinkBy), (float)(this.top() + (double)shrinkBy), this.zLevel).func_227885_a_(this.topBorderColour.r, this.topBorderColour.g, this.topBorderColour.b, this.topBorderColour.a).func_181675_d();
        buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), (float)(this.left() + (double)shrinkBy), (float)(this.bottom() - (double)shrinkBy), this.zLevel).func_227885_a_(this.topBorderColour.r, this.topBorderColour.g, this.topBorderColour.b, this.topBorderColour.a).func_181675_d();
        buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), (float)(this.left() + (double)shrinkBy), (float)(this.bottom() - (double)shrinkBy), this.zLevel).func_227885_a_(this.bottomBorderColour.r, this.bottomBorderColour.g, this.bottomBorderColour.b, this.bottomBorderColour.a).func_181675_d();
        buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), (float)(this.right() - (double)shrinkBy), (float)(this.bottom() - (double)shrinkBy), this.zLevel).func_227885_a_(this.bottomBorderColour.r, this.bottomBorderColour.g, this.bottomBorderColour.b, this.bottomBorderColour.a).func_181675_d();
        buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), (float)(this.right() - (double)shrinkBy), (float)(this.bottom() - (double)shrinkBy), this.zLevel).func_227885_a_(this.bottomBorderColour.r, this.bottomBorderColour.g, this.bottomBorderColour.b, this.bottomBorderColour.a).func_181675_d();
        buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), (float)(this.right() - (double)shrinkBy), (float)(this.top() + (double)shrinkBy), this.zLevel).func_227885_a_(this.bottomBorderColour.r, this.bottomBorderColour.g, this.bottomBorderColour.b, this.bottomBorderColour.a).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public void draw(MatrixStack matrixStack, float zLevel) {
        this.zLevel = zLevel;
        this.drawBackground(matrixStack);
        if (this.topBorderColour == this.bottomBorderColour) {
            this.drawBorder(matrixStack, this.shrinkBoarderBy);
        } else {
            this.drawDualColourBorder(matrixStack, this.shrinkBoarderBy);
        }
    }

    @Override
    public String toString() {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append(this.getClass()).append(":\n");
        stringbuilder.append("Center: ").append(this.center()).append("\n");
        stringbuilder.append("Left: ").append(this.left()).append("\n");
        stringbuilder.append("FinalLeft: ").append(this.finalLeft()).append("\n");
        stringbuilder.append("Right: ").append(this.right()).append("\n");
        stringbuilder.append("FinalRight: ").append(this.finalRight()).append("\n");
        stringbuilder.append("Bottom: ").append(this.bottom()).append("\n");
        stringbuilder.append("FinalBottom: ").append(this.finalBottom()).append("\n");
        stringbuilder.append("Top: ").append(this.top()).append("\n");
        stringbuilder.append("FinalTop: ").append(this.finalTop()).append("\n");
        stringbuilder.append("Width: ").append(this.left()).append("\n");
        stringbuilder.append("FinalWidthLeft: ").append(this.left()).append("\n");
        stringbuilder.append("Height: ").append(this.height()).append("\n");
        stringbuilder.append("FinalHeight: ").append(this.finalHeight()).append("\n");
        return stringbuilder.toString();
    }
}

