/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.gemoetry;

import com.github.lehjr.numina.util.client.gui.gemoetry.DrawableMuseRect;
import com.github.lehjr.numina.util.client.gui.gemoetry.GradientAndArcCalculator;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.math.Colour;
import com.github.lehjr.numina.util.math.MuseMathUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.nio.FloatBuffer;

public class Meter
extends DrawableMuseRect {
    Colour meterColour;
    double value = 0.0;

    public Meter(Colour meterColourIn) {
        super(new MusePoint2D(0.0, 0.0), new MusePoint2D(0.0, 0.0), Colour.GREY.withAlpha(0.3f), Colour.BLACK.withAlpha(0.8f));
        this.setWidth(32.0);
        this.setHeight(8.0);
        this.setSecondBackgroundColour(Colour.WHITE.withAlpha(0.3f));
        this.setShrinkBorder(true);
        this.meterColour = meterColourIn;
    }

    public Meter setMeterColour(Colour meterColourIn) {
        this.meterColour = meterColourIn;
        return this;
    }

    void setUL(double x, double y) {
        this.setTop(y);
        this.setLeft(x);
    }

    @Override
    public double getCornerradius() {
        return 0.0;
    }

    public void draw(MatrixStack matrixStack, double x, double y, float zLevel, double valueIn) {
        this.setUL(x, y);
        this.value = MuseMathUtils.clampDouble(valueIn, 0.0, 1.0);
        this.draw(matrixStack, zLevel);
    }

    FloatBuffer getMeterVertices() {
        float right = (float)(this.finalLeft() + (this.finalWidth() - 1.0) * this.value);
        return this.preDraw(this.finalLeft() + 1.0, this.finalTop() + 1.0, right, this.finalBottom() - 1.0);
    }

    @Override
    public void draw(MatrixStack matrixStack, float zLevel) {
        this.zLevel = zLevel;
        FloatBuffer backgroundVertices = this.preDraw(0.0);
        FloatBuffer backgroundColours = GradientAndArcCalculator.getColourGradient(this.backgroundColour, this.backgroundColour2, backgroundVertices.limit() * 4);
        this.drawBackground(matrixStack, backgroundVertices, backgroundColours);
        FloatBuffer meterVertices = this.getMeterVertices();
        this.drawBuffer(matrixStack, meterVertices, this.meterColour, 6);
        if (this.shrinkBorder) {
            backgroundVertices = this.preDraw(1.0);
        } else {
            backgroundVertices.rewind();
        }
        this.drawBorder(matrixStack, backgroundVertices);
    }
}

