/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.gemoetry;

import com.github.lehjr.numina.util.client.gui.gemoetry.FlyFromPointToPoint2D;
import com.github.lehjr.numina.util.client.gui.gemoetry.IRect;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;

public class MuseRect
implements IRect {
    MusePoint2D ulFinal;
    MusePoint2D whFinal;
    MusePoint2D ul;
    MusePoint2D wh;
    final boolean growFromMiddle;

    public MuseRect(double left, double top, double right, double bottom, boolean growFromMiddle) {
        this.ulFinal = new MusePoint2D(left, top);
        this.whFinal = new MusePoint2D(right - left, bottom - top);
        this.ul = this.ulFinal.copy();
        this.wh = this.whFinal.copy();
        this.growFromMiddle = growFromMiddle;
    }

    @Override
    public void setTargetDimensions(double left, double top, double right, double bottom) {
        this.ulFinal = new MusePoint2D(left, top);
        this.whFinal = new MusePoint2D(right - left, bottom - top);
        this.grow();
    }

    @Override
    public void setTargetDimensions(MusePoint2D ul, MusePoint2D wh) {
        this.ulFinal = ul;
        this.whFinal = wh;
        this.grow();
    }

    public MuseRect(double left, double top, double right, double bottom) {
        this(left, top, right, bottom, false);
    }

    public MuseRect(MusePoint2D ul, MusePoint2D br, boolean growFromMiddle) {
        this.ulFinal = this.ul = ul;
        this.whFinal = this.wh = br.minus(ul);
        this.growFromMiddle = growFromMiddle;
    }

    public MuseRect(MusePoint2D ul, MusePoint2D br) {
        this.ulFinal = this.ul = ul;
        this.whFinal = this.wh = br.minus(ul);
        this.growFromMiddle = false;
    }

    void grow() {
        if (this.growFromMiddle) {
            MusePoint2D center = this.ulFinal.plus(this.whFinal.times(0.5));
            this.ul = new FlyFromPointToPoint2D(center, this.ulFinal, 200.0);
            this.wh = new FlyFromPointToPoint2D(new MusePoint2D(0.0, 0.0), this.whFinal, 200.0);
        } else {
            this.ul = this.ulFinal.copy();
            this.wh = this.whFinal.copy();
        }
    }

    public MuseRect copyOf() {
        return new MuseRect(this.left(), this.top(), this.right(), this.bottom(), this.ul != this.ulFinal || this.wh != this.whFinal);
    }

    @Override
    public MusePoint2D getUL() {
        return this.ul;
    }

    @Override
    public MusePoint2D getULFinal() {
        return this.ulFinal;
    }

    @Override
    public MusePoint2D getWH() {
        return this.wh;
    }

    @Override
    public MusePoint2D getWHFinal() {
        return this.whFinal;
    }

    @Override
    public double left() {
        return this.ul.getX();
    }

    @Override
    public double finalLeft() {
        return this.ulFinal.getX();
    }

    @Override
    public double top() {
        return this.ul.getY();
    }

    @Override
    public double finalTop() {
        return this.ulFinal.getY();
    }

    @Override
    public double right() {
        return this.ul.getX() + this.wh.getX();
    }

    @Override
    public double finalRight() {
        return this.ulFinal.getX() + this.whFinal.getX();
    }

    @Override
    public double bottom() {
        return this.ul.getY() + this.wh.getY();
    }

    @Override
    public double finalBottom() {
        return this.ulFinal.getY() + this.whFinal.getY();
    }

    @Override
    public double width() {
        return this.wh.getX();
    }

    @Override
    public double finalWidth() {
        return this.whFinal.getX();
    }

    @Override
    public double height() {
        return this.wh.getY();
    }

    @Override
    public double finalHeight() {
        return this.whFinal.getY();
    }

    @Override
    public IRect setLeft(double value) {
        this.ul.setX(value);
        this.ulFinal.setX(value);
        return this;
    }

    @Override
    public IRect setRight(double value) {
        this.wh.setX(value - this.ul.getX());
        this.whFinal.setX(value - this.ulFinal.getX());
        return this;
    }

    @Override
    public IRect setTop(double value) {
        this.ul.setY(value);
        this.ulFinal.setY(value);
        return this;
    }

    @Override
    public IRect setBottom(double value) {
        this.wh.setY(value - this.ul.getY());
        this.whFinal.setY(value - this.ulFinal.getY());
        return this;
    }

    @Override
    public IRect setWidth(double value) {
        this.wh.setX(value);
        this.whFinal.setX(value);
        return this;
    }

    @Override
    public IRect setHeight(double value) {
        this.wh.setY(value);
        this.whFinal.setY(value);
        return this;
    }

    @Override
    public void move(MusePoint2D moveAmount) {
        this.ulFinal = this.whFinal.plus(moveAmount);
        this.whFinal = this.whFinal.plus(moveAmount);
        this.grow();
    }

    @Override
    public void move(double x, double y) {
        this.ulFinal = this.whFinal.plus(x, y);
        this.whFinal = this.whFinal.plus(x, y);
        this.grow();
    }

    @Override
    public void setPosition(MusePoint2D position) {
        this.ulFinal = position.minus(this.whFinal.times(0.5));
        this.grow();
    }

    @Override
    public boolean growFromMiddle() {
        return this.growFromMiddle;
    }

    public String toString() {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append(this.getClass()).append(":\n");
        stringbuilder.append("Center: ").append(this.center()).append("\n");
        stringbuilder.append("Left: ").append(this.left()).append("\n");
        stringbuilder.append("FinalLeft: ").append(this.finalLeft()).append("\n");
        stringbuilder.append("Right: ").append(this.right()).append("\n");
        stringbuilder.append("FinalRight: ").append(this.finalRight()).append("\n");
        stringbuilder.append("Bottom: ").append(this.bottom()).append("\n");
        stringbuilder.append("FinalBottom: ").append(this.finalBottom()).append("\n");
        stringbuilder.append("Top: ").append(this.top()).append("\n");
        stringbuilder.append("FinalTop: ").append(this.finalTop()).append("\n");
        stringbuilder.append("Width: ").append(this.left()).append("\n");
        stringbuilder.append("FinalWidthLeft: ").append(this.left()).append("\n");
        stringbuilder.append("Height: ").append(this.height()).append("\n");
        stringbuilder.append("FinalHeight: ").append(this.finalHeight()).append("\n");
        return stringbuilder.toString();
    }
}

