/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.gemoetry;

import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.gui.gemoetry.MuseRect;

public class MuseRelativeRect
extends MuseRect {
    protected MuseRect rectBelowMe;
    protected MuseRect rectAboveMe;
    protected MuseRect rectLeftOfMe;
    protected MuseRect rectRightOfMe;
    protected double leftPadding = 0.0;
    protected double topPadding = 0.0;
    protected double rightPadding = 0.0;
    protected double bottomPadding = 0.0;

    public MuseRelativeRect(double left, double top, double right, double bottom) {
        super(left, top, right, bottom);
    }

    public MuseRelativeRect(double left, double top, double right, double bottom, boolean growFromMiddle) {
        super(left, top, right, bottom, growFromMiddle);
    }

    public MuseRelativeRect(MusePoint2D ul, MusePoint2D br) {
        super(ul, br);
    }

    @Override
    public double left() {
        if (this.rectLeftOfMe != null) {
            return this.rectLeftOfMe.right() + this.leftPadding;
        }
        return this.ul.getX();
    }

    @Override
    public double top() {
        if (this.rectAboveMe != null) {
            return this.rectAboveMe.bottom() + this.topPadding;
        }
        return this.ul.getY();
    }

    @Override
    public double right() {
        if (this.rectRightOfMe != null) {
            return this.rectRightOfMe.left() + this.rightPadding;
        }
        return this.left() + this.wh.getX();
    }

    @Override
    public double bottom() {
        if (this.rectBelowMe != null) {
            return this.rectBelowMe.top() + this.bottomPadding;
        }
        return this.top() + this.wh.getY();
    }

    @Override
    public MuseRelativeRect copyOf() {
        return new MuseRelativeRect(this.left(), this.top(), this.right(), this.bottom(), this.ul != this.ulFinal || this.wh != this.whFinal);
    }

    public MuseRelativeRect setMeLeftof(MuseRect otherRightOfMe) {
        this.rectRightOfMe = otherRightOfMe;
        return this;
    }

    public MuseRelativeRect setMeRightOf(MuseRect otherLeftOfMe) {
        this.rectLeftOfMe = otherLeftOfMe;
        return this;
    }

    public MuseRelativeRect setMeAbove(MuseRect otherBelowMe) {
        this.rectBelowMe = otherBelowMe;
        return this;
    }

    public MuseRelativeRect setMeBelow(MuseRect otherAboveMe) {
        this.rectAboveMe = otherAboveMe;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append(this.getClass()).append(":\n");
        stringbuilder.append("Center: ").append(this.center()).append("\n");
        stringbuilder.append("Left: ").append(this.left()).append("\n");
        stringbuilder.append("FinalLeft: ").append(this.finalLeft()).append("\n");
        stringbuilder.append("Right: ").append(this.right()).append("\n");
        stringbuilder.append("FinalRight: ").append(this.finalRight()).append("\n");
        stringbuilder.append("Bottom: ").append(this.bottom()).append("\n");
        stringbuilder.append("FinalBottom: ").append(this.finalBottom()).append("\n");
        stringbuilder.append("Top: ").append(this.top()).append("\n");
        stringbuilder.append("FinalTop: ").append(this.finalTop()).append("\n");
        stringbuilder.append("Width: ").append(this.left()).append("\n");
        stringbuilder.append("FinalWidthLeft: ").append(this.left()).append("\n");
        stringbuilder.append("Height: ").append(this.height()).append("\n");
        stringbuilder.append("FinalHeight: ").append(this.finalHeight()).append("\n");
        return stringbuilder.toString();
    }
}

