/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.gemoetry;

import com.github.lehjr.numina.util.client.gui.gemoetry.GradientAndArcCalculator;
import com.github.lehjr.numina.util.math.Colour;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.FloatBuffer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;

public class SwirlyMuseCircle {
    public static final float detail = 2.0f;
    protected FloatBuffer points;
    protected FloatBuffer colour;
    int numsegments;

    public SwirlyMuseCircle(Colour c1, Colour c2) {
        if (this.points == null) {
            this.points = GradientAndArcCalculator.getArcPoints(0.0f, 6.283285f, 2.0f, 0.0f, 0.0f);
        }
        this.numsegments = this.points.limit() / 2;
        this.colour = GradientAndArcCalculator.getColourGradient(c1, c2, this.points.limit() / 2);
    }

    public void draw(MatrixStack matrixStack, double radius, double x, double y, float zLevel) {
        float ratio = (float)(System.currentTimeMillis() % 2000L) / 2000.0f;
        this.colour.rewind();
        this.points.rewind();
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)x, (double)y, (double)0.0);
        RenderSystem.scaled((double)(radius / 2.0), (double)(radius / 2.0), (double)1.0);
        RenderSystem.rotatef((float)((float)((double)(-ratio) * 360.0)), (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        while (this.points.hasRemaining() && this.colour.hasRemaining()) {
            buffer.func_227888_a_(matrix4f, this.points.get(), this.points.get(), zLevel).func_227885_a_(this.colour.get(), this.colour.get(), this.colour.get(), this.colour.get()).func_181675_d();
        }
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
        RenderSystem.popMatrix();
    }
}

