/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.slot;

import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.client.gui.clickable.IClickable;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.gui.slot.UniversalSlot;
import com.github.lehjr.numina.util.client.render.MuseIconUtils;
import com.github.lehjr.numina.util.client.render.MuseRenderer;
import com.github.lehjr.numina.util.math.Colour;
import com.github.lehjr.numina.util.string.MuseStringUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.IItemHandler;

public class ClickableModuleSlot
extends UniversalSlot
implements IClickable {
    protected IClickable.IPressable onPressed;
    protected IClickable.IReleasable onReleased;
    boolean isVisible = true;
    boolean isEnabled = true;
    final Colour checkmarkcolour = new Colour(0.0f, 0.667f, 0.0f, 1.0f);
    public static final int offsetx = 8;
    public static final int offsety = 8;
    boolean allowed = true;
    boolean installed = false;

    public ClickableModuleSlot(IInventory inventory, int index, int xPosition, int yPosition) {
        this(inventory, index, new MusePoint2D(xPosition, yPosition));
    }

    public ClickableModuleSlot(IInventory inventory, int index, MusePoint2D position) {
        super(inventory, index, (int)position.getX(), (int)position.getY());
    }

    public ClickableModuleSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        this(itemHandler, index, new MusePoint2D(xPosition, yPosition));
    }

    public ClickableModuleSlot(IItemHandler itemHandler, int index, MusePoint2D position) {
        super(itemHandler, index, (int)position.getX(), (int)position.getY());
    }

    @Override
    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks, float zLevel) {
        if (!this.func_75211_c().func_190926_b()) {
            MuseRenderer.drawItemAt(this.getPosition().getX() - 8.0, this.getPosition().getY() - 8.0, this.func_75211_c());
            if (!this.allowed) {
                String string = MuseStringUtils.wrapFormatTags("x", MuseStringUtils.FormatCodes.DarkRed);
                MuseRenderer.drawString(matrixStack, string, this.getPosition().getX() + 3.0, this.getPosition().getY() + 1.0);
            } else if (this.installed) {
                MuseIconUtils.getIcon().checkmark.draw(matrixStack, this.getPosition().getX() - 8.0 + 1.0, this.getPosition().getY() - 8.0 + 1.0, this.checkmarkcolour);
            }
        }
    }

    @Override
    public void move(MusePoint2D position) {
        this.position = position;
    }

    @Override
    public void move(double x, double y) {
        this.position.setX(x);
        this.position.setY(y);
    }

    @Override
    public MusePoint2D getPosition() {
        return this.position;
    }

    @Override
    public boolean hitBox(double x, double y) {
        boolean hitx = Math.abs(x - this.position.getX()) < 8.0;
        boolean hity = Math.abs(y - this.position.getY()) < 8.0;
        return hitx && hity;
    }

    @Override
    public List<ITextComponent> getToolTip() {
        ArrayList<ITextComponent> toolTipText = new ArrayList<ITextComponent>();
        toolTipText.add(this.getLocalizedName());
        toolTipText.addAll(MuseStringUtils.wrapITextComponentToLength(this.getLocalizedDescription(), 30));
        return toolTipText;
    }

    @Override
    public boolean func_111238_b() {
        return super.func_111238_b() && this.isEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void onReleased() {
        if (this.isVisible && this.isEnabled && this.onReleased != null) {
            this.onReleased.onReleased(this);
        }
    }

    @Override
    public void onPressed() {
        if (this.isVisible && this.isEnabled && this.onPressed != null) {
            this.onPressed.onPressed(this);
        }
    }

    public ITextComponent getLocalizedName() {
        if (this.func_75211_c().func_190926_b()) {
            return null;
        }
        return this.func_75211_c().func_200301_q();
    }

    public ITextComponent getLocalizedDescription() {
        if (this.func_75211_c().func_190926_b()) {
            return null;
        }
        return new TranslationTextComponent(this.func_75211_c().func_77977_a().concat(".desc"));
    }

    public EnumModuleCategory getCategory() {
        return this.func_75211_c().getCapability(PowerModuleCapability.POWER_MODULE).map(m -> m.getCategory()).orElse(EnumModuleCategory.NONE);
    }

    public boolean equals(ClickableModuleSlot other) {
        return this.func_75211_c().func_77969_a(other.func_75211_c());
    }

    public void setAllowed(boolean allowed) {
        this.allowed = allowed;
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    @Override
    public void setOnPressed(IClickable.IPressable onPressed) {
        this.onPressed = onPressed;
    }

    @Override
    public void setOnReleased(IClickable.IReleasable onReleased) {
        this.onReleased = onReleased;
    }
}

