/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.gui.slot;

import com.github.lehjr.numina.util.client.gui.clickable.IClickable;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class UniversalSlot
extends Slot
implements IClickable {
    private static IInventory emptyInventory = new Inventory(0);
    private final IItemHandler itemHandler;
    public static final int offsetx = 8;
    public static final int offsety = 8;
    protected IClickable.IPressable onPressed;
    protected IClickable.IReleasable onReleased;
    protected final int field_75223_e = 0;
    protected final int field_75221_f = 0;
    private final int index;
    protected final boolean isIItemHandler;
    protected MusePoint2D position;
    boolean isVisible;
    boolean isEnabled;

    public UniversalSlot(IInventory inventory, int index, int xPosition, int yPosition) {
        this(inventory, index, new MusePoint2D(xPosition, yPosition));
    }

    public UniversalSlot(IInventory inventory, int index, MusePoint2D position) {
        super(inventory, index, (int)position.getX(), (int)position.getX());
        this.index = index;
        this.position = position;
        this.itemHandler = new ItemStackHandler();
        this.isIItemHandler = false;
    }

    public UniversalSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        this(itemHandler, index, new MusePoint2D(xPosition, yPosition));
    }

    public UniversalSlot(IItemHandler itemHandler, int index, MusePoint2D position) {
        super(emptyInventory, index, (int)position.getX(), (int)position.getX());
        this.position = position;
        this.itemHandler = itemHandler;
        this.index = index;
        this.isIItemHandler = true;
        this.isVisible = true;
        this.isEnabled = true;
    }

    public boolean func_75214_a(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (!this.isIItemHandler) {
            return super.func_75214_a(stack);
        }
        return this.itemHandler.isItemValid(this.index, stack);
    }

    public int func_75219_a() {
        if (!this.isIItemHandler) {
            return super.func_75219_a();
        }
        return this.itemHandler.getSlotLimit(this.index);
    }

    public int func_178170_b(@Nonnull ItemStack stack) {
        if (!this.isIItemHandler) {
            return super.func_178170_b(stack);
        }
        ItemStack maxAdd = stack.func_77946_l();
        int maxInput = stack.func_77976_d();
        maxAdd.func_190920_e(maxInput);
        IItemHandler handler = this.getItemHandler();
        ItemStack currentStack = handler.getStackInSlot(this.index);
        if (handler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable handlerModifiable = (IItemHandlerModifiable)handler;
            handlerModifiable.setStackInSlot(this.index, ItemStack.field_190927_a);
            ItemStack remainder = handlerModifiable.insertItem(this.index, maxAdd, true);
            handlerModifiable.setStackInSlot(this.index, currentStack);
            return maxInput - remainder.func_190916_E();
        }
        ItemStack remainder = handler.insertItem(this.index, maxAdd, true);
        int current = currentStack.func_190916_E();
        int added = maxInput - remainder.func_190916_E();
        return current + added;
    }

    public boolean isIItemHandler() {
        return this.isIItemHandler;
    }

    public boolean func_82869_a(PlayerEntity playerIn) {
        if (!this.isIItemHandler) {
            return true;
        }
        return !this.getItemHandler().extractItem(this.index, 1, true).func_190926_b();
    }

    @Nonnull
    public ItemStack func_75209_a(int amount) {
        if (!this.isIItemHandler) {
            return super.func_75209_a(amount);
        }
        return this.getItemHandler().extractItem(this.index, amount, false);
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public IInventory getInventoryHandler() {
        return this.field_75224_c;
    }

    @Override
    public void setPosition(MusePoint2D position) {
        this.position = position;
    }

    @Nonnull
    public ItemStack func_75211_c() {
        if (!this.isIItemHandler) {
            return super.func_75211_c();
        }
        return this.getItemHandler().getStackInSlot(this.index);
    }

    public void func_75215_d(@Nonnull ItemStack stack) {
        if (!this.isIItemHandler) {
            super.func_75215_d(stack);
        } else {
            ((IItemHandlerModifiable)this.getItemHandler()).setStackInSlot(this.index, stack);
        }
        this.func_75218_e();
    }

    public void func_75220_a(@Nonnull ItemStack p_75220_1_, @Nonnull ItemStack p_75220_2_) {
    }

    @Override
    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks, float zLevel) {
    }

    @Override
    public MusePoint2D getPosition() {
        return this.position;
    }

    @Override
    public void move(double x, double y) {
        System.out.println("FIXME... behaviour change coming!!");
        this.position.setX(x);
        this.position.setY(y);
    }

    @Override
    public boolean hitBox(double x, double y) {
        boolean hitx = Math.abs(x - this.position.getX()) < 8.0;
        boolean hity = Math.abs(y - this.position.getY()) < 8.0;
        return hitx && hity;
    }

    @Override
    public List<ITextComponent> getToolTip() {
        return null;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void setOnPressed(IClickable.IPressable onPressed) {
        this.onPressed = onPressed;
    }

    @Override
    public void setOnReleased(IClickable.IReleasable onReleased) {
        this.onReleased = onReleased;
    }

    @Override
    public void onReleased() {
        if (this.isVisible && this.isEnabled && this.onReleased != null) {
            this.onReleased.onReleased(this);
        }
    }

    @Override
    public void onPressed() {
        if (this.isVisible && this.isEnabled && this.onPressed != null) {
            this.onPressed.onPressed(this);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public boolean func_111238_b() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }
}

