/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.client.render;

import com.github.lehjr.numina.util.client.gui.clickable.IClickable;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.gui.gemoetry.SwirlyMuseCircle;
import com.github.lehjr.numina.util.client.render.BillboardHelper;
import com.github.lehjr.numina.util.client.render.NuminaRenderState;
import com.github.lehjr.numina.util.math.Colour;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.world.World;

public abstract class MuseRenderer {
    protected static SwirlyMuseCircle selectionCircle;
    static boolean messagedAboutSlick;

    public static ItemRenderer getItemRenderer() {
        return Minecraft.func_71410_x().func_175599_af();
    }

    public TextureManager getTextureManager() {
        return Minecraft.func_71410_x().func_110434_K();
    }

    static IBakedModel getItemModelWithOverrides(@Nonnull ItemStack itemStack) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        return MuseRenderer.getItemRenderer().func_184393_a(itemStack, player.field_70170_p, (LivingEntity)player);
    }

    public static void drawCircleAround(MatrixStack matrixStack, double xoffset, double yoffset, double radius, float zLevel) {
        if (selectionCircle == null) {
            selectionCircle = new SwirlyMuseCircle(new Colour(0.0f, 1.0f, 0.0f, 0.0f), new Colour(0.8f, 1.0f, 0.8f, 1.0f));
        }
        selectionCircle.draw(matrixStack, radius, xoffset, yoffset, zLevel);
    }

    public static void drawModuleAt(MatrixStack matrixStackIn, double x, double y, @Nonnull ItemStack itemStack, boolean active) {
        if (!itemStack.func_190926_b()) {
            IBakedModel model = MuseRenderer.getItemModelWithOverrides(itemStack);
            MuseRenderer.renderItemModelIntoGUI(itemStack, matrixStackIn, (float)x, (float)y, model, active ? Colour.WHITE : Colour.DARK_GREY.withAlpha(0.5f));
        }
    }

    public static void drawItemAt(double x, double y, @Nonnull ItemStack itemStack) {
        if (!itemStack.func_190926_b()) {
            MuseRenderer.getItemRenderer().func_180450_b(itemStack, (int)x, (int)y);
            MuseRenderer.getItemRenderer().func_180453_a(MuseRenderer.getFontRenderer(), itemStack, (int)x, (int)y, (String)null);
        }
    }

    public static void drawItemAt(MatrixStack matrixStack, double x, double y, @Nonnull ItemStack itemStack, Colour colour) {
        if (!itemStack.func_190926_b()) {
            Minecraft.func_71410_x().func_175599_af().func_180450_b(itemStack, (int)x, (int)y);
            Minecraft.func_71410_x().func_175599_af().func_180453_a(MuseRenderer.getFontRenderer(), itemStack, (int)x, (int)y, (String)null);
        }
    }

    private void renderItemIntoGUI(@Nullable LivingEntity livingEntity, MatrixStack matrixStack, ItemStack stack, float x, float y, Colour colour) {
        if (!stack.func_190926_b()) {
            MuseRenderer.getItemRenderer().field_77023_b += 50.0f;
            try {
                MuseRenderer.renderItemModelIntoGUI(stack, matrixStack, x, y, MuseRenderer.getItemRenderer().func_184393_a(stack, (World)null, livingEntity), colour);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Rendering item");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Item being rendered");
                crashreportcategory.func_189529_a("Item Type", () -> String.valueOf(stack.func_77973_b()));
                crashreportcategory.func_189529_a("Registry Name", () -> String.valueOf(stack.func_77973_b().getRegistryName()));
                crashreportcategory.func_189529_a("Item Damage", () -> String.valueOf(stack.func_77952_i()));
                crashreportcategory.func_189529_a("Item NBT", () -> String.valueOf(stack.func_77978_p()));
                crashreportcategory.func_189529_a("Item Foil", () -> String.valueOf(stack.func_77962_s()));
                throw new ReportedException(crashreport);
            }
            MuseRenderer.getItemRenderer().field_77023_b -= 50.0f;
        }
    }

    protected static void renderItemModelIntoGUI(ItemStack stack, MatrixStack matrixStack, float x, float y, IBakedModel bakedmodel, Colour colour) {
        boolean flag;
        RenderSystem.pushMatrix();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        Minecraft.func_71410_x().func_110434_K().func_229267_b_(AtlasTexture.field_110575_b).func_174937_a(false, false);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)colour.r, (float)colour.g, (float)colour.b, (float)colour.a);
        RenderSystem.translatef((float)x, (float)y, (float)(100.0f + Minecraft.func_71410_x().func_175599_af().field_77023_b));
        RenderSystem.translatef((float)8.0f, (float)8.0f, (float)0.0f);
        RenderSystem.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
        RenderSystem.scalef((float)16.0f, (float)16.0f, (float)16.0f);
        IRenderTypeBuffer.Impl bufferSource = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        boolean bl = flag = !bakedmodel.func_230044_c_();
        if (flag) {
            RenderHelper.func_227783_c_();
        }
        Minecraft.func_71410_x().func_175599_af().func_229111_a_(stack, ItemCameraTransforms.TransformType.GUI, false, matrixStack, (IRenderTypeBuffer)bufferSource, 0xF000F0, OverlayTexture.field_229196_a_, bakedmodel);
        bufferSource.func_228461_a_();
        RenderSystem.enableDepthTest();
        if (flag) {
            RenderHelper.func_227784_d_();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.popMatrix();
    }

    public void renderItemOverlayIntoGUI(MatrixStack matrixStack, FontRenderer fr, ItemStack stack, int xPosition, int yPosition, @Nullable String text) {
        if (!stack.func_190926_b()) {
            ClientPlayerEntity clientplayerentity;
            float f3;
            if (stack.func_190916_E() != 1 || text != null) {
                String s = text == null ? String.valueOf(stack.func_190916_E()) : text;
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(0.0, 0.0, (double)(Minecraft.func_71410_x().func_175599_af().field_77023_b + 200.0f));
                IRenderTypeBuffer.Impl typeBuffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                fr.func_228079_a_(s, (float)(xPosition + 19 - 2 - fr.func_78256_a(s)), (float)(yPosition + 6 + 3), 0xFFFFFF, true, matrixStack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)typeBuffer, false, 0, 0xF000F0);
                typeBuffer.func_228461_a_();
                matrixStack.func_227865_b_();
            }
            if (stack.func_77973_b().showDurabilityBar(stack)) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.disableAlphaTest();
                RenderSystem.disableBlend();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                double health = stack.func_77973_b().getDurabilityForDisplay(stack);
                int i = Math.round(13.0f - (float)health * 13.0f);
                int j = stack.func_77973_b().getRGBDurabilityForDisplay(stack);
                this.draw(bufferbuilder, matrixStack.func_227866_c_().func_227870_a_(), xPosition + 2, yPosition + 13, 13.0f, 2, 0, 0, 0, 255);
                this.draw(bufferbuilder, matrixStack.func_227866_c_().func_227870_a_(), xPosition + 2, yPosition + 13, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
                RenderSystem.enableBlend();
                RenderSystem.enableAlphaTest();
                RenderSystem.enableTexture();
                RenderSystem.enableDepthTest();
            }
            float f = f3 = (clientplayerentity = Minecraft.func_71410_x().field_71439_g) == null ? 0.0f : clientplayerentity.func_184811_cZ().func_185143_a(stack.func_77973_b(), Minecraft.func_71410_x().func_184121_ak());
            if (f3 > 0.0f) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                Tessellator tessellator1 = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder1 = tessellator1.func_178180_c();
                this.draw(bufferbuilder1, matrixStack.func_227866_c_().func_227870_a_(), xPosition, yPosition + MathHelper.func_76141_d((float)(16.0f * (1.0f - f3))), 16.0f, MathHelper.func_76123_f((float)(16.0f * f3)), 255, 255, 255, 127);
                RenderSystem.enableTexture();
                RenderSystem.enableDepthTest();
            }
        }
    }

    private void draw(BufferBuilder renderer, Matrix4f matrix4f, float x, float y, float width, int height, int red, int green, int blue, int alpha) {
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_227888_a_(matrix4f, x + 0.0f, y + 0.0f, 0.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_227888_a_(matrix4f, x + 0.0f, y + (float)height, 0.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_227888_a_(matrix4f, x + width, y + (float)height, 0.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_227888_a_(matrix4f, x + width, y + 0.0f, 0.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void drawString(MatrixStack matrixStack, String s, double x, double y) {
        MuseRenderer.drawString(matrixStack, s, x, y, Colour.WHITE);
    }

    public static void drawString(MatrixStack matrixStack, String s, double x, double y, Colour c) {
        MuseRenderer.getFontRenderer().func_238405_a_(matrixStack, s, (float)((int)x), (float)((int)y), c.getInt());
    }

    public static void drawCenteredString(MatrixStack matrixStack, String s, double x, double y) {
        MuseRenderer.drawString(matrixStack, s, x - MuseRenderer.getStringWidth(s) / 2.0, y);
    }

    public static void drawRightAlignedString(MatrixStack matrixStack, String s, double x, double y) {
        MuseRenderer.drawString(matrixStack, s, x - MuseRenderer.getStringWidth(s), y);
    }

    public static void drawLeftAlignedStringString(MatrixStack matrixStack, String s, double x, double y) {
        MuseRenderer.drawString(matrixStack, s, x, y);
    }

    public static double getStringWidth(String s) {
        NuminaRenderState.glPushAttrib(262144);
        double stringWidth = MuseRenderer.getFontRenderer().func_78256_a(s);
        RenderSystem.popAttributes();
        return stringWidth;
    }

    public static void drawStringsJustified(MatrixStack matrixStack, List<String> words, double x1, double x2, double y) {
        int totalwidth = 0;
        for (String word : words) {
            totalwidth = (int)((double)totalwidth + MuseRenderer.getStringWidth(word));
        }
        double spacing = (x2 - x1 - (double)totalwidth) / (double)(words.size() - 1);
        double currentwidth = 0.0;
        for (String word : words) {
            MuseRenderer.drawString(matrixStack, word, x1 + currentwidth, y);
            currentwidth += MuseRenderer.getStringWidth(word) + spacing;
        }
    }

    public static FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    public static void drawText(MatrixStack matrixStack, ITextComponent component, double x, double y, Colour colour) {
        MuseRenderer.getFontRenderer().func_243248_b(matrixStack, component, (float)x, (float)y, colour.getInt());
    }

    public static void drawCenteredText(MatrixStack matrixStack, ITextComponent component, double x, double y, Colour colour) {
        MuseRenderer.drawCenteredText(matrixStack, component, (float)x, (float)y, colour);
    }

    public static void drawCenteredText(MatrixStack matrixStack, ITextComponent component, float x, float y, Colour colour) {
        MuseRenderer.getFontRenderer().func_243248_b(matrixStack, component, x - (float)(MuseRenderer.getFontRenderer().func_238414_a_((ITextProperties)component) / 2), y, colour.getInt());
    }

    public static void drawLineBetween(IClickable firstClickable, IClickable secondClickable, Colour gradientColour, float zLevel) {
        MusePoint2D secondpoint;
        MusePoint2D firstpoint;
        long varia = System.currentTimeMillis() % 2000L - 1000L;
        float gradientRatio = 1.0f - (float)((varia + 1000L) % 1000L) / 1000.0f;
        MusePoint2D midpoint = firstClickable.getPosition().minus(secondClickable.getPosition()).times((float)Math.abs((double)varia / 1000.0)).plus(secondClickable.getPosition());
        if (varia < 0L) {
            firstpoint = secondClickable.getPosition();
            secondpoint = firstClickable.getPosition();
        } else {
            firstpoint = firstClickable.getPosition();
            secondpoint = secondClickable.getPosition();
        }
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        buffer.func_225582_a_(midpoint.getX(), midpoint.getY(), (double)(zLevel + 10.0f)).func_227885_a_(gradientColour.r, gradientColour.g, gradientColour.b, gradientRatio).func_181675_d();
        buffer.func_225582_a_(firstpoint.getX(), firstpoint.getY(), (double)(zLevel + 10.0f)).func_227885_a_(gradientColour.r, gradientColour.g, gradientColour.b, 0.0f).func_181675_d();
        buffer.func_225582_a_(secondpoint.getX(), secondpoint.getY(), (double)(zLevel + 10.0f)).func_227885_a_(gradientColour.r, gradientColour.g, gradientColour.b, gradientRatio).func_181675_d();
        buffer.func_225582_a_(midpoint.getX(), midpoint.getY(), (double)(zLevel + 10.0f)).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void unRotate() {
        BillboardHelper.unRotate();
    }

    static {
        messagedAboutSlick = false;
    }
}

