/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.energy;

import com.github.lehjr.numina.util.energy.BlackList;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraftforge.energy.CapabilityEnergy;

public class ElectricItemUtils {
    public static int getPlayerEnergy(LivingEntity entity) {
        int avail = 0;
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            avail += ElectricItemUtils.getItemEnergy(entity.func_184582_a(slot));
        }
        return avail;
    }

    public static int getMaxPlayerEnergy(LivingEntity entity) {
        int avail = 0;
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            avail += ElectricItemUtils.getMaxItemEnergy(entity.func_184582_a(slot));
        }
        return avail;
    }

    public static int drainPlayerEnergy(LivingEntity entity, int drainAmount) {
        if (entity.field_70170_p.field_72995_K || entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71075_bZ.field_75098_d) {
            return 0;
        }
        int drainleft = drainAmount;
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            if (drainleft == 0) break;
            ItemStack stack = entity.func_184582_a(slot);
            Item item = stack.func_77973_b();
            if (stack.func_190926_b() || !(item instanceof ToolItem) || BlackList.blacklistModIds.contains(item.getRegistryName().func_110624_b())) continue;
            drainleft -= ElectricItemUtils.drainItem(stack, drainleft);
        }
        return drainAmount - drainleft;
    }

    public static int givePlayerEnergy(LivingEntity entity, int rfToGive) {
        int rfLeft = rfToGive;
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            if (rfLeft <= 0) break;
            rfLeft -= ElectricItemUtils.chargeItem(entity.func_184582_a(slot), rfLeft);
        }
        return rfToGive - rfLeft;
    }

    public static int drainItem(@Nonnull ItemStack itemStack, int drainAmount) {
        return itemStack.getCapability(CapabilityEnergy.ENERGY).map(energyHandler -> energyHandler.extractEnergy(drainAmount, false)).orElse(0);
    }

    public static int getItemEnergy(@Nonnull ItemStack itemStack) {
        return itemStack.getCapability(CapabilityEnergy.ENERGY).map(energyHandler -> energyHandler.getEnergyStored()).orElse(0);
    }

    public static int getMaxItemEnergy(@Nonnull ItemStack itemStack) {
        return itemStack.getCapability(CapabilityEnergy.ENERGY).map(energyHandler -> energyHandler.getMaxEnergyStored()).orElse(0);
    }

    public static int chargeItem(@Nonnull ItemStack itemStack, int chargeAmount) {
        return itemStack.getCapability(CapabilityEnergy.ENERGY).map(energyHandler -> energyHandler.receiveEnergy(chargeAmount, false)).orElse(0);
    }
}

