/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.helper;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.ToolType;

public class ToolHelpers {
    public static boolean isToolEffective(IBlockReader world, BlockPos pos, @Nonnull ItemStack emulatedTool) {
        BlockState state = world.func_180495_p(pos);
        if (Float.compare(state.func_185887_b(world, pos), -1.0f) < 0) {
            return false;
        }
        if (emulatedTool.func_77973_b().func_150897_b(state)) {
            return true;
        }
        ToolType harvestTool = state.func_177230_c().getHarvestTool(state);
        if (harvestTool != null) {
            for (ToolType type : emulatedTool.func_77973_b().getToolTypes(emulatedTool)) {
                if (!state.func_177230_c().isToolEffective(state, type) && (!Objects.equals(harvestTool, type) || emulatedTool.func_77973_b().getHarvestLevel(emulatedTool, harvestTool, null, null) < state.func_177230_c().getHarvestLevel(state))) continue;
                return true;
            }
        } else if (Float.compare(emulatedTool.func_150997_a(state), 1.0f) >= 0) {
            return true;
        }
        return false;
    }

    public static boolean blockCheckAndHarvest(PlayerEntity player, World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == null || world.func_175623_d(pos) || block == Blocks.field_150357_h) {
            return false;
        }
        if ((block instanceof IForgeShearable || block instanceof FlowerBlock || block instanceof BushBlock || block instanceof LeavesBlock) && block.canHarvestBlock(state, (IBlockReader)world, pos, player) || block == Blocks.field_150433_aE || block == Blocks.field_196604_cC) {
            block.func_180657_a(world, player, pos, state, world.func_175625_s(pos), new ItemStack((IItemProvider)Items.field_151037_a));
            world.func_217377_a(pos, false);
            return true;
        }
        return false;
    }
}

