/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.numina.util.player;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.biome.Biome;

public final class PlayerUtils {
    public static void resetFloatKickTicks(PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)player).field_71135_a.field_147365_f = 0;
        }
    }

    public static void teleportEntity(PlayerEntity PlayerEntity2, RayTraceResult rayTraceResult) {
        if (rayTraceResult != null && PlayerEntity2 instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)PlayerEntity2;
            if (player.field_71135_a.field_147371_a.func_150724_d()) {
                switch (rayTraceResult.func_216346_c()) {
                    case ENTITY: {
                        player.func_70634_a(rayTraceResult.func_216347_e().field_72450_a, rayTraceResult.func_216347_e().field_72448_b, rayTraceResult.func_216347_e().field_72449_c);
                        break;
                    }
                    case BLOCK: {
                        double hitx = rayTraceResult.func_216347_e().field_72450_a;
                        double hity = rayTraceResult.func_216347_e().field_72448_b;
                        double hitz = rayTraceResult.func_216347_e().field_72449_c;
                        switch (((BlockRayTraceResult)rayTraceResult).func_216354_b()) {
                            case DOWN: {
                                hity -= 2.0;
                                break;
                            }
                            case UP: {
                                break;
                            }
                            case NORTH: {
                                hitx -= 0.5;
                                break;
                            }
                            case SOUTH: {
                                hitx += 0.5;
                                break;
                            }
                            case WEST: {
                                hitz += 0.5;
                                break;
                            }
                            case EAST: {
                                hitz -= 0.5;
                            }
                        }
                        player.func_70634_a(hitx, hity, hitz);
                        break;
                    }
                }
            }
        }
    }

    public static float getPlayerCoolingBasedOnMaterial(@Nonnull PlayerEntity player) {
        if (player.func_180799_ab()) {
            return 0.0f;
        }
        float cool = 2.0f - PlayerUtils.getBiome(player).func_225486_c(new BlockPos((int)player.func_226277_ct_(), (int)player.func_226278_cu_(), (int)player.func_226281_cx_())) / 2.0f;
        if (player.func_70090_H()) {
            cool = (float)((double)cool + 0.5);
        }
        if ((int)player.func_226278_cu_() > 128) {
            cool = (float)((double)cool + 0.5);
        }
        if (!player.field_70170_p.func_72935_r() && PlayerUtils.getBiome(player).func_201856_r() == Biome.Category.DESERT) {
            cool = (float)((double)cool + 0.8);
        }
        if (player.field_70170_p.func_226691_t_(player.func_233580_cy_()).func_201851_b() != Biome.RainType.NONE && player.field_70170_p.func_72896_J() && player.field_70170_p.func_175710_j(player.func_233580_cy_().func_177982_a(0, 1, 0))) {
            cool = (float)((double)cool + 0.2);
        }
        return cool;
    }

    public static Biome getBiome(PlayerEntity player) {
        return player.field_70170_p.func_226691_t_(player.func_233580_cy_());
    }
}

