/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.basemod;

import com.github.lehjr.numina.basemod.MuseLogger;
import com.github.lehjr.numina.config.ConfigHelper;
import com.github.lehjr.numina.util.capabilities.render.ModelSpecNBTCapability;
import com.google.common.collect.HashBiMap;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.util.ResourceLocation;

public class CosmeticPresetSaveLoad {
    static final String EXTENSION = "dat";
    static String configDirString = "";

    public static void setConfigDirString(String configDirStringIn) {
        configDirString = configDirStringIn;
    }

    static String getConfigDirString() {
        if (configDirString.isEmpty()) {
            configDirString = ConfigHelper.getConfigFolder((String)"powersuits").getAbsolutePath();
        }
        return configDirString;
    }

    public static Map<String, CompoundNBT> loadPresetsForItem(@Nonnull ItemStack itemStack) {
        return CosmeticPresetSaveLoad.loadPresetsForItem(itemStack.func_77973_b(), 0);
    }

    public static Map<String, CompoundNBT> loadPresetsForItem(Item item, int count) {
        final HashMap retmap = new HashMap();
        if (item == null || count > 4) {
            return HashBiMap.create(retmap);
        }
        String subfolder = item.getRegistryName().func_110623_a();
        Path directory = Paths.get(CosmeticPresetSaveLoad.getConfigDirString(), "cosmeticpresets", subfolder);
        if (Files.exists(directory, new LinkOption[0])) {
            try {
                Files.walkFileTree(directory, EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path selectedPath, BasicFileAttributes attrs) throws IOException {
                        if (selectedPath.getFileName().toString().endsWith(".dat")) {
                            String name = selectedPath.getFileName().toString().replaceFirst("[.][^.]+$", "");
                            CompoundNBT nbt = CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(selectedPath, new OpenOption[0]));
                            if (nbt != null && name != null && !name.isEmpty()) {
                                if (retmap.containsKey("id")) {
                                    System.out.println("MAP ALREADY HAS KEY");
                                }
                                if (retmap.containsValue(nbt)) {
                                    System.out.println("MAP ALREADY HAS VALUE");
                                }
                                retmap.put(name, nbt);
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (retmap.isEmpty()) {
            CosmeticPresetSaveLoad.copyPresetsFromJar(CosmeticPresetSaveLoad.getConfigDirString());
            return CosmeticPresetSaveLoad.loadPresetsForItem(item, count + 1);
        }
        return HashBiMap.create(retmap);
    }

    public static void copyPresetsFromJar(final String configDir) {
        FileSystem fileSystem = null;
        try {
            Path sourcePath;
            URI uri = CosmeticPresetSaveLoad.class.getResource("/data/powersuits/cosmeticpresets/").toURI();
            if ("jar".equals(uri.getScheme())) {
                if (fileSystem == null) {
                    try {
                        fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                    }
                    catch (FileSystemAlreadyExistsException lEx) {
                        fileSystem = FileSystems.getFileSystem(uri);
                    }
                }
                sourcePath = fileSystem.getPath("/", new String[0]);
                sourcePath = sourcePath.resolve("data/powersuits/cosmeticpresets");
            } else {
                sourcePath = Paths.get(uri);
            }
            Files.walkFileTree(sourcePath, EnumSet.noneOf(FileVisitOption.class), 10, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path selectedPath, BasicFileAttributes attrs) throws IOException {
                    if (selectedPath.getFileName().toString().endsWith(".dat")) {
                        Path subFolder = selectedPath.getParent().getFileName();
                        Path target = Paths.get(configDir, "cosmeticpresets", subFolder.toString(), selectedPath.getFileName().toString());
                        try {
                            if (!Files.exists(target.getParent(), new LinkOption[0])) {
                                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                            }
                            if (!Files.exists(target, new LinkOption[0])) {
                                Files.copy(selectedPath, target, new CopyOption[0]);
                            }
                        }
                        catch (Exception e) {
                            MuseLogger.logException((String)"Exception here: ", (Throwable)e);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception e) {
            MuseLogger.logException((String)"Something happened here: ", (Throwable)e);
        }
    }

    public static byte[] compressGZip(CompoundNBT nbt) {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        try {
            DataOutputStream dataoutputstream = new DataOutputStream(new GZIPOutputStream(bytearrayoutputstream));
            CompressedStreamTools.func_74800_a((CompoundNBT)nbt, (DataOutput)dataoutputstream);
            dataoutputstream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bytearrayoutputstream.toByteArray();
    }

    public static boolean savePreset(String presetName, @Nonnull ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        return itemStack.getCapability(ModelSpecNBTCapability.RENDER).map(spec -> {
            CompoundNBT renderTag = spec.getRenderTag().func_74737_b();
            if (renderTag != null) {
                return CosmeticPresetSaveLoad.savePreset(itemStack.func_77973_b().getRegistryName(), presetName, renderTag);
            }
            return false;
        }).orElse(false);
    }

    public static boolean savePreset(ResourceLocation registryNameIn, String nameIn, CompoundNBT cosmeticSettingsIn) {
        byte[] byteArray = CosmeticPresetSaveLoad.compressGZip(cosmeticSettingsIn);
        try {
            String subfolder = registryNameIn.func_110623_a();
            Path directory = Paths.get(CosmeticPresetSaveLoad.getConfigDirString(), "cosmeticpresets", subfolder);
            try {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
            catch (Exception e) {
                MuseLogger.logException((String)"Exception here: ", (Throwable)e);
            }
            Path fullPath = Paths.get(directory.toString(), nameIn + "." + EXTENSION);
            Files.write(fullPath, byteArray, new OpenOption[0]);
        }
        catch (Exception e) {
            MuseLogger.logException((String)"Failed to saveButton preset: ", (Throwable)e);
            return false;
        }
        return true;
    }
}

