/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.basemod;

import com.github.lehjr.numina.config.ConfigHelper;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleTarget;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.capabilities.module.rightclick.IRightClickModule;
import com.github.lehjr.numina.util.capabilities.module.rightclick.RightClickModule;
import com.github.lehjr.numina.util.capabilities.module.toggleable.IToggleableModule;
import com.github.lehjr.numina.util.capabilities.module.toggleable.ToggleableModule;
import com.github.lehjr.powersuits.basemod.CosmeticPresetSaveLoad;
import com.github.lehjr.powersuits.basemod.MPSObjects;
import com.github.lehjr.powersuits.client.control.KeybindKeyHandler;
import com.github.lehjr.powersuits.client.event.ClientTickHandler;
import com.github.lehjr.powersuits.client.event.ModelBakeEventHandler;
import com.github.lehjr.powersuits.client.event.RenderEventHandler;
import com.github.lehjr.powersuits.client.gui.modding.module.MPAWorkbenchGui;
import com.github.lehjr.powersuits.client.render.entity.LuxCapacitorEntityRenderer;
import com.github.lehjr.powersuits.client.render.entity.PlasmaBoltEntityRenderer;
import com.github.lehjr.powersuits.client.render.entity.RailGunBoltRenderer;
import com.github.lehjr.powersuits.client.render.entity.SpinningBladeEntityRenderer;
import com.github.lehjr.powersuits.config.MPSSettings;
import com.github.lehjr.powersuits.constants.MPSRegistryNames;
import com.github.lehjr.powersuits.event.HarvestEventHandler;
import com.github.lehjr.powersuits.event.MovementManager;
import com.github.lehjr.powersuits.event.PlayerUpdateHandler;
import com.github.lehjr.powersuits.network.MPSPackets;
import com.github.lehjr.powersuits.recipe.MPSRecipeConditionFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.inventory.container.WorkbenchContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkHooks;

@Mod(value="powersuits")
public class ModularPowersuits {
    public ModularPowersuits() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, MPSSettings.CLIENT_SPEC, ConfigHelper.setupConfigFile((String)"mpa-client-only.toml", (String)"powersuits").getAbsolutePath());
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, MPSSettings.SERVER_SPEC);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::setupClient);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new PlayerUpdateHandler());
        MinecraftForge.EVENT_BUS.register((Object)MovementManager.INSTANCE);
        MinecraftForge.EVENT_BUS.addListener(HarvestEventHandler::handleHarvestCheck);
        MinecraftForge.EVENT_BUS.addListener(HarvestEventHandler::handleBreakSpeed);
        MPSObjects.ITEMS.register(modEventBus);
        MPSObjects.BLOCKS.register(modEventBus);
        MPSObjects.TILE_TYPES.register(modEventBus);
        MPSObjects.ENTITY_TYPES.register(modEventBus);
        MPSObjects.CONTAINER_TYPES.register(modEventBus);
        modEventBus.addListener(event -> {
            new RuntimeException("Got config " + event.getConfig() + " name " + event.getConfig().getModId() + ":" + event.getConfig().getFileName());
            ModConfig config = event.getConfig();
            if (config.getSpec() == MPSSettings.SERVER_SPEC) {
                MPSSettings.getModuleConfig().setServerConfig(config);
                CosmeticPresetSaveLoad.setConfigDirString(config.getFullPath().getParent().toString());
                CosmeticPresetSaveLoad.copyPresetsFromJar(config.getFullPath().getParent().toString());
            }
        });
    }

    private void setup(FMLCommonSetupEvent event) {
        MPSPackets.registerMPAPackets();
        CraftingHelper.register((IConditionSerializer)MPSRecipeConditionFactory.Serializer.INSTANCE);
    }

    private void setupClient(FMLClientSetupEvent event) {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(ModelBakeEventHandler.INSTANCE::onModelBake);
        modEventBus.addListener(RenderEventHandler.INSTANCE::preTextureStitch);
        MinecraftForge.EVENT_BUS.register((Object)RenderEventHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new ClientTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)new KeybindKeyHandler());
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)MPSObjects.RAILGUN_BOLT_ENTITY_TYPE.get()), RailGunBoltRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)MPSObjects.LUX_CAPACITOR_ENTITY_TYPE.get()), LuxCapacitorEntityRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)MPSObjects.PLASMA_BALL_ENTITY_TYPE.get()), PlasmaBoltEntityRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)MPSObjects.SPINNING_BLADE_ENTITY_TYPE.get()), SpinningBladeEntityRenderer::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)MPSObjects.MPS_WORKBENCH_CONTAINER_TYPE.get()), MPAWorkbenchGui::new);
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<ItemStack> event) {
        if (!event.getCapabilities().containsKey(MPSRegistryNames.CLOCK_MODULE_REG) && ((ItemStack)event.getObject()).func_77973_b().equals(Items.field_151113_aN)) {
            ItemStack stack = (ItemStack)event.getObject();
            ToggleableModule clock = new ToggleableModule(stack, EnumModuleCategory.SPECIAL, EnumModuleTarget.HEADONLY, MPSSettings::getModuleConfig, true);
            event.addCapability(MPSRegistryNames.CLOCK_MODULE_REG, new ICapabilityProvider((IToggleableModule)clock){
                final /* synthetic */ IToggleableModule val$clock;
                {
                    this.val$clock = iToggleableModule;
                }

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    if (cap == PowerModuleCapability.POWER_MODULE) {
                        return LazyOptional.of(() -> this.val$clock);
                    }
                    return LazyOptional.empty();
                }
            });
        } else if (!event.getCapabilities().containsKey(MPSRegistryNames.COMPASS_MODULE_REG) && ((ItemStack)event.getObject()).func_77973_b().equals(Items.field_151111_aL)) {
            ItemStack stack = (ItemStack)event.getObject();
            ToggleableModule compass = new ToggleableModule(stack, EnumModuleCategory.SPECIAL, EnumModuleTarget.HEADONLY, MPSSettings::getModuleConfig, true);
            event.addCapability(MPSRegistryNames.COMPASS_MODULE_REG, new ICapabilityProvider((IToggleableModule)compass){
                final /* synthetic */ IToggleableModule val$compass;
                {
                    this.val$compass = iToggleableModule;
                }

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    if (cap == PowerModuleCapability.POWER_MODULE) {
                        return LazyOptional.of(() -> this.val$compass);
                    }
                    return LazyOptional.empty();
                }
            });
        } else if (!event.getCapabilities().containsKey(MPSRegistryNames.PORTABLE_WORKBENCH_MODULE_REG) && ((ItemStack)event.getObject()).func_77973_b().equals(Items.field_221734_cc)) {
            ItemStack stack = (ItemStack)event.getObject();
            TranslationTextComponent CONTAINER_NAME = new TranslationTextComponent("container.crafting");
            RightClickModule rightClick = new RightClickModule(stack, EnumModuleCategory.TOOL, EnumModuleTarget.TOOLONLY, MPSSettings::getModuleConfig, (ITextComponent)CONTAINER_NAME){
                final /* synthetic */ ITextComponent val$CONTAINER_NAME;
                {
                    this.val$CONTAINER_NAME = iTextComponent;
                    super(arg0, arg1, arg2, arg3);
                }

                public ActionResult onItemRightClick(ItemStack itemStackIn, World worldIn, PlayerEntity playerIn, Hand hand) {
                    if (!worldIn.func_201670_d()) {
                        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)new SimpleNamedContainerProvider((id, inventory, player) -> new WorkbenchContainer(id, inventory), this.val$CONTAINER_NAME));
                        return ActionResult.func_226248_a_((Object)itemStackIn);
                    }
                    return ActionResult.func_226249_b_((Object)itemStackIn);
                }
            };
            event.addCapability(MPSRegistryNames.PORTABLE_WORKBENCH_MODULE_REG, new ICapabilityProvider((IRightClickModule)rightClick){
                final /* synthetic */ IRightClickModule val$rightClick;
                {
                    this.val$rightClick = iRightClickModule;
                }

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    if (cap == PowerModuleCapability.POWER_MODULE) {
                        return LazyOptional.of(() -> this.val$rightClick);
                    }
                    return LazyOptional.empty();
                }
            });
        }
    }
}

