/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.client.event;

import com.github.lehjr.numina.util.capabilities.inventory.modechanging.IModeChangingItem;
import com.github.lehjr.numina.util.capabilities.inventory.modularitem.IModularItem;
import com.github.lehjr.numina.util.client.gui.meters.EnergyMeter;
import com.github.lehjr.numina.util.client.gui.meters.HeatMeter;
import com.github.lehjr.numina.util.client.gui.meters.PlasmaChargeMeter;
import com.github.lehjr.numina.util.client.gui.meters.WaterMeter;
import com.github.lehjr.numina.util.client.render.MuseRenderer;
import com.github.lehjr.numina.util.energy.ElectricItemUtils;
import com.github.lehjr.numina.util.heat.MuseHeatUtils;
import com.github.lehjr.numina.util.math.MuseMathUtils;
import com.github.lehjr.numina.util.string.MuseStringUtils;
import com.github.lehjr.powersuits.client.control.KeybindManager;
import com.github.lehjr.powersuits.client.gui.clickable.ClickableKeybinding;
import com.github.lehjr.powersuits.config.MPSSettings;
import com.github.lehjr.powersuits.constants.MPSRegistryNames;
import com.github.lehjr.powersuits.item.module.environmental.AutoFeederModule;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ClientTickHandler {
    protected HeatMeter heatMeter = null;
    protected HeatMeter energyMeter = null;
    protected WaterMeter waterMeter = null;
    protected PlasmaChargeMeter plasmaMeter = null;
    static final ItemStack food = new ItemStack((IItemProvider)Items.field_151083_be);
    MatrixStack matrixStack = new MatrixStack();

    @SubscribeEvent
    public void onPreClientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            for (ClickableKeybinding kb : KeybindManager.INSTANCE.getKeybindings()) {
                kb.doToggleTick();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderTickEvent(TickEvent.RenderTickEvent event) {
        ClientPlayerEntity player;
        int yBaseString;
        float yBaseIcon;
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71439_g == null) {
            return;
        }
        int yOffsetString = 18;
        float yOffsetIcon = 16.0f;
        if (MPSSettings.useGraphicalMeters()) {
            yBaseIcon = 150.0f;
            yBaseString = 155;
        } else {
            yBaseIcon = 26.0f;
            yBaseString = 32;
        }
        if (event.phase == TickEvent.Phase.END && (player = minecraft.field_71439_g) != null) {
            if (minecraft.func_71382_s() && minecraft.field_71462_r == null) {
                Minecraft mc = minecraft;
                MainWindow screen = mc.func_228018_at_();
                AtomicInteger index = new AtomicInteger(0);
                player.func_184582_a(EquipmentSlotType.HEAD).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(arg_0 -> this.lambda$onRenderTickEvent$0(yBaseString, yOffsetString, index, yBaseIcon, yOffsetIcon, (PlayerEntity)player, arg_0));
                float top = (float)screen.func_198087_p() / 2.0f - 16.0f;
                float left = screen.func_198107_o() - 34;
                float maxEnergy = ElectricItemUtils.getMaxPlayerEnergy((LivingEntity)player);
                float currEnergy = ElectricItemUtils.getPlayerEnergy((LivingEntity)player);
                String currEnergyStr = MuseStringUtils.formatNumberShort((double)currEnergy) + "FE";
                String maxEnergyStr = MuseStringUtils.formatNumberShort((double)maxEnergy);
                float maxHeat = (float)MuseHeatUtils.getPlayerMaxHeat((LivingEntity)player);
                float currHeat = (float)MuseHeatUtils.getPlayerHeat((LivingEntity)player);
                String currHeatStr = MuseStringUtils.formatNumberShort((double)currHeat);
                String maxHeatStr = MuseStringUtils.formatNumberShort((double)maxHeat);
                AtomicReference<Float> currWater = new AtomicReference<Float>(Float.valueOf(0.0f));
                AtomicReference<Float> maxWater = new AtomicReference<Float>(Float.valueOf(0.0f));
                AtomicReference<String> currWaterStr = new AtomicReference<String>("");
                AtomicReference<String> maxWaterStr = new AtomicReference<String>("");
                player.func_184582_a(EquipmentSlotType.CHEST).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(fh -> {
                    for (int i = 0; i < fh.getTanks(); ++i) {
                        maxWater.set(Float.valueOf(((Float)maxWater.get()).floatValue() + (float)fh.getTankCapacity(i)));
                        if (!(((Float)maxWater.get()).floatValue() > 0.0f)) continue;
                        FluidStack fluidStack = fh.getFluidInTank(i);
                        currWater.set(Float.valueOf(((Float)currWater.get()).floatValue() + (float)fluidStack.getAmount()));
                        this.waterMeter = new WaterMeter();
                        currWaterStr.set(MuseStringUtils.formatNumberShort((double)((Float)currWater.get()).floatValue()));
                        maxWaterStr.set(MuseStringUtils.formatNumberShort((double)((Float)maxWater.get()).floatValue()));
                    }
                });
                AtomicReference<Float> currentPlasma = new AtomicReference<Float>(Float.valueOf(0.0f));
                AtomicReference<Float> maxPlasma = new AtomicReference<Float>(Float.valueOf(0.0f));
                if (player.func_184587_cr()) {
                    player.func_184586_b(player.func_184600_cs()).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(arg_0 -> ClientTickHandler.lambda$onRenderTickEvent$2((PlayerEntity)player, currentPlasma, maxPlasma, arg_0));
                }
                float val = currentPlasma.get().floatValue();
                String currPlasmaStr = MuseStringUtils.formatNumberShort((double)((int)val)) + "%";
                String maxPlasmaStr = MuseStringUtils.formatNumberShort((double)maxPlasma.get().floatValue());
                if (MPSSettings.useGraphicalMeters()) {
                    int numMeters = 0;
                    if (maxEnergy > 0.0f) {
                        ++numMeters;
                        if (this.energyMeter == null) {
                            this.energyMeter = new EnergyMeter();
                        }
                    } else {
                        this.energyMeter = null;
                    }
                    if (maxHeat > 0.0f) {
                        ++numMeters;
                        if (this.heatMeter == null) {
                            this.heatMeter = new HeatMeter();
                        }
                    } else {
                        this.heatMeter = null;
                    }
                    if (maxWater.get().floatValue() > 0.0f && this.waterMeter != null) {
                        ++numMeters;
                    }
                    if (maxPlasma.get().floatValue() > 0.0f) {
                        ++numMeters;
                        if (this.plasmaMeter == null) {
                            this.plasmaMeter = new PlasmaChargeMeter();
                        }
                    } else {
                        this.plasmaMeter = null;
                    }
                    double stringX = left - 2.0f;
                    int totalMeters = numMeters;
                    if (this.energyMeter != null) {
                        this.energyMeter.draw(this.matrixStack, left, top + (float)((totalMeters - numMeters) * 8), currEnergy / maxEnergy, 0.0f);
                        MuseRenderer.drawRightAlignedString((MatrixStack)this.matrixStack, (String)currEnergyStr, (double)stringX, (double)top);
                        --numMeters;
                    }
                    if (this.heatMeter != null) {
                        this.heatMeter.draw(this.matrixStack, left, top + (float)((totalMeters - numMeters) * 8), MuseMathUtils.clampFloat((float)currHeat, (float)0.0f, (float)maxHeat) / maxHeat, 0.0f);
                        MuseRenderer.drawRightAlignedString((MatrixStack)this.matrixStack, (String)currHeatStr, (double)stringX, (double)(top + (float)((totalMeters - numMeters) * 8)));
                        --numMeters;
                    }
                    if (this.waterMeter != null) {
                        this.waterMeter.draw(this.matrixStack, left, top + (float)((totalMeters - numMeters) * 8), MuseMathUtils.clampFloat((float)currWater.get().floatValue(), (float)0.0f, (float)maxWater.get().floatValue()) / maxWater.get().floatValue(), 0.0f);
                        MuseRenderer.drawRightAlignedString((MatrixStack)this.matrixStack, (String)currWaterStr.get(), (double)stringX, (double)(top + (float)((totalMeters - numMeters) * 8)));
                        --numMeters;
                    }
                    if (this.plasmaMeter != null) {
                        this.plasmaMeter.draw(this.matrixStack, left, top + (float)((totalMeters - numMeters) * 8), currentPlasma.get().floatValue() / maxPlasma.get().floatValue(), 0.0f);
                        MuseRenderer.drawRightAlignedString((MatrixStack)this.matrixStack, (String)currPlasmaStr, (double)stringX, (double)(top + (float)((totalMeters - numMeters) * 8)));
                    }
                } else {
                    int numReadouts = 0;
                    if (maxEnergy > 0.0f) {
                        MuseRenderer.drawString((MatrixStack)this.matrixStack, (String)(currEnergyStr + '/' + maxEnergyStr + " \u1d60"), (double)2.0, (double)2.0);
                        ++numReadouts;
                    }
                    MuseRenderer.drawString((MatrixStack)this.matrixStack, (String)(currHeatStr + '/' + maxHeatStr + " C"), (double)2.0, (double)(2 + numReadouts * 9));
                    ++numReadouts;
                    if (maxWater.get().floatValue() > 0.0f) {
                        MuseRenderer.drawString((MatrixStack)this.matrixStack, (String)(currWaterStr.get() + '/' + maxWaterStr.get() + " buckets"), (double)2.0, (double)(2 + numReadouts * 9));
                        ++numReadouts;
                    }
                    if (maxPlasma.get().floatValue() > 0.0f) {
                        MuseRenderer.drawString((MatrixStack)this.matrixStack, (String)(currPlasmaStr + '/' + maxPlasmaStr + "%"), (double)2.0, (double)(2 + numReadouts * 9));
                    }
                }
            }
        }
    }

    private static /* synthetic */ void lambda$onRenderTickEvent$2(PlayerEntity player, AtomicReference currentPlasma, AtomicReference maxPlasma, IItemHandler modechanging) {
        if (!(modechanging instanceof IModeChangingItem)) {
            return;
        }
        ItemStack module = ((IModeChangingItem)modechanging).getActiveModule();
        int actualCount = 0;
        int maxDuration = ((IModeChangingItem)modechanging).getModularItemStack().func_77988_m();
        if (!module.func_190926_b()) {
            if (module.func_77973_b().getRegistryName().equals((Object)MPSRegistryNames.PLASMA_CANNON_MODULE_REGNAME)) {
                actualCount = maxDuration - player.func_184605_cv();
                currentPlasma.set(Float.valueOf(((Float)currentPlasma.get()).floatValue() + (float)((actualCount > 50 ? 50 : actualCount) * 2)));
                maxPlasma.set(Float.valueOf(((Float)maxPlasma.get()).floatValue() + 100.0f));
            } else {
                actualCount = maxDuration - player.func_184605_cv();
                currentPlasma.set(Float.valueOf(((Float)currentPlasma.get()).floatValue() + (float)(actualCount > 40 ? 40 : actualCount) * 2.5f));
                maxPlasma.set(Float.valueOf(((Float)maxPlasma.get()).floatValue() + 100.0f));
            }
        }
    }

    private /* synthetic */ void lambda$onRenderTickEvent$0(int yBaseString, int yOffsetString, AtomicInteger index, float yBaseIcon, float yOffsetIcon, PlayerEntity player, IItemHandler h) {
        ItemStack compass;
        ItemStack clock;
        if (!(h instanceof IModularItem)) {
            return;
        }
        ItemStack autoFeeder = ((IModularItem)h).getOnlineModuleOrEmpty(MPSRegistryNames.AUTO_FEEDER_MODULE_REG);
        if (!autoFeeder.func_190926_b()) {
            AutoFeederModule cfr_ignored_0 = (AutoFeederModule)autoFeeder.func_77973_b();
            int foodLevel = (int)AutoFeederModule.getFoodLevel(autoFeeder);
            String num = MuseStringUtils.formatNumberShort((double)foodLevel);
            MuseRenderer.drawString((MatrixStack)this.matrixStack, (String)num, (double)17.0, (double)(yBaseString + yOffsetString * index.get()));
            MuseRenderer.drawItemAt((double)-1.0, (double)(yBaseIcon + yOffsetIcon * (float)index.get()), (ItemStack)food);
            index.addAndGet(1);
        }
        if (!(clock = ((IModularItem)h).getOnlineModuleOrEmpty(Items.field_151113_aN.getRegistryName())).func_190926_b()) {
            String ampm;
            long time = player.field_70170_p.func_72820_D();
            long hour = time % 24000L / 1000L;
            if (MPSSettings.use24HourClock()) {
                hour = hour < 19L ? (hour += 6L) : (hour -= 18L);
                ampm = "h";
            } else {
                if (hour < 6L) {
                    hour += 6L;
                    ampm = " AM";
                } else if (hour == 6L) {
                    hour = 12L;
                    ampm = " PM";
                } else if (hour > 6L && hour < 18L) {
                    hour -= 6L;
                    ampm = " PM";
                } else if (hour == 18L) {
                    hour = 12L;
                    ampm = " AM";
                } else {
                    hour -= 18L;
                    ampm = " AM";
                }
                MuseRenderer.drawString((MatrixStack)this.matrixStack, (String)(hour + ampm), (double)17.0, (double)(yBaseString + yOffsetString * index.get()));
                MuseRenderer.drawItemAt((double)-1.0, (double)(yBaseIcon + yOffsetIcon * (float)index.get()), (ItemStack)clock);
                index.addAndGet(1);
            }
        }
        if (!(compass = ((IModularItem)h).getOnlineModuleOrEmpty(Items.field_151111_aL.getRegistryName())).func_190926_b()) {
            MuseRenderer.drawItemAt((double)-1.0, (double)(yBaseIcon + yOffsetIcon * (float)index.get()), (ItemStack)compass);
            index.addAndGet(1);
        }
    }
}

